/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.math;

import java.util.Arrays;
import org.apache.commons.lang3.math.NumberUtils;

public class MathUtils {
    public static final double PI = Math.PI;

    public static long mean(long[] values) {
        if (values.length <= 0) {
            throw new IllegalArgumentException("Array contains no elements");
        }
        long sum = 0L;
        for (long v : values) {
            sum += v;
        }
        return sum / (long)values.length;
    }

    public static double median(int[] values) {
        Arrays.sort(values);
        double median = values.length % 2 == 0 ? ((double)values[values.length / 2] + (double)values[values.length / 2 - 1]) / 2.0 : (double)values[values.length / 2];
        return median;
    }

    public static int mode(int[] values) {
        int maxValue = 0;
        int maxCount = 0;
        for (int value : values) {
            int count = 0;
            for (int value2 : values) {
                if (value2 != value) continue;
                ++count;
            }
            if (count <= maxCount) continue;
            maxCount = count;
            maxValue = value;
        }
        return maxValue;
    }

    public static boolean hasNoRange(int num1, int num2, int difference) {
        if (num1 == num2) {
            return true;
        }
        if (num1 > num2 && num1 - num2 <= 0) {
            return true;
        }
        return num2 > num1 && num2 - num1 <= 0;
    }

    public static boolean isNumeric(String str) {
        return NumberUtils.isNumber((String)str);
    }

    public static boolean isNegative(double num) {
        return num < 0.0;
    }

    public static double makePositive(double num) {
        if (num >= 0.0) {
            return num;
        }
        return -num;
    }

    public static double makeNegative(double num) {
        if (num <= 0.0) {
            return num;
        }
        return -num;
    }
}

