/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.world.jurdstrees.algorythms;

import java.util.ArrayList;
import org.jurassicraft.common.world.jurdstrees.algorythms.Feature;
import org.jurassicraft.common.world.jurdstrees.algorythms.Shape;
import org.jurassicraft.common.world.jurdstrees.algorythms.Tree;
import org.jurassicraft.common.world.jurdstrees.algorythms.TreeBlock;

public class TreeCompendium {
    public static ArrayList<Tree> TreeList = new ArrayList();
    public static ArrayList<Shape> ShapeList = new ArrayList();

    public static void addShapesToCompendium() {
        int j;
        int i;
        Shape shape = new Shape(1);
        shape.addInsPointWithLeaves(0, 1, 0, TreeBlock.Rotation.none);
        shape.addLog(0, 2, 0);
        shape.addInsPoint(0, 3, 0, 0);
        shape.addInsPointWithLeaves(0, 4, 0, TreeBlock.Rotation.none);
        shape.addLog(0, 5, 0);
        shape.addLog(0, 6, 0);
        shape.addInsPointWithLeaves(0, 7, 0, TreeBlock.Rotation.none);
        shape.addInsPointWithTrunk(0, 8, 0, 0, TreeBlock.Rotation.none);
        ShapeList.add(shape);
        shape = new Shape(2);
        shape.addLog(0, 0, 1, 3);
        shape.addLog(-1, 0, 0, 3);
        shape.addLog(1, 0, 0, 3);
        shape.addLog(0, 0, -1, 3);
        ShapeList.add(shape);
        shape = new Shape(3);
        shape.addLog(1, 0, 0);
        shape.addLog(2, 1, 0);
        shape.addInsPointWithLeaves(3, 1, 0, TreeBlock.Rotation.east);
        shape.addLog(4, 1, -1);
        shape.addLog(4, 2, 1);
        shape.addLog(5, 0, -1);
        shape.addLog(5, 2, 1);
        shape.addLog(6, -1, 0);
        shape.addInsPointWithLeaves(6, 3, 2, TreeBlock.Rotation.east);
        shape.addInsPointWithLeaves(7, -1, 0, TreeBlock.Rotation.east);
        shape.addInsPointWithRotation(7, 3, 2, 0, TreeBlock.Rotation.east);
        ShapeList.add(shape);
        shape = new Shape(4);
        for (i = 0; i <= 1; ++i) {
            for (j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    shape.addLog(k, i, j);
                }
            }
        }
        for (i = -1; i <= 1; ++i) {
            for (j = -1; j <= 1; ++j) {
                shape.addLog(i, 2, j);
                shape.addLog(i, j, 2);
                shape.addLog(i, j, -2);
            }
        }
        shape.addLog(2, 0, 0);
        shape.addLog(2, 1, 0);
        shape.addLog(2, -1, 0);
        shape.addLog(2, 0, 1);
        shape.addLog(2, 0, -1);
        shape.addLog(-2, 0, 0);
        shape.addLog(-2, 1, 0);
        shape.addLog(-2, -1, 0);
        shape.addLog(-2, 0, 1);
        shape.addLog(-2, 0, -1);
        ShapeList.add(shape);
        shape = new Shape(5);
        shape.addLog(0, 1, 0);
        shape.addLog(0, -1, 0);
        shape.addLog(0, 0, 1);
        shape.addLog(0, 0, -1);
        shape.addLog(0, 2, 0);
        shape.addLog(0, -2, 0);
        shape.addLog(0, 0, 2);
        shape.addLog(0, 0, -2);
        shape.addLog(0, 1, 1);
        shape.addLog(0, 1, -1);
        shape.addLog(0, -1, 1);
        shape.addLog(0, -1, -1);
        shape.addLog(2, 1, 0);
        shape.addLog(2, -1, 0);
        shape.addLog(2, 0, 1);
        shape.addLog(2, 0, -1);
        shape.addLog(-2, 1, 0);
        shape.addLog(-2, -1, 0);
        shape.addLog(-2, 0, 1);
        shape.addLog(-2, 0, -1);
        ShapeList.add(shape);
        shape = new Shape(6);
        shape.addInsPointWithLeaves(1, 0, 0, TreeBlock.Rotation.east);
        shape.addLog(2, 0, 0);
        shape.addInsPointWithLeaves(3, 2, -1, TreeBlock.Rotation.east);
        shape.addLog(4, 0, -1);
        shape.addLog(4, 0, -2);
        shape.addLog(5, 1, -1);
        shape.addInsPointWithLeaves(5, 1, 0, TreeBlock.Rotation.east);
        shape.addLog(6, 1, -2);
        shape.addInsPointWithLeaves(7, 1, -2, TreeBlock.Rotation.east);
        ShapeList.add(shape);
        shape = new Shape(7);
        shape.addLog(1, 0, 1);
        shape.addLog(2, 0, 2);
        shape.addLog(2, 1, 3);
        shape.addInsPointWithLeaves(2, 1, 4, TreeBlock.Rotation.east);
        shape.addLog(3, 1, 5);
        shape.addLog(4, 2, 6);
        shape.addInsPointWithLeaves(5, 3, 6, TreeBlock.Rotation.east);
        shape.addLog(6, 3, 6);
        shape.addLog(3, 0, 2);
        shape.addLog(4, 0, 2);
        shape.addLog(5, 1, 2);
        shape.addLog(6, 1, 1);
        shape.addLog(7, 2, 1);
        shape.addInsPointWithLeaves(7, 2, 0, TreeBlock.Rotation.east);
        shape.addLog(7, 1, -1);
        shape.addLog(8, 0, -1);
        shape.addLog(9, -1, -2);
        shape.addLog(8, 3, 2);
        shape.addLog(9, 4, 3);
        shape.addInsPointWithLeaves(10, 4, 3, TreeBlock.Rotation.east);
        shape.addLog(11, 4, 3);
        shape.addLog(12, 5, 4);
        shape.addInsPointWithLeaves(13, 5, 4, TreeBlock.Rotation.east);
        shape.addInsPointWithRotation(14, 5, 4, 0, TreeBlock.Rotation.east);
        ShapeList.add(shape);
        shape = new Shape(8);
        shape.addLog(1, 1, 1);
        shape.addLog(2, 1, 1);
        shape.addInsPointWithLeaves(3, 1, 1, TreeBlock.Rotation.east);
        shape.addLog(4, 2, 2);
        shape.addLog(4, 2, 3);
        shape.addLog(4, 2, 4);
        shape.addInsPointWithLeaves(5, 1, 5, TreeBlock.Rotation.east);
        shape.addLog(5, 1, 6);
        shape.addLog(5, 2, 2);
        shape.addLog(6, 3, 3);
        shape.addLog(7, 4, 4);
        shape.addInsPointWithLeaves(7, 5, 6, TreeBlock.Rotation.east);
        shape.addLog(6, 3, 1);
        shape.addLog(7, 3, 0);
        shape.addInsPointWithLeaves(7, 3, 0, TreeBlock.Rotation.east);
        shape.addInsPointWithRotation(8, 3, 0, 0, TreeBlock.Rotation.east);
        ShapeList.add(shape);
        shape = new Shape(9);
        shape.addLog(1, 0, 1);
        shape.addLog(2, 0, 2);
        shape.addInsPointWithLeaves(2, 1, 3, TreeBlock.Rotation.east);
        shape.addLog(1, 3, 3);
        shape.addLog(3, 2, 3);
        shape.addLog(3, 2, 4);
        shape.addInsPointWithLeaves(3, 3, 5, TreeBlock.Rotation.east);
        shape.addLog(2, 4, 6);
        shape.addLog(4, 4, 4);
        shape.addLog(5, 5, 4);
        shape.addLog(4, 5, 6);
        shape.addInsPointWithLeaves(5, 5, 7, TreeBlock.Rotation.east);
        shape.addInsPointWithRotation(6, 6, 8, 0, TreeBlock.Rotation.east);
        ShapeList.add(shape);
        shape = new Shape(10);
        shape.addLog(1, 0, 1);
        shape.addLog(2, 1, 2);
        shape.addLog(3, 1, 3);
        shape.addLog(4, 1, 3);
        shape.addInsPointWithLeaves(5, 1, 3, TreeBlock.Rotation.east);
        shape.addLog(3, 1, 4);
        shape.addLog(3, 1, 5);
        shape.addLog(4, 2, 6);
        shape.addInsPointWithLeaves(5, 3, 6, TreeBlock.Rotation.east);
        shape.addInsPointWithRotation(6, 3, 7, 0, TreeBlock.Rotation.east);
        ShapeList.add(shape);
        shape = new Shape(11);
        shape.addLog(1, 1, 0);
        shape.addInsPointWithLeaves(2, 1, 0, TreeBlock.Rotation.east);
        shape.addLog(3, 2, 0);
        shape.addInsPointWithLeaves(4, 2, 0, TreeBlock.Rotation.east);
        shape.addInsPointWithRotation(5, 3, 0, 0, TreeBlock.Rotation.east);
        ShapeList.add(shape);
        shape = new Shape(12);
        shape.addLog(1, 1, 0);
        shape.addInsPointWithLeaves(2, 1, 0, TreeBlock.Rotation.east);
        shape.addLog(3, 2, 0);
        shape.addInsPointWithLeaves(4, 2, 1, TreeBlock.Rotation.east);
        shape.addInsPointWithRotation(5, 3, 1, 0, TreeBlock.Rotation.east);
        ShapeList.add(shape);
        shape = new Shape(13);
        shape.addLog(1, 1, 1);
        shape.addInsPointWithLeaves(2, 1, 1, TreeBlock.Rotation.east);
        shape.addLog(3, 2, 2);
        shape.addInsPointWithLeaves(4, 2, 2, TreeBlock.Rotation.east);
        shape.addInsPointWithRotation(5, 3, 3, 0, TreeBlock.Rotation.east);
        ShapeList.add(shape);
        shape = new Shape(14);
        shape.addLog(1, 1, 1);
        shape.addInsPointWithLeaves(2, 1, 2, TreeBlock.Rotation.east);
        shape.addLog(3, 2, 3);
        shape.addInsPointWithLeaves(4, 2, 4, TreeBlock.Rotation.east);
        shape.addInsPointWithRotation(5, 3, 5, 0, TreeBlock.Rotation.east);
        ShapeList.add(shape);
        shape = new Shape(15);
        shape.addLog(1, 1, 1);
        shape.addInsPointWithLeaves(2, 1, 2, TreeBlock.Rotation.east);
        shape.addLog(3, 2, 3);
        shape.addInsPointWithLeaves(3, 2, 4, TreeBlock.Rotation.east);
        shape.addInsPointWithRotation(4, 3, 5, 0, TreeBlock.Rotation.east);
        ShapeList.add(shape);
        shape = new Shape(16);
        shape.addLog(1, 1, 1);
        shape.addInsPointWithLeaves(1, 1, 2, TreeBlock.Rotation.east);
        shape.addLog(2, 2, 3);
        shape.addInsPointWithLeaves(2, 2, 4, TreeBlock.Rotation.east);
        shape.addInsPointWithRotation(3, 3, 5, 0, TreeBlock.Rotation.east);
        ShapeList.add(shape);
        shape = new Shape(17);
        shape.addLog(1, 1, 1);
        shape.addInsPointWithLeaves(1, 1, 2, TreeBlock.Rotation.east);
        shape.addLog(2, 2, 3);
        shape.addInsPointWithLeaves(2, 2, 4, TreeBlock.Rotation.east);
        shape.addInsPointWithRotation(2, 3, 5, 0, TreeBlock.Rotation.east);
        ShapeList.add(shape);
        shape = new Shape(18);
        shape.addLog(1, 1, 1);
        shape.addInsPointWithLeaves(1, 1, 2, TreeBlock.Rotation.east);
        shape.addLog(1, 2, 3);
        shape.addInsPointWithLeaves(1, 2, 4, TreeBlock.Rotation.east);
        shape.addInsPointWithRotation(1, 3, 5, 0, TreeBlock.Rotation.east);
        ShapeList.add(shape);
        shape = new Shape(19);
        shape.addLog(-2, 0, 0);
        shape.addLog(-1, 0, 0);
        shape.addLog(-1, 1, 0);
        shape.addLog(0, -1, 0);
        shape.addLog(0, 0, 1);
        shape.addLog(0, 0, 2);
        shape.addLog(0, 0, -1);
        shape.addLog(0, 0, -2);
        shape.addLog(0, 1, 1);
        shape.addLog(0, 1, 0);
        shape.addLog(0, 1, -1);
        shape.addLog(0, 2, 0);
        shape.addLog(1, 0, 0);
        shape.addLog(1, 1, 0);
        shape.addLog(2, 0, 0);
        ShapeList.add(shape);
    }

    public static void registerTrees() {
        Tree tree = new Tree(2, 7, 3);
        tree.addFeatureList(new int[]{1, 1}, Feature.FeatureType.Trunk);
        tree.addFeatureList(new int[]{3, 6, 7, 8, 9, 10}, Feature.FeatureType.Branch);
        tree.addFeatureList(new int[]{5, 6}, Feature.FeatureType.Fruit);
        tree.addFeatureList(new int[]{4, 4}, Feature.FeatureType.leaves);
        tree.addFeatureList(new int[]{5, 5}, Feature.FeatureType.TrunkLeaves);
        tree.addFeatureList(new int[]{2, 2}, Feature.FeatureType.wood);
        TreeList.add(tree);
        tree = new Tree(1, 8, 4);
        tree.addFeatureList(new int[]{1, 1}, Feature.FeatureType.Trunk);
        tree.addFeatureList(new int[]{11, 12, 13, 14, 15, 16, 17, 18}, Feature.FeatureType.Branch);
        tree.addFeatureList(new int[]{5, 6}, Feature.FeatureType.Fruit);
        tree.addFeatureList(new int[]{19, 19}, Feature.FeatureType.leaves);
        tree.addFeatureList(new int[]{5, 5}, Feature.FeatureType.TrunkLeaves);
        tree.addFeatureList(new int[]{2, 2}, Feature.FeatureType.wood);
        TreeList.add(tree);
        tree = new Tree(0, 8, 4, 3, 3, 5);
        tree.addFeatureList(new int[]{1, 1}, Feature.FeatureType.Trunk);
        tree.addFeatureList(new int[]{11, 12, 13, 14, 15, 16, 17, 18}, Feature.FeatureType.Branch);
        tree.addFeatureList(new int[]{5, 6}, Feature.FeatureType.Fruit);
        tree.addFeatureList(new int[]{19, 19}, Feature.FeatureType.leaves);
        tree.addFeatureList(new int[]{5, 5}, Feature.FeatureType.TrunkLeaves);
        tree.addFeatureList(new int[]{2, 2}, Feature.FeatureType.wood);
        TreeList.add(tree);
    }

    public static Shape getShapeFromCode(int code) {
        for (Shape shape : ShapeList) {
            if (shape.getCode() != code) continue;
            return shape;
        }
        return null;
    }

    public static Tree getTreeFromCode(int code) {
        for (Tree tree : TreeList) {
            if (tree.getCode() != code) continue;
            return tree.getBaseCopy();
        }
        return null;
    }

    public static Shape getRotatedShapeFromCode(int code, TreeBlock.Rotation rotation) {
        Shape rotatedShape = new Shape(code);
        for (Shape shape : ShapeList) {
            if (shape.getCode() != code) continue;
            block11: for (TreeBlock block : shape.blocksList) {
                if (block instanceof TreeBlock.InsPoint) {
                    TreeBlock.InsPoint point = (TreeBlock.InsPoint)block;
                    switch (rotation) {
                        case north: {
                            rotatedShape.addInsPointAskTrunkAndLeaves(point.getZ(), point.getY(), -point.getX(), point.getLevel(), TreeBlock.Rotation.rotate90(point.rotation), point.allowTrunk, point.getLeaves());
                            break;
                        }
                        case south: {
                            rotatedShape.addInsPointAskTrunkAndLeaves(-point.getZ(), point.getY(), point.getX(), point.getLevel(), TreeBlock.Rotation.rotate270(point.rotation), point.allowTrunk, point.getLeaves());
                            break;
                        }
                        case west: {
                            rotatedShape.addInsPointAskTrunkAndLeaves(-point.getX(), point.getY(), -point.getZ(), point.getLevel(), TreeBlock.Rotation.rotate180(point.rotation), point.allowTrunk, point.getLeaves());
                            break;
                        }
                        default: {
                            rotatedShape.addInsPointAskTrunkAndLeaves(point.getX(), point.getY(), point.getZ(), point.getLevel(), point.rotation, point.allowTrunk, point.getLeaves());
                            break;
                        }
                    }
                    continue;
                }
                switch (rotation) {
                    case north: {
                        rotatedShape.addLog(block.getZ(), block.getY(), -block.getX(), block.level);
                        continue block11;
                    }
                    case south: {
                        rotatedShape.addLog(-block.getZ(), block.getY(), block.getX(), block.level);
                        continue block11;
                    }
                    case west: {
                        rotatedShape.addLog(-block.getX(), block.getY(), -block.getZ(), block.level);
                        continue block11;
                    }
                }
                rotatedShape.addLog(block.getX(), block.getY(), block.getZ(), block.level);
            }
            return rotatedShape;
        }
        return null;
    }
}

