/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.world.jurdstrees.algorythms;

public class TreeBlock {
    protected int level;
    protected int x;
    protected int y;
    protected int z;

    public TreeBlock(int x, int y, int z, int level) {
        this.level = level;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public boolean equals(TreeBlock TB) {
        return TB.getX() == this.x && TB.getY() == this.y && TB.getZ() == this.z;
    }

    public TreeBlock getCopy() {
        return new TreeBlock(this.x, this.y, this.z, this.level);
    }

    public static enum Rotation {
        none,
        north,
        south,
        east,
        west;


        public static int getRotationIndex(Rotation rotation) {
            if (rotation == null) {
                return 0;
            }
            switch (rotation) {
                case east: {
                    return 1;
                }
                case north: {
                    return 2;
                }
                case south: {
                    return 4;
                }
                case west: {
                    return 3;
                }
            }
            return 0;
        }

        public static Rotation getRotationFromIndex(int i) {
            switch (i) {
                case 0: {
                    return none;
                }
                case 1: {
                    return east;
                }
                case 2: {
                    return north;
                }
                case 3: {
                    return west;
                }
                case 4: {
                    return south;
                }
            }
            return null;
        }

        public static Rotation rotate90(Rotation rotation) {
            int index = Rotation.getRotationIndex(rotation);
            if (index == 0) {
                return none;
            }
            index = index < 4 ? ++index : 1;
            return Rotation.getRotationFromIndex(index);
        }

        public static Rotation rotate180(Rotation rotation) {
            return Rotation.rotate90(Rotation.rotate90(rotation));
        }

        public static Rotation rotate270(Rotation rotation) {
            return Rotation.rotate90(Rotation.rotate180(rotation));
        }
    }

    public class InsPoint
    extends TreeBlock {
        public boolean allowTrunk;
        public boolean growLeaves;
        public Rotation rotation;

        public InsPoint(int x, int y, int z, int level, Rotation rot) {
            super(x, y, z, level);
            this.allowTrunk = false;
            this.level = level;
            this.allowTrunk = false;
            this.growLeaves = false;
            this.rotation = rot;
        }

        public InsPoint(int x, int y, int z, int level, Rotation rot, boolean allowTrunk, boolean leaves) {
            super(x, y, z, level);
            this.allowTrunk = false;
            this.level = level;
            this.allowTrunk = allowTrunk;
            this.growLeaves = leaves;
            this.rotation = rot;
        }

        public int getLevel() {
            return this.level;
        }

        public boolean getLeaves() {
            return this.growLeaves;
        }
    }
}

