/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.vehicles.helicopter.modules;

import com.google.common.base.Predicate;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.jurassicraft.common.vehicles.helicopter.EntityHelicopterBase;
import org.jurassicraft.common.vehicles.helicopter.modules.EntityHelicopterSeat;
import org.jurassicraft.common.vehicles.helicopter.modules.HelicopterModule;
import org.jurassicraft.common.vehicles.helicopter.modules.HelicopterModuleSpot;

public abstract class HelicopterRidableModule
extends HelicopterModule {
    protected HelicopterRidableModule(String id) {
        super(id);
    }

    @Override
    public boolean onClicked(HelicopterModuleSpot m, EntityPlayer player, Vec3 vec) {
        UUID entityID = UUID.fromString(m.getModuleData(this).func_74779_i("entityID"));
        EntityHelicopterSeat seat = HelicopterRidableModule.getSeatFromID(m.getHelicopter().field_70170_p, entityID);
        player.func_70078_a((Entity)seat);
        return true;
    }

    public static EntityHelicopterSeat getSeatFromID(World worldObj, final UUID id) {
        List list = worldObj.func_175644_a(EntityHelicopterSeat.class, (Predicate)new Predicate<Entity>(){

            public boolean apply(Entity input) {
                System.out.println(">> " + input);
                return input.func_110124_au().equals(id);
            }
        });
        if (list.isEmpty()) {
            return null;
        }
        return (EntityHelicopterSeat)((Object)list.get(0));
    }

    @Override
    public void onAdded(HelicopterModuleSpot m, EntityPlayer player, Vec3 vec) {
        EntityHelicopterBase helicopter = m.getHelicopter();
        if (!m.getHelicopter().field_70170_p.field_72995_K && !m.getModuleData(this).func_74764_b("entityID")) {
            EntityHelicopterSeat pilotSeat = new EntityHelicopterSeat(this.getDistanceFromCenter(), m.getPosition().ordinal(), m.getHelicopter(), this.shouldRiderSit());
            pilotSeat.func_70107_b(helicopter.field_70165_t, helicopter.field_70163_u, helicopter.field_70161_v);
            helicopter.field_70170_p.func_72838_d((Entity)pilotSeat);
            String id = pilotSeat.func_110124_au().toString();
            m.getModuleData(this).func_74778_a("entityID", id);
            System.out.println(id);
        }
    }

    public EntityHelicopterSeat getEntity(HelicopterModuleSpot spot) {
        String id = spot.getModuleData(this).func_74779_i("entityID");
        if (id.isEmpty()) {
            return null;
        }
        UUID entityID = UUID.fromString(id);
        EntityHelicopterSeat entity = HelicopterRidableModule.getSeatFromID(spot.getHelicopter().field_70170_p, entityID);
        return entity;
    }

    protected abstract float getDistanceFromCenter();

    protected abstract boolean shouldRiderSit();

    @Override
    public void onRemoved(HelicopterModuleSpot m, EntityPlayer player, Vec3 vec) {
    }
}

