/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.vehicles.helicopter.modules;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import org.jurassicraft.common.vehicles.helicopter.EntityHelicopterBase;

public class EntityHelicopterSeat
extends Entity
implements IEntityAdditionalSpawnData {
    private boolean sitedRider;
    private UUID parentID;
    private float dist;
    private int index;
    public EntityHelicopterBase parent;

    public EntityHelicopterSeat(World worldIn) {
        super(worldIn);
        this.func_174826_a(AxisAlignedBB.func_178781_a((double)Double.NEGATIVE_INFINITY, (double)Double.NEGATIVE_INFINITY, (double)Double.NEGATIVE_INFINITY, (double)Double.NEGATIVE_INFINITY, (double)Double.NEGATIVE_INFINITY, (double)Double.NEGATIVE_INFINITY));
        this.field_70145_X = true;
        this.parentID = UUID.randomUUID();
        this.sitedRider = true;
    }

    public EntityHelicopterSeat(float dist, int index, EntityHelicopterBase parent, boolean sitedRider) {
        super(parent.func_130014_f_());
        this.func_174826_a(AxisAlignedBB.func_178781_a((double)Double.NEGATIVE_INFINITY, (double)Double.NEGATIVE_INFINITY, (double)Double.NEGATIVE_INFINITY, (double)Double.NEGATIVE_INFINITY, (double)Double.NEGATIVE_INFINITY, (double)Double.NEGATIVE_INFINITY));
        this.dist = dist;
        this.index = index;
        this.parent = (EntityHelicopterBase)((Object)Preconditions.checkNotNull((Object)((Object)parent), (Object)"parent"));
        this.parentID = parent.getHeliID();
        this.field_70145_X = true;
        this.resetPos();
        this.sitedRider = sitedRider;
    }

    protected void func_70088_a() {
        this.field_70130_N = 0.0f;
        this.field_70131_O = 0.0f;
    }

    public void func_70030_z() {
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        super.func_70030_z();
        if (this.parent == null) {
            this.parent = EntityHelicopterSeat.getParentFromID(this.field_70170_p, this.parentID);
        }
        if (this.parent != null) {
            float angle = this.parent.field_70177_z;
            this.resetPos();
            if (this.parent.field_70128_L) {
                System.out.println("KILLED");
                this.func_70076_C();
            }
        } else {
            System.out.println("no parent :c " + this.parentID);
        }
    }

    private void resetPos() {
        float nx = -MathHelper.func_76126_a((float)(this.parent.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.parent.field_70125_A / 180.0f * (float)Math.PI)) * this.dist;
        float nz = MathHelper.func_76134_b((float)(this.parent.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.parent.field_70125_A / 180.0f * (float)Math.PI)) * this.dist;
        float ny = -MathHelper.func_76126_a((float)this.parent.field_70125_A) / 180.0f * (float)Math.PI * this.dist;
        this.field_70165_t = this.parent.field_70165_t + (double)nx;
        this.field_70163_u = this.parent.field_70163_u + (double)ny + (double)0.4f;
        this.field_70161_v = this.parent.field_70161_v + (double)nz;
        System.out.println(">> new pos: " + this.field_70165_t + ", " + this.field_70163_u + ", " + this.field_70161_v);
    }

    protected void func_70037_a(NBTTagCompound tagCompound) {
        this.dist = tagCompound.func_74760_g("dist");
        this.index = tagCompound.func_74762_e("index");
        this.sitedRider = tagCompound.func_74767_n("sitedRider");
        this.parentID = UUID.fromString(tagCompound.func_74779_i("heliID"));
    }

    public static EntityHelicopterBase getParentFromID(World worldObj, final UUID id) {
        List list = worldObj.func_175644_a(EntityHelicopterBase.class, (Predicate)new Predicate<Entity>(){

            public boolean apply(Entity input) {
                if (input instanceof EntityHelicopterBase) {
                    EntityHelicopterBase helicopterBase = (EntityHelicopterBase)input;
                    return helicopterBase.getHeliID().equals(id);
                }
                return false;
            }
        });
        if (list.isEmpty()) {
            return null;
        }
        return (EntityHelicopterBase)((Object)list.get(0));
    }

    protected void func_70014_b(NBTTagCompound tagCompound) {
        tagCompound.func_74776_a("dist", this.dist);
        tagCompound.func_74768_a("index", this.index);
        tagCompound.func_74757_a("sitedRider", this.sitedRider);
        tagCompound.func_74778_a("heliID", this.parentID.toString());
    }

    public EntityHelicopterBase getParent() {
        return this.parent;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70067_L() {
        return false;
    }

    public double func_70042_X() {
        return 0.0;
    }

    public void setParentID(UUID parentID) {
        this.parentID = parentID;
    }

    public void writeSpawnData(ByteBuf buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.parentID.toString());
        buffer.writeFloat(this.dist);
        buffer.writeBoolean(this.sitedRider);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.parentID = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)additionalData));
        this.dist = additionalData.readFloat();
        this.sitedRider = additionalData.readBoolean();
    }

    public boolean shouldRiderSit() {
        return this.sitedRider;
    }
}

