/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.vehicles.helicopter;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.timeless.unilib.utils.MutableVec3;
import org.jurassicraft.JurassiCraft;
import org.jurassicraft.common.item.ItemHelicopter;
import org.jurassicraft.common.message.MessageHelicopterDirection;
import org.jurassicraft.common.message.MessageHelicopterEngine;
import org.jurassicraft.common.vehicles.helicopter.modules.EntityHelicopterSeat;
import org.jurassicraft.common.vehicles.helicopter.modules.EnumModulePosition;
import org.jurassicraft.common.vehicles.helicopter.modules.HelicopterModule;
import org.jurassicraft.common.vehicles.helicopter.modules.HelicopterModuleSpot;

public class EntityHelicopterBase
extends EntityLivingBase
implements IEntityAdditionalSpawnData {
    private final HelicopterModuleSpot[] moduleSpots;
    private boolean syncModules;
    private UUID heliID = UUID.randomUUID();
    public static final int ENGINE_RUNNING = 20;
    public static final int PILOT_SEAT = EnumModulePosition.MAIN_SEAT.ordinal();
    public static final int LEFT_PART = EnumModulePosition.BACK_LEFT.ordinal();
    public static final int RIGHT_PART = EnumModulePosition.BACK_RIGHT.ordinal();
    public static final float MAX_POWER = 80.0f;
    public static final float REQUIRED_POWER = 40.0f;
    private float roll;
    private boolean engineRunning;
    private float enginePower;
    private boolean hasMinigun;
    private MutableVec3 direction;

    public EntityHelicopterBase(World worldIn, ItemHelicopter creator) {
        this(worldIn);
        this.prepareDefaultModules();
    }

    public EntityHelicopterBase(World worldIn) {
        super(worldIn);
        double w = 3.0;
        double h = 3.1f;
        double d = 8.0;
        this.setBox(0.0, 0.0, 0.0, w, h, d);
        this.moduleSpots = new HelicopterModuleSpot[EnumModulePosition.values().length];
        this.moduleSpots[EntityHelicopterBase.PILOT_SEAT] = new HelicopterModuleSpot(EnumModulePosition.MAIN_SEAT, this, 0.0f);
        this.moduleSpots[EntityHelicopterBase.LEFT_PART] = new HelicopterModuleSpot(EnumModulePosition.BACK_LEFT, this, (float)Math.PI);
        this.moduleSpots[EntityHelicopterBase.RIGHT_PART] = new HelicopterModuleSpot(EnumModulePosition.BACK_RIGHT, this, 0.0f);
        this.direction = new MutableVec3(0.0, 1.0, 0.0);
        this.syncModules = true;
    }

    public void prepareDefaultModules() {
        this.syncModules = false;
        this.getModuleSpot(EnumModulePosition.MAIN_SEAT).addModule(HelicopterModule.seat);
        this.getModuleSpot(EnumModulePosition.BACK_LEFT).addModule(HelicopterModule.door);
        this.getModuleSpot(EnumModulePosition.BACK_RIGHT).addModule(HelicopterModule.minigun);
        this.syncModules = true;
    }

    private void setBox(double offsetX, double offsetY, double offsetZ, double w, double h, double d) {
        double minX = this.func_174813_aQ().field_72340_a + offsetX;
        double minY = this.func_174813_aQ().field_72338_b + offsetY;
        double minZ = this.func_174813_aQ().field_72339_c + offsetZ;
        double maxX = this.func_174813_aQ().field_72340_a + w + offsetX;
        double maxY = this.func_174813_aQ().field_72338_b + h + offsetY;
        double maxZ = this.func_174813_aQ().field_72339_c + d + offsetZ;
        this.func_174826_a(new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ));
        this.field_70130_N = (float)(maxX - minX);
        this.field_70131_O = (float)(maxY - minY);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)0);
    }

    public void func_70037_a(NBTTagCompound tagCompound) {
        super.func_70037_a(tagCompound);
        this.heliID = UUID.fromString(tagCompound.func_74779_i("heliID"));
        this.moduleSpots[PILOT_SEAT].readFromNBT(tagCompound.func_74775_l("pilotModules"));
        this.moduleSpots[LEFT_PART].readFromNBT(tagCompound.func_74775_l("leftModules"));
        this.moduleSpots[RIGHT_PART].readFromNBT(tagCompound.func_74775_l("rightModules"));
    }

    public ItemStack func_70694_bm() {
        return null;
    }

    public ItemStack func_71124_b(int slotIn) {
        return null;
    }

    public ItemStack func_82169_q(int slotIn) {
        return null;
    }

    public void func_70062_b(int slotIn, ItemStack stack) {
    }

    public ItemStack[] func_70035_c() {
        return new ItemStack[0];
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74778_a("heliID", this.heliID.toString());
        NBTTagCompound pilotModulesList = new NBTTagCompound();
        this.moduleSpots[PILOT_SEAT].writeToNBT(pilotModulesList);
        tagCompound.func_74782_a("pilotModules", (NBTBase)pilotModulesList);
        NBTTagCompound leftModulesList = new NBTTagCompound();
        this.moduleSpots[LEFT_PART].writeToNBT(leftModulesList);
        tagCompound.func_74782_a("leftModules", (NBTBase)leftModulesList);
        NBTTagCompound rightModulesList = new NBTTagCompound();
        this.moduleSpots[RIGHT_PART].writeToNBT(rightModulesList);
        tagCompound.func_74782_a("rightModules", (NBTBase)rightModulesList);
    }

    public void func_70636_d() {
        EntityHelicopterSeat seat;
        super.func_70636_d();
        this.field_70143_R = 0.0f;
        this.field_70158_ak = true;
        for (HelicopterModuleSpot spot : this.moduleSpots) {
            EntityHelicopterSeat seat2;
            if (spot == null || !spot.has(HelicopterModule.seat) || (seat2 = HelicopterModule.seat.getEntity(spot)) == null) continue;
            seat2.setParentID(this.heliID);
            seat2.parent = this;
        }
        if (this.getModuleSpot(EnumModulePosition.MAIN_SEAT).has(HelicopterModule.seat) && (seat = HelicopterModule.seat.getEntity(this.getModuleSpot(EnumModulePosition.MAIN_SEAT))) != null) {
            Entity riderEntity = seat.field_70153_n;
            boolean runEngine = false;
            if (riderEntity != null) {
                EntityPlayer rider = (EntityPlayer)riderEntity;
                if (this.field_70170_p.field_72995_K) {
                    runEngine = this.handleClientRunning(rider);
                    if (this.isPilotThisClient(rider)) {
                        this.updateEngine(runEngine);
                        this.engineRunning = runEngine;
                        if (this.engineRunning && this.enginePower >= 40.0f) {
                            this.direction = this.drive(this.direction);
                        } else {
                            this.direction.set(0.0, 1.0, 0.0);
                        }
                    }
                }
            } else {
                runEngine = false;
                this.updateEngine(runEngine);
                this.direction.set(0.0, 1.0, 0.0);
            }
            this.field_70177_z = (float)((double)this.field_70177_z - this.direction.xCoord * 1.25);
            this.roll = (float)(this.direction.xCoord * 20.0);
            this.field_70125_A = (float)(-(this.direction.zCoord * 40.0));
            this.updateDirection(this.direction);
            if (this.engineRunning) {
                this.enginePower += 1.0f;
                if (this.enginePower >= 40.0f) {
                    MutableVec3 localDir = new MutableVec3(this.direction.xCoord, this.direction.yCoord, this.direction.zCoord * 8.0);
                    localDir = localDir.rotateYaw((float)Math.toRadians(-this.field_70177_z));
                    float gravityCancellation = 0.08f;
                    float speedY = 0.085f;
                    double my = (double)0.085f * localDir.yCoord;
                    if (my < (double)0.08f) {
                        my = 0.08f;
                    }
                    this.field_70181_x += my;
                    this.field_70159_w = localDir.xCoord / 10.0;
                    this.field_70179_y = localDir.zCoord / 10.0;
                }
                if (this.enginePower >= 80.0f) {
                    this.enginePower = 80.0f;
                }
            } else {
                this.enginePower = this.enginePower >= 40.0f ? (this.enginePower -= 0.5f) : (this.enginePower -= 1.0f);
                if (this.enginePower < 0.0f) {
                    this.enginePower = 0.0f;
                }
            }
        }
    }

    private void updateDirection(MutableVec3 direction) {
        if (this.field_70170_p.field_72995_K) {
            JurassiCraft.networkManager.networkWrapper.sendToServer((IMessage)new MessageHelicopterDirection(this.func_145782_y(), direction));
        } else {
            JurassiCraft.networkManager.networkWrapper.sendToAll((IMessage)new MessageHelicopterDirection(this.func_145782_y(), direction));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private MutableVec3 drive(MutableVec3 direction) {
        if (Minecraft.func_71410_x().field_71474_y.field_74351_w.func_151470_d()) {
            direction.addVector(0.0, 0.0, 1.0);
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74368_y.func_151470_d()) {
            direction.addVector(0.0, 0.0, -1.0);
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74370_x.func_151470_d()) {
            direction.addVector(1.0, 0.0, 0.0);
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74366_z.func_151470_d()) {
            direction.addVector(-1.0, 0.0, 0.0);
        }
        if (!Minecraft.func_71410_x().field_71474_y.field_74313_G.func_151470_d()) {
            direction.addVector(0.0, 1.0, 0.0);
        }
        return direction.normalize();
    }

    public void updateEngine(boolean engineState) {
        if (this.field_70170_p.field_72995_K) {
            JurassiCraft.networkManager.networkWrapper.sendToServer((IMessage)new MessageHelicopterEngine(this.func_145782_y(), engineState));
        } else {
            JurassiCraft.networkManager.networkWrapper.sendToAll((IMessage)new MessageHelicopterEngine(this.func_145782_y(), engineState));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private boolean isPilotThisClient(EntityPlayer pilot) {
        return pilot.func_110124_au().equals(Minecraft.func_71410_x().field_71439_g.func_110124_au());
    }

    @SideOnly(value=Side.CLIENT)
    private boolean handleClientRunning(EntityPlayer rider) {
        return this.isPilotThisClient(rider) && Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d();
    }

    public boolean func_174825_a(EntityPlayer player, Vec3 vec) {
        Vec3 localVec = vec.func_178785_b((float)Math.toRadians(this.field_70177_z));
        System.out.println(localVec);
        for (int i = 0; i < this.moduleSpots.length; ++i) {
            HelicopterModuleSpot spot = this.moduleSpots[i];
            if (spot == null || !spot.isClicked(localVec)) continue;
            System.out.println(spot);
            spot.onClicked(player, vec);
            return true;
        }
        return false;
    }

    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return null;
    }

    public AxisAlignedBB getBoundingBox() {
        return this.func_174813_aQ();
    }

    public boolean func_70104_M() {
        return false;
    }

    public void func_85033_bc() {
    }

    public float getRoll() {
        return this.roll;
    }

    public void setRoll(float roll) {
        this.roll = roll;
    }

    public UUID getHeliID() {
        return this.heliID;
    }

    public void writeSpawnData(ByteBuf buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.heliID.toString());
        for (HelicopterModuleSpot spot : this.moduleSpots) {
            spot.writeSpawnData(buffer);
        }
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.heliID = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)additionalData));
        for (HelicopterModuleSpot spot : this.moduleSpots) {
            spot.readSpawnData(additionalData);
        }
    }

    public boolean isEngineRunning() {
        return this.engineRunning;
    }

    public void setEngineRunning(boolean engineRunning) {
        this.engineRunning = engineRunning;
    }

    public float getEnginePower() {
        return this.enginePower;
    }

    public void setDirection(MutableVec3 direction) {
        this.direction.set(direction);
    }

    public HelicopterModuleSpot[] getModuleSpots() {
        return this.moduleSpots;
    }

    public HelicopterModuleSpot getModuleSpot(EnumModulePosition pos) {
        return this.moduleSpots[pos.ordinal()];
    }

    public boolean shouldSyncModules() {
        return this.syncModules;
    }
}

