/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.tileentity;

import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import org.jurassicraft.common.container.ContainerDNAExtractor;
import org.jurassicraft.common.dinosaur.Dinosaur;
import org.jurassicraft.common.entity.base.JCEntityRegistry;
import org.jurassicraft.common.genetics.DinoDNA;
import org.jurassicraft.common.genetics.GeneticsHelper;
import org.jurassicraft.common.genetics.PlantDNA;
import org.jurassicraft.common.item.JCItemRegistry;
import org.jurassicraft.common.plant.JCPlantRegistry;
import org.jurassicraft.common.plant.Plant;
import org.jurassicraft.common.tileentity.TileMachineBase;

public class TileDNAExtractor
extends TileMachineBase {
    private int[] inputs = new int[]{0, 1};
    private int[] outputs = new int[]{2, 3, 4, 5};
    private ItemStack[] slots = new ItemStack[6];

    @Override
    protected int getProcess(int slot) {
        return 0;
    }

    @Override
    protected boolean canProcess(int process) {
        ItemStack extraction = this.slots[0];
        ItemStack storage = this.slots[1];
        if (!(storage == null || storage.func_77973_b() != JCItemRegistry.storage_disc || extraction == null || extraction.func_77973_b() != JCItemRegistry.amber && extraction.func_77973_b() != JCItemRegistry.sea_lamprey || storage.func_77978_p() != null && storage.func_77978_p().func_74764_b("Genetics"))) {
            for (int i = 2; i < 6; ++i) {
                if (this.slots[i] != null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void processItem(int process) {
        if (this.canProcess(process)) {
            Random rand = this.field_145850_b.field_73012_v;
            ItemStack input = this.slots[0];
            ItemStack disc = null;
            if (input.func_77952_i() == 0) {
                List<Dinosaur> possibleDinos = null;
                if (input.func_77973_b() == JCItemRegistry.amber) {
                    if (input.func_77952_i() == 0) {
                        possibleDinos = JCEntityRegistry.getDinosaursFromAmber();
                    }
                } else if (input.func_77973_b() == JCItemRegistry.sea_lamprey) {
                    possibleDinos = JCEntityRegistry.getDinosaursFromSeaLampreys();
                }
                if (possibleDinos != null) {
                    Dinosaur dino = possibleDinos.get(rand.nextInt(possibleDinos.size()));
                    int dinosaurId = JCEntityRegistry.getDinosaurId(dino);
                    disc = new ItemStack((Item)JCItemRegistry.storage_disc, 1, dinosaurId);
                    int quality = rand.nextInt(50);
                    if (rand.nextDouble() < 0.1) {
                        quality += 50;
                    }
                    DinoDNA dna = new DinoDNA(quality, GeneticsHelper.randomGenetics(rand, dinosaurId, quality).toString());
                    NBTTagCompound nbt = new NBTTagCompound();
                    dna.writeToNBT(nbt);
                    disc.func_77982_d(nbt);
                }
            } else if (input.func_77973_b() == JCItemRegistry.amber && input.func_77952_i() == 1) {
                List<Plant> possiblePlants = JCPlantRegistry.getPlants();
                Plant plant = possiblePlants.get(rand.nextInt(possiblePlants.size()));
                int plantId = JCPlantRegistry.getPlantId(plant);
                disc = new ItemStack((Item)JCItemRegistry.storage_disc, 1, plantId);
                int quality = rand.nextInt(50);
                if (rand.nextDouble() < 0.1) {
                    quality += 50;
                }
                PlantDNA dna = new PlantDNA(plantId, quality);
                NBTTagCompound nbt = new NBTTagCompound();
                dna.writeToNBT(nbt);
                disc.func_77982_d(nbt);
            }
            int empty = this.getOutputSlot(disc);
            this.slots[empty] = disc;
            this.decreaseStackSize(0);
            this.decreaseStackSize(1);
        }
    }

    @Override
    protected int getMainInput(int process) {
        return 0;
    }

    @Override
    protected int getMainOutput(int process) {
        return 2;
    }

    @Override
    protected int getStackProcessTime(ItemStack stack) {
        return 2000;
    }

    @Override
    protected int getProcessCount() {
        return 1;
    }

    @Override
    protected int[] getInputs() {
        return this.inputs;
    }

    @Override
    protected int[] getOutputs() {
        return this.outputs;
    }

    @Override
    protected ItemStack[] getSlots() {
        return this.slots;
    }

    @Override
    protected void setSlots(ItemStack[] slots) {
        this.slots = slots;
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerDNAExtractor(playerInventory, (TileEntity)this);
    }

    public String func_174875_k() {
        return "jurassicraft:dna_extractor";
    }

    public String getName() {
        return this.func_145818_k_() ? this.customName : "container.dna_extractor";
    }

    public String func_70005_c_() {
        return this.getName();
    }
}

