/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.tileentity;

import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucketMilk;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.common.container.ContainerDnaSynthesizer;
import org.jurassicraft.common.dinosaur.Dinosaur;
import org.jurassicraft.common.entity.base.EntityDinosaur;
import org.jurassicraft.common.entity.base.JCEntityRegistry;
import org.jurassicraft.common.entity.item.EntityCageSmall;
import org.jurassicraft.common.food.JCFoodNutrients;
import org.jurassicraft.common.item.JCItemRegistry;

public class TileCultivate
extends TileEntityLockable
implements ITickable,
ISidedInventory {
    private static final int[] slotsTop = new int[]{0, 1};
    private static final int[] slotsBottom = new int[]{4};
    private static final int[] slotsSides = new int[]{2, 3};
    private int waterLevel;
    private int lipids;
    private int proximates;
    private int minerals;
    private int vitamins;
    private int maxNutrients = 3000;
    private ItemStack[] slots = new ItemStack[5];
    private int cultivateTime;
    private int totalCultivateTime;
    private String customName;

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int index) {
        return this.slots[index];
    }

    public ItemStack func_70298_a(int index, int count) {
        if (this.slots[index] != null) {
            if (this.slots[index].field_77994_a <= count) {
                ItemStack itemstack = this.slots[index];
                this.slots[index] = null;
                return itemstack;
            }
            ItemStack itemstack = this.slots[index].func_77979_a(count);
            if (this.slots[index].field_77994_a == 0) {
                this.slots[index] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int index) {
        if (this.slots[index] != null) {
            ItemStack itemstack = this.slots[index];
            this.slots[index] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        boolean flag = stack != null && stack.func_77969_a(this.slots[index]) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)this.slots[index]);
        this.slots[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        if (index == 0 && !flag) {
            this.totalCultivateTime = this.getCultivateTime(stack);
            this.cultivateTime = 0;
            this.field_145850_b.func_175689_h(this.field_174879_c);
        }
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : "container.cultivator";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomInventoryName(String customName) {
        this.customName = customName;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagList itemList = compound.func_150295_c("Items", 10);
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < itemList.func_74745_c(); ++i) {
            NBTTagCompound item = itemList.func_150305_b(i);
            byte slot = item.func_74771_c("Slot");
            if (slot < 0 || slot >= this.slots.length) continue;
            this.slots[slot] = ItemStack.func_77949_a((NBTTagCompound)item);
        }
        this.cultivateTime = compound.func_74765_d("CultivateTime");
        this.totalCultivateTime = compound.func_74765_d("CultivateTimeTotal");
        this.waterLevel = compound.func_74765_d("WaterLevel");
        this.lipids = compound.func_74762_e("Lipids");
        this.minerals = compound.func_74762_e("Minerals");
        this.vitamins = compound.func_74762_e("Vitamins");
        this.proximates = compound.func_74762_e("Proximates");
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = compound.func_74779_i("CustomName");
        }
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74777_a("CultivateTime", (short)this.cultivateTime);
        compound.func_74777_a("CultivateTimeTotal", (short)this.totalCultivateTime);
        compound.func_74777_a("WaterLevel", (short)this.waterLevel);
        compound.func_74768_a("Lipids", this.lipids);
        compound.func_74768_a("Minerals", this.minerals);
        compound.func_74768_a("Vitamins", this.vitamins);
        compound.func_74768_a("Proximates", this.proximates);
        NBTTagList itemList = new NBTTagList();
        for (int slot = 0; slot < this.slots.length; ++slot) {
            if (this.slots[slot] == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74774_a("Slot", (byte)slot);
            this.slots[slot].func_77955_b(itemTag);
            itemList.func_74742_a((NBTBase)itemTag);
        }
        compound.func_74782_a("Items", (NBTBase)itemList);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.customName);
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean isCultivating() {
        return this.cultivateTime > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isCultivating(IInventory inventory) {
        return inventory.func_174887_a_(0) > 0;
    }

    public void func_73660_a() {
        boolean flag = this.isCultivating();
        boolean sync = false;
        if (!this.field_145850_b.field_72995_K) {
            if (!this.isCultivating() && this.slots[0] == null) {
                if (!this.isCultivating() && this.cultivateTime > 0) {
                    this.cultivateTime = MathHelper.func_76125_a((int)(this.cultivateTime - 2), (int)0, (int)this.totalCultivateTime);
                }
            } else if (this.canCultivate()) {
                ++this.cultivateTime;
                if (this.cultivateTime == this.totalCultivateTime) {
                    this.cultivateTime = 0;
                    this.totalCultivateTime = this.getCultivateTime(this.slots[0]);
                    this.cultivate();
                    sync = true;
                }
            } else {
                this.cultivateTime = 0;
                sync = true;
            }
            if (this.waterLevel < 3 && this.slots[2] != null && this.slots[2].func_77973_b() == Items.field_151131_as && (this.slots[3] == null || this.slots[3].field_77994_a < 16)) {
                --this.slots[2].field_77994_a;
                if (this.slots[2].field_77994_a <= 0) {
                    this.slots[2] = null;
                }
                ++this.waterLevel;
                if (this.slots[3] == null) {
                    this.slots[3] = new ItemStack(Items.field_151133_ar);
                } else if (this.slots[3].func_77973_b() == Items.field_151133_ar) {
                    ++this.slots[3].field_77994_a;
                }
                sync = true;
            }
            if (this.slots[1] != null && JCFoodNutrients.FOODLIST.containsKey(this.slots[1].func_77973_b()) && (this.proximates < this.maxNutrients || this.minerals < this.maxNutrients || this.vitamins < this.maxNutrients || this.lipids < this.maxNutrients)) {
                this.consumeNutrients();
                sync = true;
            }
            if (flag != this.isCultivating()) {
                sync = true;
            }
        } else if (this.canCultivate()) {
            ++this.cultivateTime;
        }
        if (sync) {
            this.field_145850_b.func_175689_h(this.field_174879_c);
        }
    }

    private void consumeNutrients() {
        JCFoodNutrients nutrients = JCFoodNutrients.values()[JCFoodNutrients.FOODLIST.get(this.slots[1].func_77973_b())];
        if (this.slots[1].func_77973_b() instanceof ItemBucketMilk) {
            this.slots[1] = null;
            this.slots[1] = new ItemStack(Items.field_151133_ar);
        } else {
            --this.slots[1].field_77994_a;
            if (this.slots[1].field_77994_a <= 0) {
                this.slots[1] = null;
            }
        }
        Random random = new Random();
        if (this.proximates < this.maxNutrients) {
            this.proximates = (short)((double)this.proximates + (double)(800 + random.nextInt(201)) * nutrients.getProximate());
            if (this.proximates > this.maxNutrients) {
                this.proximates = (short)this.maxNutrients;
            }
        }
        if (this.minerals < this.maxNutrients) {
            this.minerals = (short)((double)this.minerals + (double)(900 + random.nextInt(101)) * nutrients.getMinerals());
            if (this.minerals > this.maxNutrients) {
                this.minerals = (short)this.maxNutrients;
            }
        }
        if (this.vitamins < this.maxNutrients) {
            this.vitamins = (short)((double)this.vitamins + (double)(900 + random.nextInt(101)) * nutrients.getVitamins());
            if (this.vitamins > this.maxNutrients) {
                this.vitamins = (short)this.maxNutrients;
            }
        }
        if (this.lipids < this.maxNutrients) {
            this.lipids = (short)((double)this.lipids + (double)(980 + random.nextInt(101)) * nutrients.getLipids());
            if (this.lipids > this.maxNutrients) {
                this.lipids = (short)this.maxNutrients;
            }
        }
    }

    public int getCultivateTime(ItemStack stack) {
        return 2000;
    }

    private boolean canCultivate() {
        Dinosaur dino;
        return this.slots[0] != null && this.slots[0].func_77973_b() == JCItemRegistry.syringe && this.waterLevel == 3 && (dino = JCEntityRegistry.getDinosaurById(this.slots[0].func_77952_i())).isMammal() && this.lipids >= dino.getLipids() && this.minerals >= dino.getMinerals() && this.proximates >= dino.getProximates() && this.vitamins >= dino.getVitamins();
    }

    public void cultivate() {
        if (this.canCultivate()) {
            Dinosaur dinoInEgg = JCEntityRegistry.getDinosaurById(this.slots[0].func_77952_i());
            this.waterLevel = 0;
            this.lipids -= dinoInEgg.getLipids();
            this.minerals -= dinoInEgg.getMinerals();
            this.vitamins -= dinoInEgg.getVitamins();
            this.proximates -= dinoInEgg.getProximates();
            Class<? extends EntityDinosaur> dinoClass = dinoInEgg.getDinosaurClass();
            try {
                EntityDinosaur dino = dinoClass.getConstructor(World.class).newInstance(this.field_145850_b);
                dino.setDNAQuality(this.slots[0].func_77978_p().func_74762_e("DNAQuality"));
                dino.setGenetics(this.slots[0].func_77978_p().func_74779_i("Genetics"));
                int blockX = this.field_174879_c.func_177958_n();
                int blockY = this.field_174879_c.func_177956_o();
                int blockZ = this.field_174879_c.func_177952_p();
                dino.setAge(0);
                List cages = this.field_145850_b.func_72872_a(EntityCageSmall.class, AxisAlignedBB.func_178781_a((double)(blockX - 2), (double)blockY, (double)(blockZ - 2), (double)(blockX + 2), (double)(blockY + 1), (double)(blockZ + 2)));
                EntityCageSmall cage = null;
                for (EntityCageSmall cCage : cages) {
                    if (cCage.getEntity() != null) continue;
                    cage = cCage;
                    break;
                }
                if (cage != null) {
                    cage.setEntity((Entity)dino);
                } else {
                    dino.func_70012_b(blockX + 2, (double)blockY + 0.5, blockZ + 2, MathHelper.func_76142_g((float)(this.field_145850_b.field_73012_v.nextFloat() * 360.0f)), 0.0f);
                    dino.field_70759_as = dino.field_70177_z;
                    dino.field_70761_aq = dino.field_70177_z;
                    this.field_145850_b.func_72838_d((Entity)dino);
                }
                --this.slots[0].field_77994_a;
                if (this.slots[0].field_77994_a <= 0) {
                    this.slots[0] = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index != 2;
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? slotsBottom : (side == EnumFacing.UP ? slotsTop : slotsSides);
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        Item item;
        return direction != EnumFacing.DOWN || index != 1 || (item = stack.func_77973_b()) == Items.field_151131_as || item == Items.field_151133_ar;
    }

    public String func_174875_k() {
        return "jurassicraft:cultivator";
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerDnaSynthesizer(playerInventory, (TileEntity)this);
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.cultivateTime;
            }
            case 1: {
                return this.totalCultivateTime;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.cultivateTime = value;
                break;
            }
            case 1: {
                this.totalCultivateTime = value;
            }
        }
    }

    public int func_174890_g() {
        return 2;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.slots.length; ++i) {
            this.slots[i] = null;
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_145841_b(compound);
        return new S35PacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), compound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        NBTTagCompound compound = packet.func_148857_g();
        this.func_145839_a(compound);
    }

    public int getWaterLevel() {
        return this.waterLevel;
    }

    public int getProximates() {
        return this.proximates;
    }

    public int getLipids() {
        return this.lipids;
    }

    public int getVitamins() {
        return this.vitamins;
    }

    public int getMinerals() {
        return this.minerals;
    }

    public int getMaxNutrients() {
        return this.maxNutrients;
    }

    public Dinosaur getDinosaur() {
        if (this.slots[0] != null) {
            return JCEntityRegistry.getDinosaurById(this.slots[0].func_77952_i());
        }
        return null;
    }
}

