/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.storagedisc;

import com.google.common.base.Supplier;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jurassicraft.common.storagedisc.IStorageType;
import org.jurassicraft.common.storagedisc.StorageTypeDinosaurDNA;
import org.jurassicraft.common.storagedisc.StorageTypePlantDNA;

public class StorageTypeRegistry {
    private static Map<String, Supplier<? extends IStorageType>> storageTypes = new HashMap<String, Supplier<? extends IStorageType>>();

    public void register() {
        this.register("DinoDNA", (Supplier<? extends IStorageType>)new Supplier<IStorageType>(){

            public StorageTypeDinosaurDNA get() {
                return new StorageTypeDinosaurDNA();
            }
        });
        this.register("PlantDNA", (Supplier<? extends IStorageType>)new Supplier<IStorageType>(){

            public StorageTypePlantDNA get() {
                return new StorageTypePlantDNA();
            }
        });
    }

    private void register(String id, Supplier<? extends IStorageType> storageType) {
        storageTypes.put(id, Objects.requireNonNull(storageType));
    }

    public static IStorageType getStorageType(String id) {
        if (id == null || id.isEmpty()) {
            id = "DinoDNA";
        }
        return (IStorageType)storageTypes.get(id).get();
    }
}

