/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.proxy;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.jurassicraft.JurassiCraft;
import org.jurassicraft.common.api.IHybrid;
import org.jurassicraft.common.configuration.JCConfigurations;
import org.jurassicraft.common.dinosaur.Dinosaur;
import org.jurassicraft.common.entity.base.JCEntityRegistry;
import org.jurassicraft.common.event.CommonEventHandler;
import org.jurassicraft.common.handler.JCGuiHandler;
import org.jurassicraft.common.item.JCItemRegistry;
import org.jurassicraft.common.world.WorldGenerator;

public class CommonProxy {
    public void preInit(FMLPreInitializationEvent event) {
        JurassiCraft.configurations.initConfig(event);
        JurassiCraft.entityRegistry.register();
        JurassiCraft.plantRegistry.register();
        JurassiCraft.creativeTabRegistry.register();
        JurassiCraft.itemRegistry.register();
        JurassiCraft.blockRegistry.register();
        JurassiCraft.recipeRegistry.register();
        JurassiCraft.networkManager.register();
        JurassiCraft.appRegistry.register();
        JurassiCraft.achievements.register();
        JurassiCraft.storageTypeRegistry.register();
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenerator(), (int)0);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)JurassiCraft.instance, (IGuiHandler)new JCGuiHandler());
        CommonEventHandler eventHandler = new CommonEventHandler();
        FMLCommonHandler.instance().bus().register((Object)JurassiCraft.configurations);
        FMLCommonHandler.instance().bus().register((Object)eventHandler);
        MinecraftForge.EVENT_BUS.register((Object)eventHandler);
    }

    private void addChestGenItems() {
        ChestGenHooks.getInfo((String)"mineshaftCorridor").addItem(new WeightedRandomChestContent(new ItemStack((Item)JCItemRegistry.amber, 1, 0), 1, 2, 30));
        ChestGenHooks.getInfo((String)"mineshaftCorridor").addItem(new WeightedRandomChestContent(new ItemStack((Item)JCItemRegistry.amber, 1, 1), 1, 2, 30));
        ArrayList<Dinosaur> dinosaurs = new ArrayList<Dinosaur>(JCEntityRegistry.getDinosaurs());
        HashMap<Dinosaur, Integer> ids = new HashMap<Dinosaur, Integer>();
        int id = 0;
        for (Dinosaur dino : dinosaurs) {
            ids.put(dino, id);
            ++id;
        }
        Collections.sort(dinosaurs);
        for (Dinosaur dino : dinosaurs) {
            if (!dino.shouldRegister() || dino instanceof IHybrid) continue;
            ChestGenHooks.getInfo((String)"pyramidDesertyChest").addItem(new WeightedRandomChestContent(new ItemStack((Item)JCItemRegistry.skull, 1, ((Integer)ids.get(dino)).intValue()), 1, 6, 80));
        }
    }

    public void postInit(FMLPostInitializationEvent event) {
        BiomeGenBase[] allBiomes = (BiomeGenBase[])Iterators.toArray((Iterator)Iterators.filter((Iterator)Iterators.forArray((Object[])BiomeGenBase.func_150565_n()), (Predicate)Predicates.notNull()), BiomeGenBase.class);
        for (Map.Entry object : EntityList.field_75626_c.entrySet()) {
            Map.Entry entry = object;
            Class entityClass = (Class)entry.getKey();
            if (entityClass.toString().contains("minecraft")) {
                if (JCConfigurations.spawnVanillaMobsNaturally()) continue;
                EntityRegistry.removeSpawn((Class)entityClass, (EnumCreatureType)EnumCreatureType.AMBIENT, (BiomeGenBase[])allBiomes);
                EntityRegistry.removeSpawn((Class)entityClass, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])allBiomes);
                EntityRegistry.removeSpawn((Class)entityClass, (EnumCreatureType)EnumCreatureType.MONSTER, (BiomeGenBase[])allBiomes);
                EntityRegistry.removeSpawn((Class)entityClass, (EnumCreatureType)EnumCreatureType.WATER_CREATURE, (BiomeGenBase[])allBiomes);
                continue;
            }
            if (JCConfigurations.spawnOtherMobsModsNaturally()) continue;
            EntityRegistry.removeSpawn((Class)entityClass, (EnumCreatureType)EnumCreatureType.AMBIENT, (BiomeGenBase[])allBiomes);
            EntityRegistry.removeSpawn((Class)entityClass, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])allBiomes);
            EntityRegistry.removeSpawn((Class)entityClass, (EnumCreatureType)EnumCreatureType.MONSTER, (BiomeGenBase[])allBiomes);
            EntityRegistry.removeSpawn((Class)entityClass, (EnumCreatureType)EnumCreatureType.WATER_CREATURE, (BiomeGenBase[])allBiomes);
        }
    }

    public void init(FMLInitializationEvent event) {
    }

    public EntityPlayer getPlayer() {
        return null;
    }

    public EntityPlayer getPlayerEntityFromContext(MessageContext ctx) {
        return ctx.getServerHandler().field_147369_b;
    }

    public void registerRenderSubBlock(Block block) {
    }

    public void scheduleTask(MessageContext ctx, Runnable runnable) {
        WorldServer worldObj = (WorldServer)ctx.getServerHandler().field_147369_b.field_70170_p;
        worldObj.func_152344_a(runnable);
    }
}

