/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.paleopad;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.jurassicraft.common.entity.data.JCPlayerData;

public class JCFile {
    private boolean dir;
    private String name;
    private JCFile parent;
    private NBTTagCompound data;
    private JCPlayerData playerData;
    private List<JCFile> children = new ArrayList<JCFile>();

    public JCFile(String name, JCFile parent, EntityPlayer player, boolean dir) {
        this.name = name;
        this.parent = parent;
        this.playerData = JCPlayerData.getPlayerData(player);
        if (parent != null) {
            parent.addChild(this);
        } else {
            this.playerData.addRootFile(this);
        }
        this.dir = dir;
    }

    public NBTTagCompound getData() {
        return this.data;
    }

    public void addChild(JCFile file) {
        if (this.children.contains(file)) {
            this.children.remove(file);
        }
        this.children.add(file);
    }

    public void removeChild(JCFile file) {
        this.children.remove(file);
    }

    public List<JCFile> getChildren() {
        return this.children;
    }

    public JCFile getParent() {
        return this.parent;
    }

    public void delete() {
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        this.playerData.remove(this);
    }

    public boolean isDirectory() {
        return this.dir;
    }

    public boolean isFile() {
        return !this.isDirectory();
    }

    public void setData(NBTTagCompound data) {
        this.data = data;
    }

    public String getPath() {
        return (this.parent != null ? this.parent.getPath() + "/" : "") + this.name;
    }

    public String getName() {
        return this.name;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("Name", this.name);
        nbt.func_74757_a("Directory", this.dir);
        if (this.isDirectory()) {
            NBTTagList childrenList = new NBTTagList();
            for (JCFile child : this.children) {
                if (child.equals(this)) continue;
                NBTTagCompound childNBT = new NBTTagCompound();
                child.writeToNBT(childNBT);
                childrenList.func_74742_a((NBTBase)childNBT);
            }
            nbt.func_74782_a("Children", (NBTBase)childrenList);
        } else {
            nbt.func_74782_a("Data", (NBTBase)this.data);
        }
    }

    public static JCFile readFromNBT(NBTTagCompound nbt, EntityPlayer player, JCFile parent) {
        JCFile file = new JCFile(nbt.func_74779_i("Name"), parent, player, nbt.func_74767_n("Directory"));
        if (file.dir) {
            NBTTagList childrenList = nbt.func_150295_c("Children", 10);
            for (int i = 0; i < childrenList.func_74745_c(); ++i) {
                NBTTagCompound childNBT = childrenList.func_150305_b(i);
                file.children.add(JCFile.readFromNBT(childNBT, player, file));
            }
        } else {
            file.setData(nbt.func_74775_l("Data"));
        }
        return parent;
    }

    public String toString() {
        return this.getPath();
    }

    public boolean equals(Object obj) {
        return obj != null && (this.toString().equals(obj.toString()) || obj == this);
    }
}

