/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.message;

import io.netty.buffer.ByteBuf;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.timeless.unilib.utils.MutableVec3;
import org.jurassicraft.JurassiCraft;
import org.jurassicraft.common.message.HelicopterMessages;
import org.jurassicraft.common.vehicles.helicopter.EntityHelicopterBase;

public class MessageHelicopterDirection
implements IMessage {
    private int heliID;
    private MutableVec3 direction;

    public MessageHelicopterDirection() {
        this.direction = new MutableVec3(0.0, 0.0, 0.0);
    }

    public MessageHelicopterDirection(int heliID, MutableVec3 direction) {
        this.heliID = heliID;
        this.direction = direction;
    }

    public void fromBytes(ByteBuf buf) {
        this.heliID = buf.readInt();
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        this.direction.set(x, y, z);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.heliID);
        buf.writeDouble(this.direction.xCoord);
        buf.writeDouble(this.direction.yCoord);
        buf.writeDouble(this.direction.zCoord);
    }

    public static class Handler
    implements IMessageHandler<MessageHelicopterDirection, IMessage> {
        public IMessage onMessage(final MessageHelicopterDirection packet, final MessageContext ctx) {
            JurassiCraft.proxy.scheduleTask(ctx, new Runnable(){

                @Override
                public void run() {
                    World world = null;
                    world = ctx.side == Side.CLIENT ? Handler.this.getClientWorld() : ctx.getServerHandler().field_147369_b.field_70170_p;
                    EntityHelicopterBase helicopter = HelicopterMessages.getHeli(world, packet.heliID);
                    if (helicopter != null) {
                        helicopter.setDirection(packet.direction);
                    }
                }
            });
            return null;
        }

        @SideOnly(value=Side.CLIENT)
        private World getClientWorld() {
            return FMLClientHandler.instance().getWorldClient();
        }
    }
}

