/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.item;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.common.creativetab.JCCreativeTabs;
import org.jurassicraft.common.lang.AdvLang;
import org.jurassicraft.common.plant.JCPlantRegistry;
import org.jurassicraft.common.plant.Plant;

public class ItemPlantDNA
extends Item {
    public ItemPlantDNA() {
        this.func_77655_b("plant_dna");
        this.func_77637_a(JCCreativeTabs.plants);
        this.func_77627_a(true);
    }

    public String func_77653_i(ItemStack stack) {
        String plantName = this.getPlant(stack).getName().toLowerCase().replaceAll(" ", "_");
        return new AdvLang("item.plant_dna.name").withProperty("plant", "plants." + plantName + ".name").build();
    }

    public Plant getPlant(ItemStack stack) {
        Plant plant = JCPlantRegistry.getPlantById(stack.func_77952_i());
        if (plant == null) {
            plant = JCPlantRegistry.small_royal_fern;
        }
        return plant;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List subtypes) {
        ArrayList<Plant> plants = new ArrayList<Plant>(JCPlantRegistry.getPlants());
        HashMap<Plant, Integer> ids = new HashMap<Plant, Integer>();
        int id = 0;
        for (Plant plant : plants) {
            ids.put(plant, id);
            ++id;
        }
        Collections.sort(plants);
        for (Plant plant : plants) {
            if (!plant.shouldRegister()) continue;
            subtypes.add(new ItemStack(item, 1, ((Integer)ids.get(plant)).intValue()));
        }
    }

    public int getDNAQuality(EntityPlayer player, ItemStack stack) {
        int quality = player.field_71075_bZ.field_75098_d ? 100 : 0;
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        if (nbt.func_74764_b("DNAQuality")) {
            quality = nbt.func_74762_e("DNAQuality");
        } else {
            nbt.func_74768_a("DNAQuality", quality);
        }
        stack.func_77982_d(nbt);
        return quality;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List lore, boolean advanced) {
        int quality = this.getDNAQuality(player, stack);
        EnumChatFormatting colour = quality > 75 ? EnumChatFormatting.GREEN : (quality > 50 ? EnumChatFormatting.YELLOW : (quality > 25 ? EnumChatFormatting.GOLD : EnumChatFormatting.RED));
        lore.add(colour + new AdvLang("lore.dna_quality.name").withProperty("quality", quality + "").build());
    }
}

