/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.item;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.BlockFence;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.JurassiCraft;
import org.jurassicraft.common.creativetab.JCCreativeTabs;
import org.jurassicraft.common.dinosaur.Dinosaur;
import org.jurassicraft.common.entity.base.EntityDinosaur;
import org.jurassicraft.common.entity.base.JCEntityRegistry;
import org.jurassicraft.common.lang.AdvLang;

public class ItemDinosaurSpawnEgg
extends Item {
    public ItemDinosaurSpawnEgg() {
        this.func_77655_b("dino_spawn_egg");
        this.func_77627_a(true);
        this.func_77637_a(JCCreativeTabs.spawnEggs);
    }

    public EntityDinosaur spawnCreature(World world, EntityPlayer player, ItemStack stack, double x, double y, double z) {
        Dinosaur dinoInEgg = this.getDinosaur(stack);
        if (dinoInEgg != null) {
            Class<? extends EntityDinosaur> dinoClass = dinoInEgg.getDinosaurClass();
            try {
                EntityDinosaur dino = dinoClass.getConstructor(World.class).newInstance(player.field_70170_p);
                dino.setDNAQuality(100);
                int mode = this.getMode(stack);
                if (mode == 1) {
                    dino.setMale(true);
                } else if (mode == 2) {
                    dino.setMale(false);
                }
                if (player.func_70093_af()) {
                    dino.setAge(0);
                }
                dino.func_70107_b(x, y, z);
                dino.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
                dino.field_70759_as = dino.field_70177_z;
                dino.field_70761_aq = dino.field_70177_z;
                return dino;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        int mode = this.changeMode(stack);
        if (world.field_72995_K) {
            String modeString = "";
            if (mode == 0) {
                modeString = "random";
            } else if (mode == 1) {
                modeString = "male";
            } else if (mode == 2) {
                modeString = "female";
            }
            player.func_145747_a((IChatComponent)new ChatComponentText(new AdvLang("spawnegg.genderchange.name").withProperty("mode", StatCollector.func_74838_a((String)("gender." + modeString + ".name"))).build()));
        }
        return stack;
    }

    public String func_77653_i(ItemStack stack) {
        Dinosaur dinosaur = this.getDinosaur(stack);
        return new AdvLang("item.dino_spawn_egg.name").withProperty("dino", "entity." + dinosaur.getName().replace(" ", "_").toLowerCase() + ".name").build();
    }

    public Dinosaur getDinosaur(ItemStack stack) {
        Dinosaur dinosaur = JCEntityRegistry.getDinosaurById(stack.func_77952_i());
        if (dinosaur == null) {
            dinosaur = JCEntityRegistry.achillobator;
        }
        return dinosaur;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int renderPass) {
        Dinosaur dino = this.getDinosaur(stack);
        if (dino != null) {
            int mode = this.getMode(stack);
            if (mode == 0) {
                int n = mode = JurassiCraft.timerTicks % 64L > 32L ? 1 : 2;
            }
            if (mode == 1) {
                return renderPass == 0 ? dino.getEggPrimaryColorMale() : dino.getEggSecondaryColorMale();
            }
            return renderPass == 0 ? dino.getEggPrimaryColorFemale() : dino.getEggSecondaryColorFemale();
        }
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List subtypes) {
        ArrayList<Dinosaur> dinosaurs = new ArrayList<Dinosaur>(JCEntityRegistry.getDinosaurs());
        HashMap<Dinosaur, Integer> ids = new HashMap<Dinosaur, Integer>();
        int id = 0;
        for (Dinosaur dino : dinosaurs) {
            ids.put(dino, id);
            ++id;
        }
        Collections.sort(dinosaurs);
        for (Dinosaur dino : dinosaurs) {
            if (!dino.shouldRegister()) continue;
            subtypes.add(new ItemStack(item, 1, ((Integer)ids.get(dino)).intValue()));
        }
    }

    public boolean func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        EntityDinosaur dinosaur;
        TileEntity tileentity;
        if (world.field_72995_K) {
            return true;
        }
        if (!player.func_175151_a(pos.func_177972_a(side), side, stack)) {
            return false;
        }
        IBlockState iblockstate = world.func_180495_p(pos);
        if (iblockstate.func_177230_c() == Blocks.field_150474_ac && (tileentity = world.func_175625_s(pos)) instanceof TileEntityMobSpawner) {
            MobSpawnerBaseLogic mobspawnerbaselogic = ((TileEntityMobSpawner)tileentity).func_145881_a();
            mobspawnerbaselogic.func_98272_a((String)EntityList.field_75626_c.get(this.getDinosaur(stack).getDinosaurClass()));
            tileentity.func_70296_d();
            world.func_175689_h(pos);
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            return true;
        }
        pos = pos.func_177972_a(side);
        double yOffset = 0.0;
        if (side == EnumFacing.UP && iblockstate.func_177230_c() instanceof BlockFence) {
            yOffset = 0.5;
        }
        if ((dinosaur = this.spawnCreature(world, player, stack, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + yOffset, (double)pos.func_177952_p() + 0.5)) != null) {
            if (stack.func_82837_s()) {
                dinosaur.func_96094_a(stack.func_82833_r());
            }
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            world.func_72838_d((Entity)dinosaur);
            dinosaur.func_70642_aH();
        }
        return true;
    }

    public int getMode(ItemStack stack) {
        return this.getNBT(stack).func_74762_e("GenderMode");
    }

    public int changeMode(ItemStack stack) {
        NBTTagCompound nbt = this.getNBT(stack);
        int mode = this.getMode(stack);
        if (++mode > 2) {
            mode = 0;
        }
        nbt.func_74768_a("GenderMode", mode);
        stack.func_77982_d(nbt);
        return mode;
    }

    public NBTTagCompound getNBT(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        stack.func_77982_d(nbt);
        return nbt;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List lore, boolean advanced) {
        lore.add(StatCollector.func_74838_a((String)"lore.baby_dino.name"));
        lore.add(StatCollector.func_74838_a((String)"lore.change_gender.name"));
    }
}

