/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.item;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.common.creativetab.JCCreativeTabs;
import org.jurassicraft.common.dinosaur.Dinosaur;
import org.jurassicraft.common.entity.base.JCEntityRegistry;
import org.jurassicraft.common.genetics.GeneticsContainer;
import org.jurassicraft.common.genetics.GeneticsHelper;
import org.jurassicraft.common.lang.AdvLang;

public class ItemDinosaurMeat
extends ItemFood {
    public ItemDinosaurMeat() {
        super(3, 0.3f, true);
        this.func_77655_b("dinosaur_meat");
        this.func_77627_a(true);
        this.func_77637_a(JCCreativeTabs.foods);
    }

    public String func_77653_i(ItemStack stack) {
        Dinosaur dinosaur = this.getDinosaur(stack);
        return new AdvLang("item.dinosaur_meat.name").withProperty("dino", "entity." + dinosaur.getName().replace(" ", "_").toLowerCase() + ".name").build();
    }

    public Dinosaur getDinosaur(ItemStack stack) {
        Dinosaur dinosaur = JCEntityRegistry.getDinosaurById(stack.func_77952_i());
        if (dinosaur == null) {
            dinosaur = JCEntityRegistry.achillobator;
        }
        return dinosaur;
    }

    public int getContainerDinosaur(ItemStack stack) {
        return JCEntityRegistry.getDinosaurId(this.getDinosaur(stack));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List subtypes) {
        ArrayList<Dinosaur> dinosaurs = new ArrayList<Dinosaur>(JCEntityRegistry.getDinosaurs());
        HashMap<Dinosaur, Integer> ids = new HashMap<Dinosaur, Integer>();
        int id = 0;
        for (Dinosaur dino : dinosaurs) {
            ids.put(dino, id);
            ++id;
        }
        Collections.sort(dinosaurs);
        for (Dinosaur dino : dinosaurs) {
            if (!dino.shouldRegister()) continue;
            subtypes.add(new ItemStack(item, 1, ((Integer)ids.get(dino)).intValue()));
        }
    }

    public int getDNAQuality(EntityPlayer player, ItemStack stack) {
        int quality = player.field_71075_bZ.field_75098_d ? 100 : 0;
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        if (nbt.func_74764_b("DNAQuality")) {
            quality = nbt.func_74762_e("DNAQuality");
        } else {
            nbt.func_74768_a("DNAQuality", quality);
        }
        stack.func_77982_d(nbt);
        return quality;
    }

    public GeneticsContainer getGeneticCode(EntityPlayer player, ItemStack stack) {
        int quality = this.getDNAQuality(player, stack);
        NBTTagCompound nbt = stack.func_77978_p();
        GeneticsContainer genetics = GeneticsHelper.randomGenetics(player.field_70170_p.field_73012_v, this.getContainerDinosaur(stack), quality);
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        if (nbt.func_74764_b("Genetics")) {
            genetics = new GeneticsContainer(nbt.func_74779_i("Genetics"));
        } else {
            nbt.func_74778_a("Genetics", genetics.toString());
        }
        stack.func_77982_d(nbt);
        return genetics;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List lore, boolean advanced) {
        int quality = this.getDNAQuality(player, stack);
        EnumChatFormatting colour = quality > 75 ? EnumChatFormatting.GREEN : (quality > 50 ? EnumChatFormatting.YELLOW : (quality > 25 ? EnumChatFormatting.GOLD : EnumChatFormatting.RED));
        lore.add(colour + new AdvLang("lore.dna_quality.name").withProperty("quality", quality + "").build());
        lore.add(EnumChatFormatting.BLUE + new AdvLang("lore.genetic_code.name").withProperty("code", this.getGeneticCode(player, stack).toString()).build());
    }
}

