/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.genetics;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import org.jurassicraft.common.lang.AdvLang;
import org.jurassicraft.common.plant.JCPlantRegistry;

public class PlantDNA {
    private int plant;
    private int quality;

    public PlantDNA(int plant, int quality) {
        this.plant = plant;
        this.quality = quality;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("DNAQuality", this.quality);
        nbt.func_74768_a("Plant", this.plant);
        nbt.func_74778_a("StorageId", "PlantDNA");
    }

    public static PlantDNA fromStack(ItemStack stack) {
        return PlantDNA.readFromNBT(stack.func_77978_p());
    }

    public static PlantDNA readFromNBT(NBTTagCompound nbt) {
        return new PlantDNA(nbt.func_74762_e("Plant"), nbt.func_74762_e("DNAQuality"));
    }

    public int getDNAQuality() {
        return this.quality;
    }

    public int getPlant() {
        return this.plant;
    }

    public void addInformation(ItemStack stack, List<String> tooltip) {
        tooltip.add(EnumChatFormatting.DARK_AQUA + new AdvLang("lore.plant.name").withProperty("plant", "plants." + JCPlantRegistry.getPlantById(this.plant).getName().toLowerCase().replaceAll(" ", "_") + ".name").build());
        EnumChatFormatting colour = this.quality > 75 ? EnumChatFormatting.GREEN : (this.quality > 50 ? EnumChatFormatting.YELLOW : (this.quality > 25 ? EnumChatFormatting.GOLD : EnumChatFormatting.RED));
        tooltip.add(colour + new AdvLang("lore.dna_quality.name").withProperty("quality", this.quality + "").build());
    }
}

