/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.genetics;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import org.jurassicraft.common.entity.base.JCEntityRegistry;
import org.jurassicraft.common.genetics.GeneticsContainer;
import org.jurassicraft.common.lang.AdvLang;

public class DinoDNA {
    private int quality;
    private GeneticsContainer genetics;

    public DinoDNA(int quality, String genetics) {
        this.quality = quality;
        this.genetics = new GeneticsContainer(genetics);
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("DNAQuality", this.quality);
        nbt.func_74778_a("Genetics", this.genetics.toString());
        nbt.func_74778_a("StorageId", "DinoDNA");
    }

    public static DinoDNA fromStack(ItemStack stack) {
        return DinoDNA.readFromNBT(stack.func_77978_p());
    }

    public static DinoDNA readFromNBT(NBTTagCompound nbt) {
        return new DinoDNA(nbt.func_74762_e("DNAQuality"), nbt.func_74779_i("Genetics"));
    }

    public int getDNAQuality() {
        return this.quality;
    }

    public String toString() {
        return this.genetics.toString();
    }

    public GeneticsContainer getContainer() {
        return this.genetics;
    }

    public void addInformation(ItemStack stack, List<String> tooltip) {
        tooltip.add(EnumChatFormatting.DARK_AQUA + new AdvLang("lore.dinosaur.name").withProperty("dino", "entity." + JCEntityRegistry.getDinosaurById(this.genetics.getDinosaur()).getName().toLowerCase() + ".name").build());
        EnumChatFormatting colour = this.quality > 75 ? EnumChatFormatting.GREEN : (this.quality > 50 ? EnumChatFormatting.YELLOW : (this.quality > 25 ? EnumChatFormatting.GOLD : EnumChatFormatting.RED));
        tooltip.add(colour + new AdvLang("lore.dna_quality.name").withProperty("quality", this.quality + "").build());
        tooltip.add(EnumChatFormatting.BLUE + new AdvLang("lore.genetic_code.name").withProperty("code", this.genetics.toString()).build());
    }
}

