/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.food;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.jurassicraft.common.entity.base.EnumDiet;
import org.jurassicraft.common.food.EnumFoodType;
import org.jurassicraft.common.item.JCItemRegistry;

public class FoodHelper {
    private static final Map<EnumFoodType, List<Item>> foods = new HashMap<EnumFoodType, List<Item>>();
    private static final List<Item> allFoods = new ArrayList<Item>();

    public static void init() {
        FoodHelper.registerFood(Items.field_151034_e, EnumFoodType.PLANT);
        FoodHelper.registerFood(Items.field_151174_bG, EnumFoodType.PLANT);
        FoodHelper.registerFood(Items.field_151172_bF, EnumFoodType.PLANT);
        FoodHelper.registerFood(Items.field_151015_O, EnumFoodType.PLANT);
        FoodHelper.registerFood(Items.field_151014_N, EnumFoodType.PLANT);
        FoodHelper.registerFood(Items.field_151081_bc, EnumFoodType.PLANT);
        FoodHelper.registerFood(Items.field_151080_bb, EnumFoodType.PLANT);
        FoodHelper.registerFood(Items.field_151127_ba, EnumFoodType.PLANT);
        FoodHelper.registerFood(Items.field_151082_bd, EnumFoodType.MEAT);
        FoodHelper.registerFood(Items.field_151083_be, EnumFoodType.MEAT);
        FoodHelper.registerFood(Items.field_151147_al, EnumFoodType.MEAT);
        FoodHelper.registerFood(Items.field_151157_am, EnumFoodType.MEAT);
        FoodHelper.registerFood(Items.field_151076_bf, EnumFoodType.MEAT);
        FoodHelper.registerFood(Items.field_151077_bg, EnumFoodType.MEAT);
        FoodHelper.registerFood(Items.field_151115_aP, EnumFoodType.FISH);
        FoodHelper.registerFood(Items.field_179566_aV, EnumFoodType.MEAT);
        FoodHelper.registerFood(Items.field_179561_bm, EnumFoodType.MEAT);
        FoodHelper.registerFood(Items.field_179557_bn, EnumFoodType.MEAT);
        FoodHelper.registerFood(Items.field_179558_bo, EnumFoodType.MEAT);
        FoodHelper.registerFood(Items.field_179559_bp, EnumFoodType.MEAT);
        FoodHelper.registerFood((Item)JCItemRegistry.dino_meat, EnumFoodType.MEAT);
        FoodHelper.registerFood((Item)JCItemRegistry.dino_steak, EnumFoodType.MEAT);
        for (Item item : Item.field_150901_e) {
            String resourceDomain = ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)item)).func_110624_b();
            if (resourceDomain.equals("minecraft") || !(item instanceof ItemFood)) continue;
            ItemFood food = (ItemFood)item;
            if (food.func_150905_g(new ItemStack((Item)food)) > 3) {
                FoodHelper.registerFood((Item)food, EnumFoodType.PLANT);
                continue;
            }
            FoodHelper.registerFood((Item)food, EnumFoodType.MEAT);
        }
    }

    public static void registerFood(Item food, EnumFoodType foodType) {
        if (!allFoods.contains(food)) {
            List<Item> foodsForType = foods.get((Object)foodType);
            if (foodsForType == null) {
                foodsForType = new ArrayList<Item>();
            }
            foodsForType.add(food);
            allFoods.add(food);
            foods.put(foodType, foodsForType);
        }
    }

    public static List<Item> getFoodsForFoodType(EnumFoodType type) {
        return foods.get((Object)type);
    }

    public static EnumFoodType getFoodType(Item item) {
        for (EnumFoodType foodType : EnumFoodType.values()) {
            if (!FoodHelper.getFoodsForFoodType(foodType).contains(item)) continue;
            return foodType;
        }
        return null;
    }

    public static boolean canDietEat(EnumDiet diet, Item item) {
        return FoodHelper.getFoodsForDiet(diet).contains(item);
    }

    private static List<Item> getFoodsForDiet(EnumDiet diet) {
        ArrayList<Item> possibleItems = new ArrayList<Item>();
        if (diet.doesEatPlants()) {
            possibleItems.addAll(FoodHelper.getFoodsForFoodType(EnumFoodType.PLANT));
        }
        if (diet.doesEatFish()) {
            possibleItems.addAll(FoodHelper.getFoodsForFoodType(EnumFoodType.FISH));
        }
        if (diet.doesEatMeat()) {
            possibleItems.addAll(FoodHelper.getFoodsForFoodType(EnumFoodType.MEAT));
        }
        return possibleItems;
    }
}

