/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.entity.item;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.common.item.JCItemRegistry;

public class EntityJurassiCraftSign
extends EntityHanging
implements IEntityAdditionalSpawnData {
    public EnumSignType signType;

    public EntityJurassiCraftSign(World world) {
        super(world);
    }

    public EntityJurassiCraftSign(World world, BlockPos blockPos, EnumFacing enumFacing) {
        super(world, blockPos);
        ArrayList arraylist = Lists.newArrayList();
        EnumSignType[] aenumart = EnumSignType.values();
        int i = aenumart.length;
        for (int j = 0; j < i; ++j) {
            EnumSignType enumart;
            this.signType = enumart = aenumart[j];
            this.func_174859_a(enumFacing);
            if (!this.func_70518_d()) continue;
            arraylist.add(enumart);
        }
        if (!arraylist.isEmpty()) {
            this.signType = (EnumSignType)((Object)arraylist.get(this.field_70146_Z.nextInt(arraylist.size())));
        }
        this.func_174859_a(enumFacing);
    }

    @SideOnly(value=Side.CLIENT)
    public EntityJurassiCraftSign(World world, BlockPos pos, EnumFacing enumFacing, String titleName) {
        this(world, pos, enumFacing);
        this.setType(titleName);
        this.func_174859_a(enumFacing);
    }

    private void setType(String titleName) {
        for (EnumSignType enumart : EnumSignType.values()) {
            if (!enumart.title.equals(titleName)) continue;
            this.signType = enumart;
            break;
        }
        if (this.signType == null) {
            this.signType = EnumSignType.GENTLE_GIANTS;
        }
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        tagCompound.func_74778_a("Motive", this.signType.title);
        super.func_70014_b(tagCompound);
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        String s = tagCompund.func_74779_i("Motive");
        this.setType(s);
        super.func_70037_a(tagCompund);
    }

    public int func_82329_d() {
        return this.signType.sizeX;
    }

    public int func_82330_g() {
        return this.signType.sizeY;
    }

    public void func_110128_b(Entity entity) {
        if (this.field_70170_p.func_82736_K().func_82766_b("doTileDrops")) {
            if (entity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                if (entityplayer.field_71075_bZ.field_75098_d) {
                    return;
                }
            }
            this.func_70099_a(new ItemStack((Item)JCItemRegistry.jc_sign), 0.0f);
        }
    }

    public void func_70012_b(double x, double y, double z, float yaw, float pitch) {
        BlockPos blockpos = new BlockPos(x - this.field_70165_t, y - this.field_70163_u, z - this.field_70161_v);
        BlockPos blockpos1 = this.field_174861_a.func_177971_a((Vec3i)blockpos);
        this.func_70107_b(blockpos1.func_177958_n(), blockpos1.func_177956_o(), blockpos1.func_177952_p());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean p_180426_10_) {
    }

    public void writeSpawnData(ByteBuf buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.signType.title);
        buffer.writeLong(this.field_174861_a.func_177986_g());
        buffer.writeByte(this.field_174860_b.func_176736_b());
    }

    public void readSpawnData(ByteBuf buf) {
        this.setType(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.field_174861_a = BlockPos.func_177969_a((long)buf.readLong());
        this.func_174859_a(EnumFacing.func_176731_b((int)buf.readByte()));
    }

    public static enum EnumSignType {
        GENTLE_GIANTS("Gentle Giants", 128, 64, 0, 0);

        public final String title;
        public final int sizeX;
        public final int sizeY;
        public final int offsetX;
        public final int offsetY;

        private EnumSignType(String title, int xSize, int ySize, int textureX, int textureY) {
            this.title = title;
            this.sizeX = xSize;
            this.sizeY = ySize;
            this.offsetX = textureX;
            this.offsetY = textureY;
        }
    }
}

