/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.entity.base;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import org.jurassicraft.common.entity.base.EntityDinosaur;

public class MetabolismContainer {
    public static final int MAX_FOOD = 24000;
    public static final int MAX_WATER = 24000;
    private int food;
    private int water;
    private EntityDinosaur dinosaur;

    public MetabolismContainer(EntityDinosaur dinosaur) {
        this.dinosaur = dinosaur;
        this.food = 24000;
        this.water = 24000;
    }

    public void update() {
        if (!this.dinosaur.field_70128_L && !this.dinosaur.isCarcass() && this.dinosaur.field_70170_p.func_82736_K().func_82766_b("dinoMetabolism")) {
            this.decreaseFood(1);
            this.decreaseWater(1);
            if (this.dinosaur.func_70026_G()) {
                this.water = 24000;
            }
        }
    }

    public int getWater() {
        return this.water;
    }

    public int getFood() {
        return this.food;
    }

    public void decreaseFood(int amount) {
        this.food -= amount;
        if (this.food <= 0) {
            this.dinosaur.func_70097_a(DamageSource.field_76380_i, 1.0f);
        }
    }

    public void decreaseWater(int amount) {
        this.water -= amount;
        if (this.water <= 0) {
            this.dinosaur.func_70097_a(DamageSource.field_76380_i, 1.0f);
        }
    }

    public void setWater(int water) {
        this.water = Math.min(water, 24000);
    }

    public void setFood(int food) {
        this.food = Math.min(food, 24000);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.water = nbt.func_74762_e("Water");
        this.food = nbt.func_74762_e("Food");
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("Water", this.water);
        nbt.func_74768_a("Food", this.food);
    }

    public void writeSpawnData(ByteBuf buf) {
        buf.writeInt(this.water);
        buf.writeInt(this.food);
    }

    public void readSpawnData(ByteBuf buf) {
        this.water = buf.readInt();
        this.food = buf.readInt();
    }

    public int getMaxFood() {
        return 24000;
    }

    public int getMaxWater() {
        return 24000;
    }

    public void increaseFood(int amount) {
        this.setFood(this.food + amount);
    }

    public void increaseWater(int amount) {
        this.setWater(this.water + amount);
    }
}

