/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.entity.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import org.jurassicraft.JurassiCraft;
import org.jurassicraft.common.api.IHybrid;
import org.jurassicraft.common.configuration.JCConfigurations;
import org.jurassicraft.common.dinosaur.Dinosaur;
import org.jurassicraft.common.dinosaur.DinosaurAchillobator;
import org.jurassicraft.common.dinosaur.DinosaurAnkylosaurus;
import org.jurassicraft.common.dinosaur.DinosaurApatosaurus;
import org.jurassicraft.common.dinosaur.DinosaurBaryonyx;
import org.jurassicraft.common.dinosaur.DinosaurBrachiosaurus;
import org.jurassicraft.common.dinosaur.DinosaurCarnotaurus;
import org.jurassicraft.common.dinosaur.DinosaurCearadactylus;
import org.jurassicraft.common.dinosaur.DinosaurChasmosaurus;
import org.jurassicraft.common.dinosaur.DinosaurCoelacanth;
import org.jurassicraft.common.dinosaur.DinosaurCompsognathus;
import org.jurassicraft.common.dinosaur.DinosaurCorythosaurus;
import org.jurassicraft.common.dinosaur.DinosaurDilophosaurus;
import org.jurassicraft.common.dinosaur.DinosaurDimorphodon;
import org.jurassicraft.common.dinosaur.DinosaurDodo;
import org.jurassicraft.common.dinosaur.DinosaurDunkleosteus;
import org.jurassicraft.common.dinosaur.DinosaurEdmontosaurus;
import org.jurassicraft.common.dinosaur.DinosaurGallimimus;
import org.jurassicraft.common.dinosaur.DinosaurGiganotosaurus;
import org.jurassicraft.common.dinosaur.DinosaurHerrerasaurus;
import org.jurassicraft.common.dinosaur.DinosaurHypsilophodon;
import org.jurassicraft.common.dinosaur.DinosaurIndominus;
import org.jurassicraft.common.dinosaur.DinosaurLambeosaurus;
import org.jurassicraft.common.dinosaur.DinosaurLeaellynasaura;
import org.jurassicraft.common.dinosaur.DinosaurLeptictidium;
import org.jurassicraft.common.dinosaur.DinosaurLudodactylus;
import org.jurassicraft.common.dinosaur.DinosaurMajungasaurus;
import org.jurassicraft.common.dinosaur.DinosaurMamenchisaurus;
import org.jurassicraft.common.dinosaur.DinosaurMegapiranha;
import org.jurassicraft.common.dinosaur.DinosaurMetriacanthosaurus;
import org.jurassicraft.common.dinosaur.DinosaurMicroceratus;
import org.jurassicraft.common.dinosaur.DinosaurMoganopterus;
import org.jurassicraft.common.dinosaur.DinosaurOrnithomimus;
import org.jurassicraft.common.dinosaur.DinosaurOthnielia;
import org.jurassicraft.common.dinosaur.DinosaurOviraptor;
import org.jurassicraft.common.dinosaur.DinosaurPachycephalosaurus;
import org.jurassicraft.common.dinosaur.DinosaurParasaurolophus;
import org.jurassicraft.common.dinosaur.DinosaurProtoceratops;
import org.jurassicraft.common.dinosaur.DinosaurPteranodon;
import org.jurassicraft.common.dinosaur.DinosaurRugops;
import org.jurassicraft.common.dinosaur.DinosaurSegisaurus;
import org.jurassicraft.common.dinosaur.DinosaurSpinosaurus;
import org.jurassicraft.common.dinosaur.DinosaurStegosaurus;
import org.jurassicraft.common.dinosaur.DinosaurTherizinosaurus;
import org.jurassicraft.common.dinosaur.DinosaurTriceratops;
import org.jurassicraft.common.dinosaur.DinosaurTroodon;
import org.jurassicraft.common.dinosaur.DinosaurTropeognathus;
import org.jurassicraft.common.dinosaur.DinosaurTylosaurus;
import org.jurassicraft.common.dinosaur.DinosaurTyrannosaurus;
import org.jurassicraft.common.dinosaur.DinosaurVelociraptor;
import org.jurassicraft.common.dinosaur.DinosaurVelociraptorBlue;
import org.jurassicraft.common.dinosaur.DinosaurVelociraptorCharlie;
import org.jurassicraft.common.dinosaur.DinosaurVelociraptorDelta;
import org.jurassicraft.common.dinosaur.DinosaurVelociraptorEcho;
import org.jurassicraft.common.dinosaur.DinosaurZhenyuanopterus;
import org.jurassicraft.common.entity.base.EntityDinosaur;
import org.jurassicraft.common.entity.item.EntityBluePrint;
import org.jurassicraft.common.entity.item.EntityCageSmall;
import org.jurassicraft.common.entity.item.EntityJurassiCraftSign;
import org.jurassicraft.common.entity.item.EntityPaddockSign;
import org.jurassicraft.common.period.EnumTimePeriod;
import org.jurassicraft.common.vehicles.helicopter.EntityHelicopterBase;
import org.jurassicraft.common.vehicles.helicopter.modules.EntityHelicopterSeat;

public class JCEntityRegistry {
    private static List<Dinosaur> dinosaurs = new ArrayList<Dinosaur>();
    private static HashMap<EnumTimePeriod, List<Dinosaur>> dinosaursFromPeriod = new HashMap();
    public static final Dinosaur dodo = new DinosaurDodo();
    public static final Dinosaur achillobator = new DinosaurAchillobator();
    public static final Dinosaur anklyosaurus = new DinosaurAnkylosaurus();
    public static final Dinosaur brachiosaurus = new DinosaurBrachiosaurus();
    public static final Dinosaur carnotaurus = new DinosaurCarnotaurus();
    public static final Dinosaur coelacanth = new DinosaurCoelacanth();
    public static final Dinosaur compsognathus = new DinosaurCompsognathus();
    public static final Dinosaur dilophosaurus = new DinosaurDilophosaurus();
    public static final Dinosaur dunkleosteus = new DinosaurDunkleosteus();
    public static final Dinosaur gallimimus = new DinosaurGallimimus();
    public static final Dinosaur giganotosaurus = new DinosaurGiganotosaurus();
    public static final Dinosaur hypsilophodon = new DinosaurHypsilophodon();
    public static final Dinosaur indominus = new DinosaurIndominus();
    public static final Dinosaur majungasaurus = new DinosaurMajungasaurus();
    public static final Dinosaur parasaurolophus = new DinosaurParasaurolophus();
    public static final Dinosaur pteranodon = new DinosaurPteranodon();
    public static final Dinosaur rugops = new DinosaurRugops();
    public static final Dinosaur segisaurus = new DinosaurSegisaurus();
    public static final Dinosaur spinosaurus = new DinosaurSpinosaurus();
    public static final Dinosaur stegosaurus = new DinosaurStegosaurus();
    public static final Dinosaur triceratops = new DinosaurTriceratops();
    public static final Dinosaur tyrannosaurus = new DinosaurTyrannosaurus();
    public static final Dinosaur velociraptor = new DinosaurVelociraptor();
    public static final Dinosaur leptictidium = new DinosaurLeptictidium();
    public static final Dinosaur microceratus = new DinosaurMicroceratus();
    public static final Dinosaur oviraptor = new DinosaurOviraptor();
    public static final Dinosaur apatosaurus = new DinosaurApatosaurus();
    public static final Dinosaur othnielia = new DinosaurOthnielia();
    public static final Dinosaur dimorphodon = new DinosaurDimorphodon();
    public static final Dinosaur tylosaurus = new DinosaurTylosaurus();
    public static final Dinosaur ludodactylus = new DinosaurLudodactylus();
    public static final Dinosaur protoceratops = new DinosaurProtoceratops();
    public static final Dinosaur tropeognathus = new DinosaurTropeognathus();
    public static final Dinosaur leaellynasaura = new DinosaurLeaellynasaura();
    public static final Dinosaur herrerasaurus = new DinosaurHerrerasaurus();
    public static final Dinosaur velociraptor_blue = new DinosaurVelociraptorBlue();
    public static final Dinosaur velociraptor_delta = new DinosaurVelociraptorDelta();
    public static final Dinosaur velociraptor_charlie = new DinosaurVelociraptorCharlie();
    public static final Dinosaur velociraptor_echo = new DinosaurVelociraptorEcho();
    public static final Dinosaur therizinosaurus = new DinosaurTherizinosaurus();
    public static final Dinosaur megapiranha = new DinosaurMegapiranha();
    public static final Dinosaur baryonyx = new DinosaurBaryonyx();
    public static final Dinosaur cearadactylus = new DinosaurCearadactylus();
    public static final Dinosaur mamenchisaurus = new DinosaurMamenchisaurus();
    public static final Dinosaur chasmosaurus = new DinosaurChasmosaurus();
    public static final Dinosaur corythosaurus = new DinosaurCorythosaurus();
    public static final Dinosaur edmontosaurus = new DinosaurEdmontosaurus();
    public static final Dinosaur lambeosaurus = new DinosaurLambeosaurus();
    public static final Dinosaur metriacanthosaurus = new DinosaurMetriacanthosaurus();
    public static final Dinosaur moganopterus = new DinosaurMoganopterus();
    public static final Dinosaur ornithomimus = new DinosaurOrnithomimus();
    public static final Dinosaur zhenyuanopterus = new DinosaurZhenyuanopterus();
    public static final Dinosaur troodon = new DinosaurTroodon();
    public static final Dinosaur pachycephalosaurus = new DinosaurPachycephalosaurus();

    public static List<Dinosaur> getDinosaursFromSeaLampreys() {
        ArrayList<Dinosaur> marineDinos = new ArrayList<Dinosaur>();
        for (Dinosaur dino : JCEntityRegistry.getRegisteredDinosaurs()) {
            if (!dino.isMarineAnimal() || dino instanceof IHybrid) continue;
            marineDinos.add(dino);
        }
        return marineDinos;
    }

    public void register() {
        JCEntityRegistry.registerDinosaurType(velociraptor);
        JCEntityRegistry.registerDinosaurType(achillobator);
        JCEntityRegistry.registerDinosaurType(anklyosaurus);
        JCEntityRegistry.registerDinosaurType(brachiosaurus);
        JCEntityRegistry.registerDinosaurType(carnotaurus);
        JCEntityRegistry.registerDinosaurType(coelacanth);
        JCEntityRegistry.registerDinosaurType(compsognathus);
        JCEntityRegistry.registerDinosaurType(dilophosaurus);
        JCEntityRegistry.registerDinosaurType(dunkleosteus);
        JCEntityRegistry.registerDinosaurType(gallimimus);
        JCEntityRegistry.registerDinosaurType(giganotosaurus);
        JCEntityRegistry.registerDinosaurType(indominus);
        JCEntityRegistry.registerDinosaurType(majungasaurus);
        JCEntityRegistry.registerDinosaurType(parasaurolophus);
        JCEntityRegistry.registerDinosaurType(pteranodon);
        JCEntityRegistry.registerDinosaurType(rugops);
        JCEntityRegistry.registerDinosaurType(segisaurus);
        JCEntityRegistry.registerDinosaurType(spinosaurus);
        JCEntityRegistry.registerDinosaurType(stegosaurus);
        JCEntityRegistry.registerDinosaurType(triceratops);
        JCEntityRegistry.registerDinosaurType(tyrannosaurus);
        JCEntityRegistry.registerDinosaurType(hypsilophodon);
        JCEntityRegistry.registerDinosaurType(dodo);
        JCEntityRegistry.registerDinosaurType(leptictidium);
        JCEntityRegistry.registerDinosaurType(microceratus);
        JCEntityRegistry.registerDinosaurType(oviraptor);
        JCEntityRegistry.registerDinosaurType(apatosaurus);
        JCEntityRegistry.registerDinosaurType(othnielia);
        JCEntityRegistry.registerDinosaurType(dimorphodon);
        JCEntityRegistry.registerDinosaurType(tylosaurus);
        JCEntityRegistry.registerDinosaurType(ludodactylus);
        JCEntityRegistry.registerDinosaurType(protoceratops);
        JCEntityRegistry.registerDinosaurType(tropeognathus);
        JCEntityRegistry.registerDinosaurType(leaellynasaura);
        JCEntityRegistry.registerDinosaurType(herrerasaurus);
        JCEntityRegistry.registerDinosaurType(velociraptor_blue);
        JCEntityRegistry.registerDinosaurType(velociraptor_charlie);
        JCEntityRegistry.registerDinosaurType(velociraptor_delta);
        JCEntityRegistry.registerDinosaurType(velociraptor_echo);
        JCEntityRegistry.registerDinosaurType(therizinosaurus);
        JCEntityRegistry.registerDinosaurType(megapiranha);
        JCEntityRegistry.registerDinosaurType(baryonyx);
        JCEntityRegistry.registerDinosaurType(cearadactylus);
        JCEntityRegistry.registerDinosaurType(mamenchisaurus);
        JCEntityRegistry.registerDinosaurType(chasmosaurus);
        JCEntityRegistry.registerDinosaurType(corythosaurus);
        JCEntityRegistry.registerDinosaurType(edmontosaurus);
        JCEntityRegistry.registerDinosaurType(lambeosaurus);
        JCEntityRegistry.registerDinosaurType(metriacanthosaurus);
        JCEntityRegistry.registerDinosaurType(moganopterus);
        JCEntityRegistry.registerDinosaurType(ornithomimus);
        JCEntityRegistry.registerDinosaurType(zhenyuanopterus);
        JCEntityRegistry.registerDinosaurType(troodon);
        JCEntityRegistry.registerDinosaurType(pachycephalosaurus);
        this.registerEntity(EntityBluePrint.class, "Blueprint");
        this.registerEntity(EntityJurassiCraftSign.class, "JurassiCraft Sign");
        this.registerEntity(EntityCageSmall.class, "Small Dinosaur Cage");
        this.registerEntity(EntityPaddockSign.class, "Paddock Sign");
        this.registerEntity(EntityHelicopterBase.class, "Helicopter base");
        this.registerEntity(EntityHelicopterSeat.class, "Helicopter seat Do not spawn please, like really don't");
        for (Dinosaur dinosaur : dinosaurs) {
            this.registerDinosaur(dinosaur);
        }
    }

    public void registerDinosaur(Dinosaur dinosaur) {
        if (dinosaur.shouldRegister()) {
            this.registerEntity(dinosaur.getDinosaurClass(), dinosaur.getName());
            if (dinosaur.shouldRegister() && !(dinosaur instanceof IHybrid) && JCConfigurations.spawnJurassiCraftMobsNaturally()) {
                if (dinosaur.isMarineAnimal()) {
                    EntityRegistry.addSpawn(dinosaur.getDinosaurClass(), (int)5, (int)1, (int)5, (EnumCreatureType)EnumCreatureType.WATER_CREATURE, (BiomeGenBase[])new BiomeGenBase[]{BiomeGenBase.field_76771_b, BiomeGenBase.field_150575_M, BiomeGenBase.field_76781_i});
                } else {
                    EntityRegistry.addSpawn(dinosaur.getDinosaurClass(), (int)5, (int)1, (int)5, (EnumCreatureType)EnumCreatureType.CREATURE, (BiomeGenBase[])this.removeNullEntries(BiomeGenBase.func_150565_n()));
                }
            }
        }
    }

    public BiomeGenBase[] removeNullEntries(BiomeGenBase[] original) {
        int from;
        int index = from = original.length;
        int to = from;
        while (index > 0) {
            BiomeGenBase biome;
            if ((biome = original[--index]) == null) continue;
            original[--from] = biome;
        }
        return Arrays.copyOfRange(original, from, to);
    }

    private void registerEntity(Class<? extends Entity> entity, String name) {
        int entityId = EntityRegistry.findGlobalUniqueEntityId();
        String formattedName = name.toLowerCase().replaceAll(" ", "_");
        EntityRegistry.registerGlobalEntityID(entity, (String)formattedName, (int)entityId);
        EntityRegistry.registerModEntity(entity, (String)formattedName, (int)entityId, (Object)JurassiCraft.instance, (int)1024, (int)1, (boolean)true);
    }

    public static void registerDinosaurType(Dinosaur dinosaur) {
        dinosaur.init();
        dinosaurs.add(dinosaur);
        if (!(dinosaur instanceof IHybrid) && dinosaur.shouldRegister()) {
            EnumTimePeriod period = dinosaur.getPeriod();
            List<Dinosaur> dinoList = dinosaursFromPeriod.get((Object)period);
            if (dinoList != null) {
                dinoList.add(dinosaur);
                dinosaursFromPeriod.remove((Object)period);
                dinosaursFromPeriod.put(period, dinoList);
            } else {
                ArrayList<Dinosaur> newDinoList = new ArrayList<Dinosaur>();
                newDinoList.add(dinosaur);
                dinosaursFromPeriod.put(period, newDinoList);
            }
        }
    }

    public static Dinosaur getDinosaurById(int id) {
        if (id >= dinosaurs.size() || id < 0) {
            return null;
        }
        return dinosaurs.get(id);
    }

    public static int getDinosaurId(Dinosaur dinosaur) {
        return dinosaurs.indexOf(dinosaur);
    }

    public static List<Dinosaur> getDinosaursFromAmber() {
        ArrayList<Dinosaur> amberDinos = new ArrayList<Dinosaur>();
        for (Dinosaur dino : JCEntityRegistry.getRegisteredDinosaurs()) {
            if (dino.isMarineAnimal() || dino instanceof IHybrid) continue;
            amberDinos.add(dino);
        }
        return amberDinos;
    }

    public static List<Dinosaur> getDinosaurs() {
        return dinosaurs;
    }

    public static List<Dinosaur> getRegisteredDinosaurs() {
        ArrayList<Dinosaur> reg = new ArrayList<Dinosaur>();
        for (Dinosaur dino : dinosaurs) {
            if (!dino.shouldRegister()) continue;
            reg.add(dino);
        }
        return reg;
    }

    public static List<Dinosaur> getDinosaursFromPeriod(EnumTimePeriod period) {
        return dinosaursFromPeriod.get((Object)period);
    }

    public static Dinosaur getDinosaurByClass(Class<? extends EntityDinosaur> clazz) {
        for (Dinosaur dino : dinosaurs) {
            if (!dino.getDinosaurClass().equals(clazz)) continue;
            return dino;
        }
        return null;
    }
}

