/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.entity.base;

import java.util.Random;

public enum EnumSleepingSchedule {
    DIURNAL(EnumSleepingSchedule.fromTimeToTicks(6, 0), EnumSleepingSchedule.fromTimeToTicks(22, 0)),
    NOCTURNAL(EnumSleepingSchedule.fromTimeToTicks(18, 0), EnumSleepingSchedule.fromTimeToTicks(6, 0)),
    CREPUSCULAR(EnumSleepingSchedule.fromTimeToTicks(12, 30), EnumSleepingSchedule.fromTimeToTicks(4, 30));

    private int wakeUpTime;
    private int sleepTime;

    private EnumSleepingSchedule(int wakeUpTime, int sleepTime) {
        this.wakeUpTime = wakeUpTime;
        this.sleepTime = sleepTime;
    }

    public static int fromTimeToTicks(int hour, int minute) {
        int ticksPerMinute = 16;
        return (hour - 6) * 1000 + minute * ticksPerMinute;
    }

    public int getWakeUpTime() {
        return this.wakeUpTime;
    }

    public int getSleepTime() {
        return this.sleepTime;
    }

    public boolean sleepNextDay() {
        return this.wakeUpTime > this.sleepTime;
    }

    public int getBreakfastTime() {
        return 1000;
    }

    public int getLunchTime() {
        return (this.getDinnerTime() - this.getBreakfastTime()) / 2;
    }

    public int getDinnerTime() {
        return this.getAwakeTime() - 1000;
    }

    public boolean isWithinEatingTime(int dinosaurTime, Random rand) {
        return this.isWithinEatTime(dinosaurTime += rand.nextInt(320) - 160, this.getBreakfastTime()) || this.isWithinEatTime(dinosaurTime, this.getLunchTime()) || this.isWithinEatTime(dinosaurTime, this.getDinnerTime());
    }

    public int getAwakeTime() {
        int newSleepTime = this.sleepTime;
        if (this.sleepNextDay()) {
            newSleepTime += 24000;
        }
        return newSleepTime - this.wakeUpTime;
    }

    public boolean isWithinEatTime(int time, int eatTime) {
        return time > eatTime - 500 && time < eatTime + 500;
    }
}

