/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.entity.base;

import net.minecraft.block.Block;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import org.jurassicraft.common.entity.ai.flyer.EntityAIGlide;
import org.jurassicraft.common.entity.ai.flyer.EntityAILand;
import org.jurassicraft.common.entity.ai.flyer.EntityAITakeOff;
import org.jurassicraft.common.entity.base.EntityDinosaurAggressive;

public abstract class EntityDinosaurFlyingAggressive
extends EntityDinosaurAggressive {
    private static final int DW_FLYING = 30;
    private static final int DW_WING_FLAP = 31;
    private int wingFlap;
    private int prevWingFlap;

    public EntityDinosaurFlyingAggressive(World world) {
        super(world);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIGlide(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAILand(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAITakeOff(this));
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(30, (Object)0);
        this.field_70180_af.func_75682_a(31, (Object)0);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.isCarcass()) {
            boolean flying = this.isFlying();
            int wingFlap = this.getWingFlap();
            if (flying && !this.field_70170_p.field_72995_K) {
                float flapDiff;
                this.field_70125_A = 20.0f;
                float flapMotion = flapDiff = (float)(wingFlap - this.prevWingFlap);
                this.field_70701_bs = 0.15f;
                float speedMultiplier = 0.25f;
                double horizontalMotion = (double)flapMotion * Math.cos(this.field_70125_A * (float)Math.PI / 180.0f);
                double verticalMotion = (double)flapMotion * Math.sin(this.field_70125_A * (float)Math.PI / 180.0f);
                double x = (double)MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * horizontalMotion;
                double z = (double)MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * horizontalMotion;
                this.field_70159_w += -x * (double)speedMultiplier * (double)this.field_70701_bs;
                this.field_70179_y += z * (double)speedMultiplier * (double)this.field_70701_bs;
                this.field_70181_x = verticalMotion * (double)speedMultiplier * (double)this.field_70701_bs * 3.75;
                this.field_70181_x -= (double)0.025f;
                this.field_70159_w *= (double)1.06f;
                this.field_70179_y *= (double)1.06f;
                if (this.field_70159_w > (double)0.15f) {
                    this.field_70159_w = 0.15f;
                }
                if (this.field_70179_y > (double)0.15f) {
                    this.field_70179_y = 0.15f;
                }
                this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.prevWingFlap = wingFlap;
            }
        }
    }

    public boolean isFlying() {
        return this.field_70180_af.func_75683_a(30) == 1;
    }

    public void setFlying(boolean fly) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        this.field_70180_af.func_75692_b(30, (Object)((byte)(fly ? 1 : 0)));
    }

    public void setWingFlap(int wingFlap) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        this.field_70180_af.func_75692_b(31, (Object)wingFlap);
    }

    public int getWingFlap() {
        return this.field_70180_af.func_75679_c(31);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_180433_a(double y, boolean onGroundIn, Block blockIn, BlockPos pos) {
    }

    @Override
    public void func_70109_d(NBTTagCompound nbt) {
        super.func_70109_d(nbt);
        nbt.func_74757_a("Flying", this.isFlying());
    }

    @Override
    public void func_70020_e(NBTTagCompound nbt) {
        super.func_70020_e(nbt);
        this.setFlying(nbt.func_74767_n("Flying"));
    }
}

