/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.entity.ai.metabolism;

import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.timeless.animationapi.AnimationAPI;
import net.timeless.animationapi.client.AnimID;
import org.jurassicraft.common.entity.base.EntityDinosaur;
import org.jurassicraft.common.entity.base.MetabolismContainer;

public class EntityAIFindPlant
extends EntityAIBase {
    protected EntityDinosaur dinosaur;
    protected int x;
    protected int y;
    protected int z;

    public EntityAIFindPlant(EntityDinosaur dinosaur) {
        this.dinosaur = dinosaur;
    }

    public boolean func_75250_a() {
        MetabolismContainer metabolism = this.dinosaur.getMetabolism();
        if (!this.dinosaur.field_70128_L && !this.dinosaur.isCarcass() && this.dinosaur.field_70173_aa % 4 == 0 && this.dinosaur.field_70170_p.func_82736_K().func_82766_b("dinoMetabolism")) {
            double food = metabolism.getFood();
            boolean execute = false;
            int maxFood = metabolism.getMaxFood();
            if (food / (double)maxFood * 100.0 < 25.0) {
                execute = true;
            } else if (food < (double)(maxFood - maxFood / 8) && this.dinosaur.getDinosaur().getSleepingSchedule().isWithinEatingTime(this.dinosaur.getDinosaurTime(), this.dinosaur.func_70681_au())) {
                execute = true;
            }
            if (execute) {
                int posX = (int)this.dinosaur.field_70165_t;
                int posY = (int)this.dinosaur.field_70163_u;
                int posZ = (int)this.dinosaur.field_70161_v;
                int closestDist = Integer.MAX_VALUE;
                int closestX = 0;
                int closestY = 0;
                int closestZ = 0;
                boolean found = false;
                World world = this.dinosaur.field_70170_p;
                for (int x = posX - 16; x < posX + 16; ++x) {
                    for (int y = posY - 16; y < posY + 16; ++y) {
                        for (int z = posZ - 16; z < posZ + 16; ++z) {
                            int diffZ;
                            int diffY;
                            int diffX;
                            int dist;
                            Block block = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
                            if (!(block instanceof BlockBush) || (dist = (diffX = posX - x) * diffX + (diffY = posY - y) * diffY + (diffZ = posZ - z) * diffZ) >= closestDist) continue;
                            closestDist = dist;
                            closestX = x;
                            closestY = y;
                            closestZ = z;
                            found = true;
                        }
                    }
                }
                if (found) {
                    this.x = closestX;
                    this.y = closestY;
                    this.z = closestZ;
                    this.dinosaur.func_70661_as().func_75492_a((double)this.x, (double)this.y, (double)this.z, 1.0);
                    return true;
                }
            }
        }
        return false;
    }

    public void func_75246_d() {
        if (this.dinosaur.func_70092_e(this.x, this.y, this.z) / 16.0 <= (double)this.dinosaur.field_70130_N) {
            AnimationAPI.sendAnimPacket(this.dinosaur, AnimID.EATING);
            if (this.dinosaur.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                this.dinosaur.field_70170_p.func_175655_b(new BlockPos(this.x, this.y, this.z), false);
            }
            this.dinosaur.getMetabolism().increaseFood(2000);
            this.dinosaur.func_70691_i(4.0f);
        }
    }

    public boolean func_75253_b() {
        return this.dinosaur != null && !this.dinosaur.func_70661_as().func_75500_f() && this.dinosaur.field_70170_p.func_180495_p(new BlockPos(this.x, this.y, this.z)).func_177230_c() instanceof BlockBush;
    }
}

