/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.entity;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.timeless.animationapi.client.AnimID;
import org.jurassicraft.common.entity.ai.animations.JCNonAutoAnimSoundBase;
import org.jurassicraft.common.entity.base.EntityDinosaurAggressive;

public class EntityIndominus
extends EntityDinosaurAggressive {
    private static final String[] hurtSounds = new String[]{"indominus_hurt_1"};
    private static final String[] livingSounds = new String[]{"indominus_living_1"};
    private static final String[] deathSounds = new String[]{"indominus_death_1"};
    private static final String[] breathSounds = new String[]{"indominus_breath"};
    private float[] newSkinColor = new float[3];
    private float[] skinColor = new float[3];
    private int stepCount = 0;
    private boolean isCamouflaging;

    public EntityIndominus(World world) {
        super(world);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new JCNonAutoAnimSoundBase(this, 75, AnimID.IDLE, 750, breathSounds[0], 1.5f));
        this.addAIForAttackTargets(EntityLivingBase.class, 0);
        this.defendFromAttacker(EntityLivingBase.class, 0);
    }

    @Override
    public int getTailBoxCount() {
        return 7;
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(31, (Object)0);
    }

    @Override
    public void applySettingsForActionFigure() {
        super.applySettingsForActionFigure();
        this.isCamouflaging = false;
        this.skinColor = new float[]{255.0f, 255.0f, 255.0f};
        this.newSkinColor = new float[]{255.0f, 255.0f, 255.0f};
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa % 62 == 0) {
            this.func_85030_a(this.randomSound(breathSounds), this.func_70599_aP(), this.func_70647_i());
        }
        if (this.field_70701_bs > 0.0f && this.stepCount <= 0) {
            this.func_85030_a("jurassicraft:stomp", (float)this.transitionFromAge(0.1f, 1.0), this.func_70647_i());
            this.stepCount = 65;
        }
        this.stepCount = (int)((double)this.stepCount - (double)this.field_70701_bs * 9.5);
        if (this.field_70170_p.field_72995_K) {
            this.isCamouflaging = this.field_70180_af.func_75683_a(31) == 1;
            this.changeSkinColor();
        } else {
            this.field_70180_af.func_75692_b(31, (Object)((byte)(this.isCamouflaging ? 1 : 0)));
        }
    }

    @Override
    public float func_70599_aP() {
        return (float)this.transitionFromAge(0.9f, 1.6f) + (this.field_70146_Z.nextFloat() - 0.5f) * 0.125f;
    }

    public String func_70639_aQ() {
        return this.randomSound(livingSounds);
    }

    public String func_70621_aR() {
        return this.randomSound(hurtSounds);
    }

    public String func_70673_aS() {
        return this.randomSound(deathSounds);
    }

    public boolean isCamouflaging() {
        return this.isCamouflaging;
    }

    public void changeSkinColor() {
        int color;
        BlockPos pos = new BlockPos((Entity)this).func_177972_a(EnumFacing.DOWN);
        IBlockState state = this.field_70170_p.func_180495_p(pos);
        if (this.isCamouflaging()) {
            color = state.func_177230_c().func_176202_d((IBlockAccess)this.field_70170_p, pos);
            if (color == 0xFFFFFF) {
                color = state.func_177230_c().func_180659_g((IBlockState)state).field_76291_p;
            }
        } else {
            color = 0xFFFFFF;
        }
        if (color != 0) {
            this.newSkinColor[0] = color >> 16 & 0xFF;
            this.newSkinColor[1] = color >> 8 & 0xFF;
            this.newSkinColor[2] = color & 0xFF;
            if (this.skinColor[0] == 0.0f && this.skinColor[1] == 0.0f && this.skinColor[2] == 0.0f) {
                this.skinColor[0] = this.newSkinColor[0];
                this.skinColor[1] = this.newSkinColor[1];
                this.skinColor[2] = this.newSkinColor[2];
            }
        }
        for (int i = 0; i < 3; ++i) {
            if (this.skinColor[i] < this.newSkinColor[i]) {
                int n = i;
                this.skinColor[n] = this.skinColor[n] + 1.0f;
            }
            if (!(this.skinColor[i] > this.newSkinColor[i])) continue;
            int n = i;
            this.skinColor[n] = this.skinColor[n] - 1.0f;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float[] getSkinColor() {
        return new float[]{this.skinColor[0] / 255.0f, this.skinColor[1] / 255.0f, this.skinColor[2] / 255.0f};
    }
}

