/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.configuration;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jurassicraft.JurassiCraft;

public class JCConfigurations {
    private static boolean isInit = false;
    private static Property spawnJurassiCraftMobsNaturally;
    private static Property spawnVanillaMobsNaturally;
    private static Property spawnOtherMobsModsNaturally;

    private static final void checkInit() {
        if (!isInit) {
            throw new IllegalStateException("Configuration not yet initialized.");
        }
    }

    public static boolean spawnJurassiCraftMobsNaturally() {
        JCConfigurations.checkInit();
        return spawnJurassiCraftMobsNaturally.getBoolean(false);
    }

    public static boolean spawnVanillaMobsNaturally() {
        JCConfigurations.checkInit();
        return spawnVanillaMobsNaturally.getBoolean(true);
    }

    public static boolean spawnOtherMobsModsNaturally() {
        JCConfigurations.checkInit();
        return spawnVanillaMobsNaturally.getBoolean(true);
    }

    public static List<IConfigElement> getAllConfigurableOptions() {
        ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
        list.add((IConfigElement)new ConfigElement(spawnJurassiCraftMobsNaturally));
        list.add((IConfigElement)new ConfigElement(spawnVanillaMobsNaturally));
        list.add((IConfigElement)new ConfigElement(spawnOtherMobsModsNaturally));
        return list;
    }

    public void initConfig(FMLPreInitializationEvent event) {
        JurassiCraft.configFile = event.getSuggestedConfigurationFile();
        JurassiCraft.instance.getLogger().debug("JurassiCraft config path = " + JurassiCraft.configFile.getAbsolutePath());
        JurassiCraft.instance.getLogger().debug("Config file exists = " + JurassiCraft.configFile.canRead());
        JurassiCraft.config = new Configuration(JurassiCraft.configFile);
        JurassiCraft.config.load();
        this.syncConfig();
        isInit = true;
    }

    public void syncConfig() {
        spawnJurassiCraftMobsNaturally = JurassiCraft.config.get("general", "JurassiCraft Mobs Spawn Naturally", false, "Allow JurassiCraft entities to spawn naturally during world generation");
        spawnJurassiCraftMobsNaturally.getBoolean(false);
        spawnJurassiCraftMobsNaturally.setRequiresMcRestart(true);
        spawnVanillaMobsNaturally = JurassiCraft.config.get("general", "Vanilla Mobs Spawn Naturally", true, "Allow vanilla mobs to spawn naturally during world generation");
        spawnVanillaMobsNaturally.getBoolean(true);
        spawnVanillaMobsNaturally.setRequiresMcRestart(true);
        spawnOtherMobsModsNaturally = JurassiCraft.config.get("general", "Other Mods' Mobs Spawn Naturally", true, "Allow mobs from other mods to spawn naturally during world generation");
        spawnOtherMobsModsNaturally.getBoolean(true);
        spawnOtherMobsModsNaturally.setRequiresMcRestart(true);
        if (JurassiCraft.config.hasChanged()) {
            JurassiCraft.config.save();
        }
    }

    @SubscribeEvent
    public void onConfigChange(ConfigChangedEvent.OnConfigChangedEvent occe) {
        if (!occe.modID.equals("jurassicraft")) {
            return;
        }
        this.syncConfig();
    }
}

