/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.block.tree;

import com.google.common.base.Predicate;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.common.creativetab.JCCreativeTabs;

public class BlockJCStairs
extends Block {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyEnum HALF = PropertyEnum.func_177709_a((String)"half", EnumHalf.class);
    public static final PropertyEnum SHAPE = PropertyEnum.func_177709_a((String)"shape", EnumShape.class);
    private static final int[][] field_150150_a = new int[][]{{4, 5}, {5, 7}, {6, 7}, {4, 6}, {0, 1}, {1, 3}, {2, 3}, {0, 2}};
    private final Block modelBlock;
    private final IBlockState modelState;
    private boolean hasRaytraced;
    private int rayTracePass;

    public BlockJCStairs(String name, IBlockState modelState) {
        super(modelState.func_177230_c().func_149688_o());
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)HALF, (Comparable)((Object)EnumHalf.BOTTOM)).func_177226_a((IProperty)SHAPE, (Comparable)((Object)EnumShape.STRAIGHT)));
        this.modelBlock = modelState.func_177230_c();
        this.modelState = modelState;
        this.func_149711_c(this.modelBlock.func_176195_g(null, null));
        this.func_149752_b(this.modelBlock.func_149638_a(null) * 5.0f / 3.0f);
        this.func_149672_a(this.modelBlock.field_149762_H);
        this.setHarvestLevel(this.modelBlock.getHarvestTool(this.modelState), this.modelBlock.getHarvestLevel(this.modelState));
        this.func_149713_g(255);
        this.func_149647_a(JCCreativeTabs.plants);
        this.func_149663_c(name.toLowerCase().replaceAll(" ", "_") + "_stairs");
    }

    public void func_180654_a(IBlockAccess worldIn, BlockPos pos) {
        if (this.hasRaytraced) {
            this.func_149676_a(0.5f * (float)(this.rayTracePass % 2), 0.5f * (float)(this.rayTracePass / 4 % 2), 0.5f * (float)(this.rayTracePass / 2 % 2), 0.5f + 0.5f * (float)(this.rayTracePass % 2), 0.5f + 0.5f * (float)(this.rayTracePass / 4 % 2), 0.5f + 0.5f * (float)(this.rayTracePass / 2 % 2));
        } else {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public void setBaseCollisionBounds(IBlockAccess worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos).func_177229_b((IProperty)HALF) == EnumHalf.TOP) {
            this.func_149676_a(0.0f, 0.5f, 0.0f, 1.0f, 1.0f, 1.0f);
        } else {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
        }
    }

    public static boolean isStairs(Block block) {
        return block instanceof BlockJCStairs;
    }

    public static boolean isSameStair(IBlockAccess worldIn, BlockPos pos, IBlockState state) {
        IBlockState iblockstate1 = worldIn.func_180495_p(pos);
        Block block = iblockstate1.func_177230_c();
        return BlockJCStairs.isStairs(block) && iblockstate1.func_177229_b((IProperty)HALF) == state.func_177229_b((IProperty)HALF) && iblockstate1.func_177229_b((IProperty)FACING) == state.func_177229_b((IProperty)FACING);
    }

    public int func_176307_f(IBlockAccess world, BlockPos pos) {
        IBlockState iblockstate1;
        Block block;
        boolean isTop;
        IBlockState iblockstate = world.func_180495_p(pos);
        EnumFacing facing = (EnumFacing)iblockstate.func_177229_b((IProperty)FACING);
        EnumHalf enumhalf = (EnumHalf)((Object)iblockstate.func_177229_b((IProperty)HALF));
        boolean bl = isTop = enumhalf == EnumHalf.TOP;
        if (facing == EnumFacing.EAST) {
            IBlockState iblockstate12 = world.func_180495_p(pos.func_177974_f());
            Block block2 = iblockstate12.func_177230_c();
            if (BlockJCStairs.isStairs(block2) && enumhalf == iblockstate12.func_177229_b((IProperty)HALF)) {
                EnumFacing enumfacing1 = (EnumFacing)iblockstate12.func_177229_b((IProperty)FACING);
                if (enumfacing1 == EnumFacing.NORTH && !BlockJCStairs.isSameStair(world, pos.func_177968_d(), iblockstate)) {
                    return isTop ? 1 : 2;
                }
                if (enumfacing1 == EnumFacing.SOUTH && !BlockJCStairs.isSameStair(world, pos.func_177978_c(), iblockstate)) {
                    return isTop ? 2 : 1;
                }
            }
        } else if (facing == EnumFacing.WEST) {
            IBlockState iblockstate13 = world.func_180495_p(pos.func_177976_e());
            Block block3 = iblockstate13.func_177230_c();
            if (BlockJCStairs.isStairs(block3) && enumhalf == iblockstate13.func_177229_b((IProperty)HALF)) {
                EnumFacing enumfacing1 = (EnumFacing)iblockstate13.func_177229_b((IProperty)FACING);
                if (enumfacing1 == EnumFacing.NORTH && !BlockJCStairs.isSameStair(world, pos.func_177968_d(), iblockstate)) {
                    return isTop ? 2 : 1;
                }
                if (enumfacing1 == EnumFacing.SOUTH && !BlockJCStairs.isSameStair(world, pos.func_177978_c(), iblockstate)) {
                    return isTop ? 1 : 2;
                }
            }
        } else if (facing == EnumFacing.SOUTH) {
            IBlockState iblockstate14 = world.func_180495_p(pos.func_177968_d());
            Block block4 = iblockstate14.func_177230_c();
            if (BlockJCStairs.isStairs(block4) && enumhalf == iblockstate14.func_177229_b((IProperty)HALF)) {
                EnumFacing enumfacing1 = (EnumFacing)iblockstate14.func_177229_b((IProperty)FACING);
                if (enumfacing1 == EnumFacing.WEST && !BlockJCStairs.isSameStair(world, pos.func_177974_f(), iblockstate)) {
                    return isTop ? 2 : 1;
                }
                if (enumfacing1 == EnumFacing.EAST && !BlockJCStairs.isSameStair(world, pos.func_177976_e(), iblockstate)) {
                    return isTop ? 1 : 2;
                }
            }
        } else if (facing == EnumFacing.NORTH && BlockJCStairs.isStairs(block = (iblockstate1 = world.func_180495_p(pos.func_177978_c())).func_177230_c()) && enumhalf == iblockstate1.func_177229_b((IProperty)HALF)) {
            EnumFacing enumfacing1 = (EnumFacing)iblockstate1.func_177229_b((IProperty)FACING);
            if (enumfacing1 == EnumFacing.WEST && !BlockJCStairs.isSameStair(world, pos.func_177974_f(), iblockstate)) {
                return isTop ? 1 : 2;
            }
            if (enumfacing1 == EnumFacing.EAST && !BlockJCStairs.isSameStair(world, pos.func_177976_e(), iblockstate)) {
                return isTop ? 2 : 1;
            }
        }
        return 0;
    }

    public int func_176305_g(IBlockAccess world, BlockPos pos) {
        IBlockState iblockstate1;
        Block block;
        boolean flag;
        IBlockState iblockstate = world.func_180495_p(pos);
        EnumFacing enumfacing = (EnumFacing)iblockstate.func_177229_b((IProperty)FACING);
        EnumHalf enumhalf = (EnumHalf)((Object)iblockstate.func_177229_b((IProperty)HALF));
        boolean bl = flag = enumhalf == EnumHalf.TOP;
        if (enumfacing == EnumFacing.EAST) {
            IBlockState iblockstate12 = world.func_180495_p(pos.func_177976_e());
            Block block2 = iblockstate12.func_177230_c();
            if (BlockJCStairs.isStairs(block2) && enumhalf == iblockstate12.func_177229_b((IProperty)HALF)) {
                EnumFacing enumfacing1 = (EnumFacing)iblockstate12.func_177229_b((IProperty)FACING);
                if (enumfacing1 == EnumFacing.NORTH && !BlockJCStairs.isSameStair(world, pos.func_177978_c(), iblockstate)) {
                    return flag ? 1 : 2;
                }
                if (enumfacing1 == EnumFacing.SOUTH && !BlockJCStairs.isSameStair(world, pos.func_177968_d(), iblockstate)) {
                    return flag ? 2 : 1;
                }
            }
        } else if (enumfacing == EnumFacing.WEST) {
            IBlockState iblockstate13 = world.func_180495_p(pos.func_177974_f());
            Block block3 = iblockstate13.func_177230_c();
            if (BlockJCStairs.isStairs(block3) && enumhalf == iblockstate13.func_177229_b((IProperty)HALF)) {
                EnumFacing enumfacing1 = (EnumFacing)iblockstate13.func_177229_b((IProperty)FACING);
                if (enumfacing1 == EnumFacing.NORTH && !BlockJCStairs.isSameStair(world, pos.func_177978_c(), iblockstate)) {
                    return flag ? 2 : 1;
                }
                if (enumfacing1 == EnumFacing.SOUTH && !BlockJCStairs.isSameStair(world, pos.func_177968_d(), iblockstate)) {
                    return flag ? 1 : 2;
                }
            }
        } else if (enumfacing == EnumFacing.SOUTH) {
            IBlockState iblockstate14 = world.func_180495_p(pos.func_177978_c());
            Block block4 = iblockstate14.func_177230_c();
            if (BlockJCStairs.isStairs(block4) && enumhalf == iblockstate14.func_177229_b((IProperty)HALF)) {
                EnumFacing enumfacing1 = (EnumFacing)iblockstate14.func_177229_b((IProperty)FACING);
                if (enumfacing1 == EnumFacing.WEST && !BlockJCStairs.isSameStair(world, pos.func_177976_e(), iblockstate)) {
                    return flag ? 2 : 1;
                }
                if (enumfacing1 == EnumFacing.EAST && !BlockJCStairs.isSameStair(world, pos.func_177974_f(), iblockstate)) {
                    return flag ? 1 : 2;
                }
            }
        } else if (enumfacing == EnumFacing.NORTH && BlockJCStairs.isStairs(block = (iblockstate1 = world.func_180495_p(pos.func_177968_d())).func_177230_c()) && enumhalf == iblockstate1.func_177229_b((IProperty)HALF)) {
            EnumFacing enumfacing1 = (EnumFacing)iblockstate1.func_177229_b((IProperty)FACING);
            if (enumfacing1 == EnumFacing.WEST && !BlockJCStairs.isSameStair(world, pos.func_177976_e(), iblockstate)) {
                return flag ? 1 : 2;
            }
            if (enumfacing1 == EnumFacing.EAST && !BlockJCStairs.isSameStair(world, pos.func_177974_f(), iblockstate)) {
                return flag ? 2 : 1;
            }
        }
        return 0;
    }

    public boolean func_176306_h(IBlockAccess world, BlockPos pos) {
        IBlockState iblockstate1;
        Block block;
        IBlockState iblockstate = world.func_180495_p(pos);
        EnumFacing enumfacing = (EnumFacing)iblockstate.func_177229_b((IProperty)FACING);
        EnumHalf enumhalf = (EnumHalf)((Object)iblockstate.func_177229_b((IProperty)HALF));
        boolean flag = enumhalf == EnumHalf.TOP;
        float f = 0.5f;
        float f1 = 1.0f;
        if (flag) {
            f = 0.0f;
            f1 = 0.5f;
        }
        float f2 = 0.0f;
        float f3 = 1.0f;
        float f4 = 0.0f;
        float f5 = 0.5f;
        boolean flag1 = true;
        if (enumfacing == EnumFacing.EAST) {
            f2 = 0.5f;
            f5 = 1.0f;
            IBlockState iblockstate12 = world.func_180495_p(pos.func_177974_f());
            Block block2 = iblockstate12.func_177230_c();
            if (BlockJCStairs.isStairs(block2) && enumhalf == iblockstate12.func_177229_b((IProperty)HALF)) {
                EnumFacing enumfacing1 = (EnumFacing)iblockstate12.func_177229_b((IProperty)FACING);
                if (enumfacing1 == EnumFacing.NORTH && !BlockJCStairs.isSameStair(world, pos.func_177968_d(), iblockstate)) {
                    f5 = 0.5f;
                    flag1 = false;
                } else if (enumfacing1 == EnumFacing.SOUTH && !BlockJCStairs.isSameStair(world, pos.func_177978_c(), iblockstate)) {
                    f4 = 0.5f;
                    flag1 = false;
                }
            }
        } else if (enumfacing == EnumFacing.WEST) {
            f3 = 0.5f;
            f5 = 1.0f;
            IBlockState iblockstate13 = world.func_180495_p(pos.func_177976_e());
            Block block3 = iblockstate13.func_177230_c();
            if (BlockJCStairs.isStairs(block3) && enumhalf == iblockstate13.func_177229_b((IProperty)HALF)) {
                EnumFacing enumfacing1 = (EnumFacing)iblockstate13.func_177229_b((IProperty)FACING);
                if (enumfacing1 == EnumFacing.NORTH && !BlockJCStairs.isSameStair(world, pos.func_177968_d(), iblockstate)) {
                    f5 = 0.5f;
                    flag1 = false;
                } else if (enumfacing1 == EnumFacing.SOUTH && !BlockJCStairs.isSameStair(world, pos.func_177978_c(), iblockstate)) {
                    f4 = 0.5f;
                    flag1 = false;
                }
            }
        } else if (enumfacing == EnumFacing.SOUTH) {
            f4 = 0.5f;
            f5 = 1.0f;
            IBlockState iblockstate14 = world.func_180495_p(pos.func_177968_d());
            Block block4 = iblockstate14.func_177230_c();
            if (BlockJCStairs.isStairs(block4) && enumhalf == iblockstate14.func_177229_b((IProperty)HALF)) {
                EnumFacing enumfacing1 = (EnumFacing)iblockstate14.func_177229_b((IProperty)FACING);
                if (enumfacing1 == EnumFacing.WEST && !BlockJCStairs.isSameStair(world, pos.func_177974_f(), iblockstate)) {
                    f3 = 0.5f;
                    flag1 = false;
                } else if (enumfacing1 == EnumFacing.EAST && !BlockJCStairs.isSameStair(world, pos.func_177976_e(), iblockstate)) {
                    f2 = 0.5f;
                    flag1 = false;
                }
            }
        } else if (enumfacing == EnumFacing.NORTH && BlockJCStairs.isStairs(block = (iblockstate1 = world.func_180495_p(pos.func_177978_c())).func_177230_c()) && enumhalf == iblockstate1.func_177229_b((IProperty)HALF)) {
            EnumFacing enumfacing1 = (EnumFacing)iblockstate1.func_177229_b((IProperty)FACING);
            if (enumfacing1 == EnumFacing.WEST && !BlockJCStairs.isSameStair(world, pos.func_177974_f(), iblockstate)) {
                f3 = 0.5f;
                flag1 = false;
            } else if (enumfacing1 == EnumFacing.EAST && !BlockJCStairs.isSameStair(world, pos.func_177976_e(), iblockstate)) {
                f2 = 0.5f;
                flag1 = false;
            }
        }
        this.func_149676_a(f2, f, f4, f3, f1, f5);
        return flag1;
    }

    public boolean func_176304_i(IBlockAccess world, BlockPos pos) {
        IBlockState iblockstate1;
        Block block;
        IBlockState iblockstate = world.func_180495_p(pos);
        EnumFacing enumfacing = (EnumFacing)iblockstate.func_177229_b((IProperty)FACING);
        EnumHalf enumhalf = (EnumHalf)((Object)iblockstate.func_177229_b((IProperty)HALF));
        boolean flag = enumhalf == EnumHalf.TOP;
        float f = 0.5f;
        float f1 = 1.0f;
        if (flag) {
            f = 0.0f;
            f1 = 0.5f;
        }
        float f2 = 0.0f;
        float f3 = 0.5f;
        float f4 = 0.5f;
        float f5 = 1.0f;
        boolean flag1 = false;
        if (enumfacing == EnumFacing.EAST) {
            IBlockState iblockstate12 = world.func_180495_p(pos.func_177976_e());
            Block block2 = iblockstate12.func_177230_c();
            if (BlockJCStairs.isStairs(block2) && enumhalf == iblockstate12.func_177229_b((IProperty)HALF)) {
                EnumFacing enumfacing1 = (EnumFacing)iblockstate12.func_177229_b((IProperty)FACING);
                if (enumfacing1 == EnumFacing.NORTH && !BlockJCStairs.isSameStair(world, pos.func_177978_c(), iblockstate)) {
                    f4 = 0.0f;
                    f5 = 0.5f;
                    flag1 = true;
                } else if (enumfacing1 == EnumFacing.SOUTH && !BlockJCStairs.isSameStair(world, pos.func_177968_d(), iblockstate)) {
                    f4 = 0.5f;
                    f5 = 1.0f;
                    flag1 = true;
                }
            }
        } else if (enumfacing == EnumFacing.WEST) {
            IBlockState iblockstate13 = world.func_180495_p(pos.func_177974_f());
            Block block3 = iblockstate13.func_177230_c();
            if (BlockJCStairs.isStairs(block3) && enumhalf == iblockstate13.func_177229_b((IProperty)HALF)) {
                f2 = 0.5f;
                f3 = 1.0f;
                EnumFacing enumfacing1 = (EnumFacing)iblockstate13.func_177229_b((IProperty)FACING);
                if (enumfacing1 == EnumFacing.NORTH && !BlockJCStairs.isSameStair(world, pos.func_177978_c(), iblockstate)) {
                    f4 = 0.0f;
                    f5 = 0.5f;
                    flag1 = true;
                } else if (enumfacing1 == EnumFacing.SOUTH && !BlockJCStairs.isSameStair(world, pos.func_177968_d(), iblockstate)) {
                    f4 = 0.5f;
                    f5 = 1.0f;
                    flag1 = true;
                }
            }
        } else if (enumfacing == EnumFacing.SOUTH) {
            IBlockState iblockstate14 = world.func_180495_p(pos.func_177978_c());
            Block block4 = iblockstate14.func_177230_c();
            if (BlockJCStairs.isStairs(block4) && enumhalf == iblockstate14.func_177229_b((IProperty)HALF)) {
                f4 = 0.0f;
                f5 = 0.5f;
                EnumFacing enumfacing1 = (EnumFacing)iblockstate14.func_177229_b((IProperty)FACING);
                if (enumfacing1 == EnumFacing.WEST && !BlockJCStairs.isSameStair(world, pos.func_177976_e(), iblockstate)) {
                    flag1 = true;
                } else if (enumfacing1 == EnumFacing.EAST && !BlockJCStairs.isSameStair(world, pos.func_177974_f(), iblockstate)) {
                    f2 = 0.5f;
                    f3 = 1.0f;
                    flag1 = true;
                }
            }
        } else if (enumfacing == EnumFacing.NORTH && BlockJCStairs.isStairs(block = (iblockstate1 = world.func_180495_p(pos.func_177968_d())).func_177230_c()) && enumhalf == iblockstate1.func_177229_b((IProperty)HALF)) {
            EnumFacing enumfacing1 = (EnumFacing)iblockstate1.func_177229_b((IProperty)FACING);
            if (enumfacing1 == EnumFacing.WEST && !BlockJCStairs.isSameStair(world, pos.func_177976_e(), iblockstate)) {
                flag1 = true;
            } else if (enumfacing1 == EnumFacing.EAST && !BlockJCStairs.isSameStair(world, pos.func_177974_f(), iblockstate)) {
                f2 = 0.5f;
                f3 = 1.0f;
                flag1 = true;
            }
        }
        if (flag1) {
            this.func_149676_a(f2, f, f4, f3, f1, f5);
        }
        return flag1;
    }

    public void func_180638_a(World worldIn, BlockPos pos, IBlockState state, AxisAlignedBB mask, List list, Entity collidingEntity) {
        this.setBaseCollisionBounds((IBlockAccess)worldIn, pos);
        super.func_180638_a(worldIn, pos, state, mask, list, collidingEntity);
        boolean flag = this.func_176306_h((IBlockAccess)worldIn, pos);
        super.func_180638_a(worldIn, pos, state, mask, list, collidingEntity);
        if (flag && this.func_176304_i((IBlockAccess)worldIn, pos)) {
            super.func_180638_a(worldIn, pos, state, mask, list, collidingEntity);
        }
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        this.modelBlock.func_180649_a(worldIn, pos, playerIn);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        this.modelBlock.func_180655_c(worldIn, pos, state, rand);
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        this.modelBlock.func_176206_d(worldIn, pos, state);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_176207_c(IBlockAccess worldIn, BlockPos pos) {
        return this.modelBlock.func_176207_c(worldIn, pos);
    }

    public float func_149638_a(Entity exploder) {
        return this.modelBlock.func_149638_a(exploder);
    }

    public int func_149738_a(World worldIn) {
        return this.modelBlock.func_149738_a(worldIn);
    }

    public Vec3 func_176197_a(World worldIn, BlockPos pos, Entity entityIn, Vec3 motion) {
        return this.modelBlock.func_176197_a(worldIn, pos, entityIn, motion);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumWorldBlockLayer func_180664_k() {
        return this.modelBlock.func_180664_k();
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180646_a(World worldIn, BlockPos pos) {
        return this.modelBlock.func_180646_a(worldIn, pos);
    }

    public boolean func_149703_v() {
        return this.modelBlock.func_149703_v();
    }

    public boolean func_176209_a(IBlockState state, boolean hitIfLiquid) {
        return this.modelBlock.func_176209_a(state, hitIfLiquid);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return this.modelBlock.func_176196_c(worldIn, pos);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.func_176204_a(worldIn, pos, this.modelState, Blocks.field_150350_a);
        this.modelBlock.func_176213_c(worldIn, pos, this.modelState);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        this.modelBlock.func_180663_b(worldIn, pos, this.modelState);
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        this.modelBlock.func_176199_a(worldIn, pos, entityIn);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        this.modelBlock.func_180650_b(worldIn, pos, state, rand);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumFacing side, float hitX, float hitY, float hitZ) {
        return this.modelBlock.func_180639_a(worldIn, pos, this.modelState, playerIn, EnumFacing.DOWN, 0.0f, 0.0f, 0.0f);
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        this.modelBlock.func_180652_a(worldIn, pos, explosionIn);
    }

    public MapColor func_180659_g(IBlockState state) {
        return this.modelBlock.func_180659_g(this.modelState);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState iblockstate = super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer);
        iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO()).func_177226_a((IProperty)SHAPE, (Comparable)((Object)EnumShape.STRAIGHT));
        return facing != EnumFacing.DOWN && (facing == EnumFacing.UP || (double)hitY <= 0.5) ? iblockstate.func_177226_a((IProperty)HALF, (Comparable)((Object)EnumHalf.BOTTOM)) : iblockstate.func_177226_a((IProperty)HALF, (Comparable)((Object)EnumHalf.TOP));
    }

    public MovingObjectPosition func_180636_a(World worldIn, BlockPos pos, Vec3 start, Vec3 end) {
        MovingObjectPosition[] amovingobjectposition = new MovingObjectPosition[8];
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        int i = ((EnumFacing)iblockstate.func_177229_b((IProperty)FACING)).func_176736_b();
        boolean flag = iblockstate.func_177229_b((IProperty)HALF) == EnumHalf.TOP;
        int[] aint = field_150150_a[i + (flag ? 4 : 0)];
        this.hasRaytraced = true;
        for (int j = 0; j < 8; ++j) {
            this.rayTracePass = j;
            if (Arrays.binarySearch(aint, j) >= 0) continue;
            amovingobjectposition[j] = super.func_180636_a(worldIn, pos, start, end);
        }
        int[] aint1 = aint;
        int k = aint.length;
        for (int l = 0; l < k; ++l) {
            int i1 = aint1[l];
            amovingobjectposition[i1] = null;
        }
        MovingObjectPosition movingobjectposition1 = null;
        double d1 = 0.0;
        MovingObjectPosition[] amovingobjectposition1 = amovingobjectposition;
        int j1 = amovingobjectposition.length;
        for (int k1 = 0; k1 < j1; ++k1) {
            double d0;
            MovingObjectPosition movingobjectposition = amovingobjectposition1[k1];
            if (movingobjectposition == null || !((d0 = movingobjectposition.field_72307_f.func_72436_e(end)) > d1)) continue;
            movingobjectposition1 = movingobjectposition;
            d1 = d0;
        }
        return movingobjectposition1;
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState iblockstate = this.func_176223_P().func_177226_a((IProperty)HALF, (Comparable)((Object)((meta & 4) > 0 ? EnumHalf.TOP : EnumHalf.BOTTOM)));
        iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)(5 - (meta & 3))));
        return iblockstate;
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        if (state.func_177229_b((IProperty)HALF) == EnumHalf.TOP) {
            i |= 4;
        }
        return i |= 5 - ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (this.func_176306_h(worldIn, pos)) {
            switch (this.func_176305_g(worldIn, pos)) {
                case 0: {
                    state = state.func_177226_a((IProperty)SHAPE, (Comparable)((Object)EnumShape.STRAIGHT));
                    break;
                }
                case 1: {
                    state = state.func_177226_a((IProperty)SHAPE, (Comparable)((Object)EnumShape.INNER_RIGHT));
                    break;
                }
                case 2: {
                    state = state.func_177226_a((IProperty)SHAPE, (Comparable)((Object)EnumShape.INNER_LEFT));
                }
            }
        } else {
            switch (this.func_176307_f(worldIn, pos)) {
                case 0: {
                    state = state.func_177226_a((IProperty)SHAPE, (Comparable)((Object)EnumShape.STRAIGHT));
                    break;
                }
                case 1: {
                    state = state.func_177226_a((IProperty)SHAPE, (Comparable)((Object)EnumShape.OUTER_RIGHT));
                    break;
                }
                case 2: {
                    state = state.func_177226_a((IProperty)SHAPE, (Comparable)((Object)EnumShape.OUTER_LEFT));
                }
            }
        }
        return state;
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{FACING, HALF, SHAPE});
    }

    public static enum EnumShape implements IStringSerializable
    {
        STRAIGHT("straight"),
        INNER_LEFT("inner_left"),
        INNER_RIGHT("inner_right"),
        OUTER_LEFT("outer_left"),
        OUTER_RIGHT("outer_right");

        private final String name;

        private EnumShape(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }

    public static enum EnumHalf implements IStringSerializable
    {
        TOP("top"),
        BOTTOM("bottom");

        private final String name;

        private EnumHalf(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

