/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.block;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import org.jurassicraft.common.api.ISubBlocksBlock;
import org.jurassicraft.common.block.BlockActionFigure;
import org.jurassicraft.common.block.BlockAmber;
import org.jurassicraft.common.block.BlockBasic;
import org.jurassicraft.common.block.BlockEncasedFossil;
import org.jurassicraft.common.block.BlockFossil;
import org.jurassicraft.common.block.BlockGypsumStone;
import org.jurassicraft.common.block.BlockIceShard;
import org.jurassicraft.common.block.BlockMeta;
import org.jurassicraft.common.block.machine.BlockCarnivoreFeeder;
import org.jurassicraft.common.block.machine.BlockCleaningStation;
import org.jurassicraft.common.block.machine.BlockCultivateBottom;
import org.jurassicraft.common.block.machine.BlockCultivateTop;
import org.jurassicraft.common.block.machine.BlockDNACombinator;
import org.jurassicraft.common.block.machine.BlockDNAExtractor;
import org.jurassicraft.common.block.machine.BlockDNAHybridizer;
import org.jurassicraft.common.block.machine.BlockDnaSequencer;
import org.jurassicraft.common.block.machine.BlockDnaSynthesizer;
import org.jurassicraft.common.block.machine.BlockEmbryoCalcificationMachine;
import org.jurassicraft.common.block.machine.BlockEmbryonicMachine;
import org.jurassicraft.common.block.machine.BlockFossilGrinder;
import org.jurassicraft.common.block.machine.BlockIncubator;
import org.jurassicraft.common.block.machine.BlockSecurityCamera;
import org.jurassicraft.common.block.plant.BlockBennettitaleanCycadeoidea;
import org.jurassicraft.common.block.plant.BlockCryPansy;
import org.jurassicraft.common.block.plant.BlockCycadZamites;
import org.jurassicraft.common.block.plant.BlockDicksonia;
import org.jurassicraft.common.block.plant.BlockScalyTreeFern;
import org.jurassicraft.common.block.plant.BlockSmallChainFern;
import org.jurassicraft.common.block.plant.BlockSmallCycad;
import org.jurassicraft.common.block.plant.BlockSmallRoyalFern;
import org.jurassicraft.common.block.tree.BlockJCLeaves;
import org.jurassicraft.common.block.tree.BlockJCLog;
import org.jurassicraft.common.block.tree.BlockJCPlanks;
import org.jurassicraft.common.block.tree.BlockJCSapling;
import org.jurassicraft.common.block.tree.BlockJCSlabDouble;
import org.jurassicraft.common.block.tree.BlockJCSlabHalf;
import org.jurassicraft.common.block.tree.BlockJCStairs;
import org.jurassicraft.common.block.tree.EnumType;
import org.jurassicraft.common.dinosaur.Dinosaur;
import org.jurassicraft.common.entity.base.JCEntityRegistry;
import org.jurassicraft.common.item.itemblock.ItemBlockMeta;
import org.jurassicraft.common.item.itemblock.ItemJCSlab;
import org.jurassicraft.common.paleopad.dinopedia.DinoPediaRegistry;
import org.jurassicraft.common.tileentity.TileActionFigure;
import org.jurassicraft.common.tileentity.TileCarnivoreFeeder;
import org.jurassicraft.common.tileentity.TileCleaningStation;
import org.jurassicraft.common.tileentity.TileCultivate;
import org.jurassicraft.common.tileentity.TileDNACombinator;
import org.jurassicraft.common.tileentity.TileDNAExtractor;
import org.jurassicraft.common.tileentity.TileDNAHybridizer;
import org.jurassicraft.common.tileentity.TileDnaSequencer;
import org.jurassicraft.common.tileentity.TileDnaSynthesizer;
import org.jurassicraft.common.tileentity.TileEmbryoCalcificationMachine;
import org.jurassicraft.common.tileentity.TileEmbryonicMachine;
import org.jurassicraft.common.tileentity.TileFossilGrinder;
import org.jurassicraft.common.tileentity.TileIncubator;
import org.jurassicraft.common.world.jurdstrees.algorythms.TreeCompendium;

public class JCBlockRegistry {
    public static final int numOfTrees = 2;
    public static Block[] planks;
    public static Block[] woods;
    public static Block[] leaves;
    public static Block[] saplings;
    public static Block[] doors;
    public static Block[] fences;
    public static Block[] slabs;
    public static Block[] doubleSlabs;
    public static Block[] stairs;
    public static List<BlockFossil> fossils;
    public static List<BlockEncasedFossil> encased_fossils;
    public static Block cleaning_station;
    public static Block fossil_grinder;
    public static Block dna_sequencer;
    public static Block dna_synthesizer;
    public static Block embryonic_machine;
    public static Block embryo_calcification_machine;
    public static Block incubator;
    public static Block dna_extractor;
    public static Block amber_ore;
    public static Block ice_shard;
    public static Block gypsum_cobblestone;
    public static Block gypsum_stone;
    public static Block gypsum_bricks;
    public static Block dna_hybridizer;
    public static Block dna_combinator;
    public static Block security_camera;
    public static Block reinforced_stone;
    public static Block reinforced_bricks;
    public static Block small_royal_fern;
    public static Block small_chain_fern;
    public static Block small_cycad;
    public static Block cultivate_top;
    public static Block cultivate_bottom;
    public static Block carnivore_feeder;
    public static Block bennettitalean_cycadeoidea;
    public static Block cry_pansy;
    public static Block scaly_tree_fern;
    public static Block cycad_zamites;
    public static Block dicksonia;
    public static Block action_figure;
    public static Block bPlanks;

    public void register() {
        int i;
        fossils = new ArrayList<BlockFossil>();
        encased_fossils = new ArrayList<BlockEncasedFossil>();
        carnivore_feeder = new BlockCarnivoreFeeder();
        cleaning_station = new BlockCleaningStation();
        fossil_grinder = new BlockFossilGrinder();
        dna_sequencer = new BlockDnaSequencer();
        dna_synthesizer = new BlockDnaSynthesizer();
        embryonic_machine = new BlockEmbryonicMachine();
        embryo_calcification_machine = new BlockEmbryoCalcificationMachine();
        incubator = new BlockIncubator();
        dna_extractor = new BlockDNAExtractor();
        dna_hybridizer = new BlockDNAHybridizer();
        dna_combinator = new BlockDNACombinator();
        cultivate_bottom = new BlockCultivateBottom();
        cultivate_top = new BlockCultivateTop();
        amber_ore = this.addBlock(new BlockAmber(), "amber_ore");
        ice_shard = this.addBlock(new BlockIceShard(), "ice_shard");
        gypsum_stone = this.addBlock(new BlockGypsumStone().func_149711_c(1.5f).func_149752_b(10.0f), "gypsum_stone");
        gypsum_cobblestone = this.addBlock(new BlockBasic(Material.field_151576_e).func_149711_c(1.5f).func_149752_b(10.0f), "gypsum_cobblestone");
        gypsum_bricks = this.addBlock(new BlockBasic(Material.field_151576_e).func_149711_c(1.5f).func_149752_b(10.0f), "gypsum_bricks");
        reinforced_stone = this.addBlock(new BlockBasic(Material.field_151576_e).func_149711_c(2.0f).func_149752_b(15.0f), "reinforced_stone");
        reinforced_bricks = this.addBlock(new BlockBasic(Material.field_151576_e).func_149711_c(2.0f).func_149752_b(15.0f), "reinforced_bricks");
        small_royal_fern = this.addBlock((Block)new BlockSmallRoyalFern(), "small_royal_fern");
        small_chain_fern = this.addBlock((Block)new BlockSmallChainFern(), "small_chain_fern");
        small_cycad = this.addBlock((Block)new BlockSmallCycad(), "small_cycad");
        bennettitalean_cycadeoidea = this.addBlock((Block)new BlockBennettitaleanCycadeoidea(), "bennettitalean_cycadeoidea");
        cry_pansy = this.addBlock((Block)new BlockCryPansy(), "cry_pansy");
        scaly_tree_fern = this.addBlock((Block)new BlockScalyTreeFern(), "scaly_tree_fern");
        cycad_zamites = this.addBlock((Block)new BlockCycadZamites(), "cycad_zamites");
        dicksonia = this.addBlock((Block)new BlockDicksonia(), "dicksonia");
        action_figure = new BlockActionFigure();
        security_camera = this.addBlock(new BlockSecurityCamera(), "security_camera");
        List<Dinosaur> dinosaurs = JCEntityRegistry.getDinosaurs();
        int blocksToCreate = (int)Math.ceil((float)dinosaurs.size() / 16.0f);
        for (i = 0; i < blocksToCreate; ++i) {
            BlockFossil fossil = new BlockFossil(i * 16);
            BlockEncasedFossil encasedFossil = new BlockEncasedFossil(i * 16);
            fossils.add(fossil);
            encased_fossils.add(encasedFossil);
            this.registerBlock(fossil, "Fossil Block " + i);
            this.registerBlock(encasedFossil, "Encased Fossil " + i);
            OreDictionary.registerOre((String)"fossil", (Block)fossil);
        }
        EnumType.GINKGO.setMetaLookup();
        EnumType.CALAMITES.setMetaLookup();
        TreeCompendium.addShapesToCompendium();
        TreeCompendium.registerTrees();
        planks = new Block[2];
        woods = new Block[2];
        leaves = new Block[2];
        saplings = new Block[2];
        doors = new Block[2];
        fences = new Block[2];
        slabs = new Block[2];
        doubleSlabs = new Block[2];
        stairs = new Block[2];
        for (i = 0; i < 2; ++i) {
            EnumType type = EnumType.getMetaLookup()[i];
            String typeName = type.func_176610_l();
            JCBlockRegistry.planks[i] = new BlockJCPlanks(type, typeName);
            JCBlockRegistry.woods[i] = new BlockJCLog(type, typeName);
            JCBlockRegistry.leaves[i] = new BlockJCLeaves(type, typeName);
            JCBlockRegistry.saplings[i] = new BlockJCSapling(type, typeName);
            JCBlockRegistry.stairs[i] = new BlockJCStairs(typeName, planks[i].func_176223_P());
            JCBlockRegistry.slabs[i] = new BlockJCSlabHalf(typeName, planks[i].func_176223_P());
            JCBlockRegistry.doubleSlabs[i] = new BlockJCSlabDouble(typeName, slabs[i], planks[i].func_176223_P());
            GameRegistry.registerBlock((Block)planks[i], (String)(typeName + "_planks"));
            GameRegistry.registerBlock((Block)woods[i], (String)(typeName + "_log"));
            GameRegistry.registerBlock((Block)leaves[i], (String)(typeName + "_leaves"));
            GameRegistry.registerBlock((Block)saplings[i], (String)(typeName + "_sapling"));
            GameRegistry.registerBlock((Block)stairs[i], (String)(typeName + "_stairs"));
            GameRegistry.registerBlock((Block)slabs[i], ItemJCSlab.class, (String)(typeName + "_slab"), (Object[])new Object[]{slabs[i], doubleSlabs[i]});
            GameRegistry.registerBlock((Block)doubleSlabs[i], ItemJCSlab.class, (String)(typeName + "_double_slab"), (Object[])new Object[]{slabs[i], doubleSlabs[i]});
            OreDictionary.registerOre((String)"logWood", (Block)woods[i]);
            OreDictionary.registerOre((String)"plankWood", (Block)planks[i]);
            OreDictionary.registerOre((String)"treeLeaves", (Block)leaves[i]);
            OreDictionary.registerOre((String)"treeSapling", (Block)saplings[i]);
            OreDictionary.registerOre((String)"slabWood", (Block)slabs[i]);
            OreDictionary.registerOre((String)"stairkWood", (Block)stairs[i]);
            Blocks.field_150480_ab.func_180686_a(leaves[i], 30, 60);
            Blocks.field_150480_ab.func_180686_a(planks[i], 5, 20);
            Blocks.field_150480_ab.func_180686_a(woods[i], 5, 5);
            Blocks.field_150480_ab.func_180686_a(doubleSlabs[i], 5, 20);
            Blocks.field_150480_ab.func_180686_a(slabs[i], 5, 20);
            Blocks.field_150480_ab.func_180686_a(stairs[i], 5, 20);
        }
        this.registerBlockTileEntity(TileCultivate.class, cultivate_bottom, "Cultivate Bottom");
        this.registerBlock(cultivate_top, "Cultivate Top");
        this.registerBlockTileEntity(TileCarnivoreFeeder.class, carnivore_feeder, "Carnivore Feeder");
        this.registerBlockTileEntity(TileCleaningStation.class, cleaning_station, "Cleaning Station");
        this.registerBlockTileEntity(TileFossilGrinder.class, fossil_grinder, "Fossil Grinder");
        this.registerBlockTileEntity(TileDnaSequencer.class, dna_sequencer, "DNA Sequencer");
        this.registerBlockTileEntity(TileDnaSynthesizer.class, dna_synthesizer, "DNA Synthesizer");
        this.registerBlockTileEntity(TileEmbryonicMachine.class, embryonic_machine, "Embryonic Machine");
        this.registerBlockTileEntity(TileEmbryoCalcificationMachine.class, embryo_calcification_machine, "Embryo Calcification Machine");
        this.registerBlockTileEntity(TileDNAExtractor.class, dna_extractor, "DNA Extractor");
        this.registerBlockTileEntity(TileDNAHybridizer.class, dna_hybridizer, "DNA Hybridizer");
        this.registerBlockTileEntity(TileDNACombinator.class, dna_combinator, "DNA Combinator");
        this.registerBlockTileEntity(TileIncubator.class, incubator, "Incubator");
        this.registerBlockTileEntity(TileActionFigure.class, action_figure, "Action Figure Block");
    }

    private Block addBlock(Block block, String name) {
        block.func_149663_c(name);
        DinoPediaRegistry.registerItem(new ItemStack(block));
        if (block instanceof BlockMeta) {
            GameRegistry.registerBlock((Block)block, ItemBlockMeta.class, (String)name);
        } else if (block instanceof ISubBlocksBlock) {
            GameRegistry.registerBlock((Block)block, ((ISubBlocksBlock)block).getItemBlockClass(), (String)name);
        } else {
            GameRegistry.registerBlock((Block)block, (String)name);
        }
        return block;
    }

    public BlockFossil getFossilBlock(Dinosaur dinosaur) {
        return this.getFossilBlock(JCEntityRegistry.getDinosaurId(dinosaur));
    }

    private int getBlockId(int dinosaurId) {
        return (int)Math.floor(((float)dinosaurId + 1.0f) / 16.0f - 0.0625f);
    }

    public BlockEncasedFossil getEncasedFossil(Dinosaur dinosaur) {
        return this.getEncasedFossil(JCEntityRegistry.getDinosaurId(dinosaur));
    }

    public BlockEncasedFossil getEncasedFossil(int id) {
        return encased_fossils.get(this.getBlockId(id));
    }

    public BlockFossil getFossilBlock(int id) {
        return fossils.get(this.getBlockId(id));
    }

    public int getDinosaurId(BlockFossil fossil, int metadata) {
        return fossils.indexOf(fossil) * 16 + metadata;
    }

    public int getDinosaurId(BlockEncasedFossil fossil, int metadata) {
        return encased_fossils.indexOf(fossil) * 16 + metadata;
    }

    public int getMetadata(int id) {
        return id % 16;
    }

    public int getMetadata(Dinosaur dinosaur) {
        return this.getMetadata(JCEntityRegistry.getDinosaurId(dinosaur));
    }

    public void registerBlockTileEntity(Class<? extends TileEntity> tileEntity, Block block, String name) {
        this.registerBlock(block, name);
        GameRegistry.registerTileEntity(tileEntity, (String)("jurassicraft:" + name.toLowerCase().replaceAll(" ", "_")));
    }

    public void registerBlock(Block block, String name) {
        name = name.toLowerCase().replaceAll(" ", "_");
        DinoPediaRegistry.registerItem(new ItemStack(block));
        if (block instanceof ISubBlocksBlock) {
            GameRegistry.registerBlock((Block)block, ((ISubBlocksBlock)block).getItemBlockClass(), (String)name);
        } else {
            GameRegistry.registerBlock((Block)block, (String)name);
        }
    }
}

