/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.common.block.BlockOriented;
import org.jurassicraft.common.item.JCItemRegistry;
import org.jurassicraft.common.tileentity.TileActionFigure;

public class BlockActionFigure
extends BlockOriented {
    public BlockActionFigure() {
        super(Material.field_151575_d);
        this.func_149675_a(true);
        this.func_149711_c(0.0f);
        this.func_149752_b(0.0f);
        this.func_149663_c("action_figure_block");
        float f = 0.2f;
        this.func_149676_a(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, f * 3.0f, 0.5f + f);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) && this.canBlockStay(worldIn, pos, worldIn.func_180495_p(pos));
    }

    public void func_176204_a(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        super.func_176204_a(worldIn, pos, state, neighborBlock);
        this.checkAndDropBlock(worldIn, pos, state);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        this.checkAndDropBlock(worldIn, pos, state);
    }

    protected void checkAndDropBlock(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.canBlockStay(worldIn, pos, state)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }
    }

    public boolean canBlockStay(World worldIn, BlockPos pos, IBlockState state) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_177230_c().func_149662_c();
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return JCItemRegistry.action_figure;
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_180665_b(World worldIn, BlockPos pos) {
        return JCItemRegistry.action_figure;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileActionFigure();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EnumWorldBlockLayer func_180664_k() {
        return EnumWorldBlockLayer.CUTOUT_MIPPED;
    }

    @Override
    public boolean func_149662_c() {
        return false;
    }

    @Override
    public boolean func_149686_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return true;
    }

    public int func_176222_j(World worldIn, BlockPos pos) {
        return this.getTile((World)worldIn, (BlockPos)pos).dinosaur;
    }

    protected TileActionFigure getTile(World world, BlockPos pos) {
        return (TileActionFigure)world.func_175625_s(pos);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        int count = this.quantityDropped(state, fortune, rand);
        for (int i = 0; i < count; ++i) {
            Item item = this.func_180660_a(state, rand, fortune);
            if (item == null) continue;
            ret.add(new ItemStack(item, 1, this.func_176222_j((World)world, pos)));
        }
        return ret;
    }
}

