/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.client.render.entity;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.timeless.unilib.client.model.json.ModelJson;
import net.timeless.unilib.client.model.json.TabulaModelHelper;
import org.jurassicraft.JurassiCraft;
import org.jurassicraft.client.model.animation.vehicle.AnimationHelicopter;
import org.jurassicraft.common.vehicles.helicopter.EntityHelicopterBase;
import org.jurassicraft.common.vehicles.helicopter.modules.HelicopterModule;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderHelicopter
extends Render {
    private static final ResourceLocation texture = new ResourceLocation("jurassicraft", "textures/entities/helicopter/ranger_helicopter_texture.png");
    private final Map<HelicopterModule, ModelJson> moduleMap = Maps.newHashMap();
    private final Map<HelicopterModule, ResourceLocation> moduleTextures = Maps.newHashMap();
    private ModelJson baseModel;

    public RenderHelicopter() {
        super(Minecraft.func_71410_x().func_175598_ae());
        try {
            this.baseModel = new ModelJson(TabulaModelHelper.parseModel("/assets/jurassicraft/models/entities/helicopter/ranger_helicopter"), new AnimationHelicopter());
            this.baseModel.setResetEachFrame(false);
            for (HelicopterModule module : HelicopterModule.registry.values()) {
                ModelJson model = new ModelJson(TabulaModelHelper.parseModel("/assets/jurassicraft/models/entities/helicopter/modules/" + module.getModuleID()));
                model.setResetEachFrame(true);
                this.moduleMap.put(module, model);
                this.moduleTextures.put(module, new ResourceLocation("jurassicraft", "textures/entities/helicopter/modules/" + module.getModuleID() + "_texture.png"));
            }
        }
        catch (Exception e) {
            JurassiCraft.instance.getLogger().fatal("Failed to load the models for the Helicopter", (Throwable)e);
        }
    }

    public void func_76986_a(Entity entity, double x, double y, double z, float p_76986_8_, float partialTicks) {
        this.doRender((EntityHelicopterBase)entity, x, y, z, p_76986_8_, partialTicks);
    }

    public void doRender(EntityHelicopterBase helicopter, double x, double y, double z, float yaw, float partialTicks) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y + 1.5f), (float)((float)z));
        GlStateManager.func_179114_b((float)(180.0f - yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)helicopter.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)helicopter.getRoll(), (float)0.0f, (float)0.0f, (float)1.0f);
        float f4 = 1.0f;
        GlStateManager.func_179152_a((float)f4, (float)f4, (float)f4);
        GlStateManager.func_179152_a((float)(1.0f / f4), (float)(1.0f / f4), (float)(1.0f / f4));
        this.func_180548_c((Entity)helicopter);
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)770, (int)771);
        this.baseModel.func_78088_a((Entity)helicopter, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        this.renderModules(helicopter, x, y, z, yaw, partialTicks);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GlStateManager.func_179121_F();
        super.func_76986_a((Entity)helicopter, x, y, z, yaw, partialTicks);
    }

    private void renderModules(EntityHelicopterBase helicopter, double x, double y, double z, float yaw, float partialTicks) {
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        return texture;
    }
}

