/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.client.gui.app;

import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jurassicraft.JurassiCraft;
import org.jurassicraft.client.gui.GuiPaleoPad;
import org.jurassicraft.client.gui.app.GuiApp;
import org.jurassicraft.common.entity.data.JCPlayerData;
import org.jurassicraft.common.entity.data.JCPlayerDataClient;
import org.jurassicraft.common.message.MessageRequestFile;
import org.jurassicraft.common.paleopad.App;
import org.jurassicraft.common.paleopad.AppFileExplorer;
import org.jurassicraft.common.paleopad.JCFile;

public class GuiAppFileExplorer
extends GuiApp {
    private static final ResourceLocation texture = new ResourceLocation("jurassicraft", "textures/gui/paleo_pad/apps/file_explorer.png");
    private boolean intro;
    private boolean loading;

    public GuiAppFileExplorer(App app) {
        super(app);
    }

    @Override
    public void render(int mouseX, int mouseY, GuiPaleoPad gui) {
        super.renderButtons(mouseX, mouseY, gui);
        AppFileExplorer app = (AppFileExplorer)this.getApp();
        if (this.intro) {
            gui.drawScaledText("Hello " + GuiAppFileExplorer.mc.field_71439_g.func_145748_c_().func_150254_d() + "! Welcome to " + app.getName() + "!", 4, 10, 1.0f, 0xFFFFFF);
            mc.func_110434_K().func_110577_a(texture);
            gui.drawScaledTexturedModalRect(1, 20, 0, 0, 32, 32, 32, 32, 1.0f);
            gui.drawScaledText("Using " + app.getName() + " you can browse all your files!", 34, 29, 0.7f, 0xFFFFFF);
        } else {
            String path = app.getPath();
            List<JCFile> filesAtPath = JCPlayerDataClient.getPlayerData().getFilesAtPath(path);
            if (this.loading) {
                if (filesAtPath != null) {
                    this.loading = false;
                } else {
                    gui.drawScaledText("Downloading files...", 4, 10, 1.0f, 0xFFFFFF);
                }
            } else {
                int y = 5;
                for (JCFile file : filesAtPath) {
                    if (file == null || file.getName().length() <= 0 || y >= 125) continue;
                    gui.drawBoxOutline(5, y, 207, 12, 1, 1.0f, 0x606060);
                    String name = file.getName();
                    if (name.length() > 23) {
                        name = name.substring(0, 23) + "...";
                    }
                    gui.drawScaledText(name, 7, y + 3, 1.0f, 0xFFFFFF);
                    gui.drawScaledText(file.isFile() ? "       File" : "Directory", 160, y + 3, 1.0f, 0x7F7F7F);
                    y += 15;
                }
                gui.drawScaledRect(217, 5, 7, 140, 1.0f, 0x7F7F7F);
                gui.drawBoxOutline(217, 5, 7, 140, 1, 1.0f, 0x606060);
                gui.drawBoxOutline(5, 132, 65, 12, 1, 1.0f, 0x606060);
                gui.drawScaledText("<-- Move up", 8, 135, 1.0f, 0xFFFFFF);
            }
        }
    }

    @Override
    public void actionPerformed(GuiButton button) {
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, GuiPaleoPad gui) {
        ScaledResolution dimensions = new ScaledResolution(mc);
        mouseX -= dimensions.func_78326_a() / 2 - 115;
        mouseY -= 65;
        if (!this.intro) {
            AppFileExplorer app = (AppFileExplorer)this.getApp();
            String path = app.getPath();
            List<JCFile> filesAtPath = JCPlayerDataClient.getPlayerData().getFilesAtPath(path);
            if (filesAtPath != null) {
                int y = 5;
                for (JCFile file : filesAtPath) {
                    if (file == null || file.getName().length() <= 0 || !file.isDirectory() || y >= 125) continue;
                    if (mouseX > 5 && mouseX < 212 && mouseY > y && mouseY < y + 12) {
                        app.setPath(file.getPath());
                        if (path.equals(app.getPath())) break;
                        this.request(app.getPath());
                        break;
                    }
                    y += 15;
                }
            }
            if (mouseX > 5 && mouseX < 70 && mouseY > 132 && mouseY < 144) {
                String[] split = path.split(Pattern.quote("/"));
                if (split.length > 1) {
                    app.setPath(path.substring(0, path.lastIndexOf("/")));
                } else {
                    app.setPath("");
                }
                if (!path.equals(app.getPath())) {
                    this.request(app.getPath());
                }
            }
        }
    }

    private void request(String path) {
        if (path == null) {
            path = "";
        }
        JurassiCraft.networkManager.networkWrapper.sendToServer((IMessage)new MessageRequestFile(path));
        JCPlayerData playerData = JCPlayerDataClient.getPlayerData();
        if (path.length() == 0) {
            playerData.clearRootFiles();
        } else {
            playerData.remove(playerData.getFileFromPath(path));
        }
        this.loading = true;
    }

    @Override
    public void init() {
        this.intro = !this.app.hasBeenPreviouslyOpened();
        this.request(((AppFileExplorer)this.app).getPath());
    }

    @Override
    public ResourceLocation getTexture(GuiPaleoPad gui) {
        return texture;
    }
}

