/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.client.gui;

import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jurassicraft.JurassiCraft;
import org.jurassicraft.common.dinosaur.Dinosaur;
import org.jurassicraft.common.entity.base.JCEntityRegistry;
import org.jurassicraft.common.message.MessagePlacePaddockSign;
import org.lwjgl.opengl.GL11;

public class GuiSelectDino
extends GuiScreen {
    private static final ResourceLocation paddock_sign = new ResourceLocation("jurassicraft", "textures/paddock/paddock_signs.png");
    private int page;
    private int pageCount;
    public int columnsPerPage = 5;
    public int rowsPerPage = 3;
    private GuiButton forward;
    private GuiButton backward;
    private BlockPos pos;
    private EnumFacing facing;

    public GuiSelectDino(BlockPos pos, EnumFacing facing) {
        this.pos = pos;
        this.facing = facing;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.add(new GuiButton(0, (this.field_146294_l - 150) / 2, this.field_146295_m / 5 + 150, 150, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])));
        this.backward = new GuiButton(1, this.field_146294_l / 2 - 105, this.field_146295_m / 5 + 150, 20, 20, "<");
        this.field_146292_n.add(this.backward);
        this.forward = new GuiButton(2, this.field_146294_l / 2 + 85, this.field_146295_m / 5 + 150, 20, 20, ">");
        this.field_146292_n.add(this.forward);
        this.page = 0;
        this.pageCount = JCEntityRegistry.getRegisteredDinosaurs().size() / (this.columnsPerPage * this.rowsPerPage);
        this.enableDisablePages();
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        if (state == 0) {
            List<Dinosaur> registeredDinosaurs = JCEntityRegistry.getRegisteredDinosaurs();
            int signsPerPage = this.columnsPerPage * this.rowsPerPage;
            int xOffset = 0;
            int yOffset = 0;
            this.pageCount = registeredDinosaurs.size() / signsPerPage;
            for (int i = 0; i < registeredDinosaurs.size(); ++i) {
                if (i < signsPerPage * this.page || i >= signsPerPage * (this.page + 1)) continue;
                float scale = 3.0f;
                int x = (int)((float)(this.field_146294_l / 2 - 140 + xOffset) / scale);
                int y = (int)((float)(this.field_146295_m / 8 + yOffset - 20) / scale);
                float scaledMouseX = (float)mouseX / scale;
                float scaledMouseY = (float)mouseY / scale;
                if (scaledMouseX > (float)x && scaledMouseY > (float)y && scaledMouseX < (float)(x + 16) && scaledMouseY < (float)(y + 16)) {
                    this.selectDinosaur(registeredDinosaurs.get(i));
                    break;
                }
                xOffset = (int)((float)xOffset + 180.0f / scale);
                if (i % this.columnsPerPage < this.columnsPerPage - 1) continue;
                xOffset = 0;
                yOffset = (int)((float)yOffset + 180.0f / scale);
            }
        }
    }

    public void func_146284_a(GuiButton button) {
        int id = button.field_146127_k;
        if (id == 1) {
            if (this.page > 0) {
                --this.page;
            }
        } else if (id == 2) {
            if (this.page < this.pageCount) {
                ++this.page;
            }
        } else {
            this.field_146297_k.func_147108_a(null);
        }
        this.enableDisablePages();
    }

    public void enableDisablePages() {
        this.backward.field_146124_l = this.page > 0;
        this.forward.field_146124_l = this.page < this.pageCount;
    }

    public void selectDinosaur(Dinosaur dinosaur) {
        this.field_146297_k.func_147108_a(null);
        if (!this.field_146297_k.field_71439_g.field_71075_bZ.field_75098_d) {
            InventoryPlayer inventory = this.field_146297_k.field_71439_g.field_71071_by;
            inventory.func_70298_a(inventory.field_70461_c, 1);
        }
        JurassiCraft.networkManager.networkWrapper.sendToServer((IMessage)new MessagePlacePaddockSign(this.facing, this.pos, dinosaur));
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        List<Dinosaur> registeredDinosaurs = JCEntityRegistry.getRegisteredDinosaurs();
        int signsPerPage = this.columnsPerPage * this.rowsPerPage;
        int xOffset = 0;
        int yOffset = 0;
        this.pageCount = registeredDinosaurs.size() / signsPerPage;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i = 0;
        for (Dinosaur dinosaur : registeredDinosaurs) {
            if (i >= signsPerPage * this.page && i < signsPerPage * (this.page + 1)) {
                int id = JCEntityRegistry.getDinosaurId(dinosaur);
                GlStateManager.func_179094_E();
                this.field_146297_k.func_110434_K().func_110577_a(paddock_sign);
                float scale = 3.0f;
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
                int x = (int)((float)(this.field_146294_l / 2 - 140 + xOffset) / scale);
                int y = (int)((float)(this.field_146295_m / 8 + yOffset - 20) / scale);
                float scaledMouseX = (float)mouseX / scale;
                float scaledMouseY = (float)mouseY / scale;
                if (scaledMouseX > (float)x && scaledMouseY > (float)y && scaledMouseX < (float)(x + 16) && scaledMouseY < (float)(y + 16)) {
                    this.drawBoxOutline(x - 1, y - 1, 18, 17, 1, 0x60606060);
                }
                this.func_73729_b(x, y, id % 16 * 16, (int)Math.floor(id / 16) * 16, 16, 16);
                float textScale = 0.22f;
                GlStateManager.func_179152_a((float)textScale, (float)textScale, (float)textScale);
                this.func_73732_a(this.field_146297_k.field_71466_p, dinosaur.getName(), (int)((float)(x + 8) / textScale), (int)((float)(y + 17) / textScale), 0xFFFFFF);
                GlStateManager.func_179121_F();
                xOffset = (int)((float)xOffset + 180.0f / scale);
                if (i % this.columnsPerPage >= this.columnsPerPage - 1) {
                    xOffset = 0;
                    yOffset = (int)((float)yOffset + 180.0f / scale);
                }
            }
            ++i;
        }
    }

    public void drawScaledRect(int x, int y, int width, int height, int colour) {
        GL11.glDisable((int)3553);
        float red = (float)(colour >> 24 & 0xFF) / 255.0f;
        float green = (float)(colour >> 16 & 0xFF) / 255.0f;
        float blue = (float)(colour >> 8 & 0xFF) / 255.0f;
        float a = (float)(colour & 0xFF) / 255.0f;
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)a);
        float f = 1.0f / (float)width;
        float f1 = 1.0f / (float)height;
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldrenderer.func_181662_b((double)(x + 0), (double)(y + height), (double)this.field_73735_i).func_181673_a((double)(0.0f * f), (double)((float)height * f1)).func_181675_d();
        worldrenderer.func_181662_b((double)(x + width), (double)(y + height), (double)this.field_73735_i).func_181673_a((double)((float)width * f), (double)((float)(0 + height) * f1)).func_181675_d();
        worldrenderer.func_181662_b((double)(x + width), (double)(y + 0), (double)this.field_73735_i).func_181673_a((double)((float)(0 + width) * f), (double)(0.0f * f1)).func_181675_d();
        worldrenderer.func_181662_b((double)(x + 0), (double)(y + 0), (double)this.field_73735_i).func_181673_a((double)(0.0f * f), (double)(0.0f * f1)).func_181675_d();
        tessellator.func_78381_a();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
    }

    public void drawBoxOutline(int x, int y, int sizeX, int sizeY, int borderSize, int colour) {
        this.drawScaledRect(x, y, sizeX, borderSize, colour);
        this.drawScaledRect(x + sizeX, y, borderSize, sizeY + borderSize, colour);
        this.drawScaledRect(x, y + borderSize, borderSize, sizeY, colour);
        this.drawScaledRect(x + borderSize, y + sizeY, sizeX - borderSize, borderSize, colour);
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_146281_b() {
        super.func_146281_b();
    }
}

