/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft;

import java.io.File;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.GameRules;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import org.apache.logging.log4j.Logger;
import org.jurassicraft.common.achievements.JCAchievements;
import org.jurassicraft.common.block.JCBlockRegistry;
import org.jurassicraft.common.configuration.JCConfigurations;
import org.jurassicraft.common.creativetab.JCCreativeTabs;
import org.jurassicraft.common.entity.base.JCEntityRegistry;
import org.jurassicraft.common.food.FoodHelper;
import org.jurassicraft.common.item.JCItemRegistry;
import org.jurassicraft.common.message.JCNetworkManager;
import org.jurassicraft.common.paleopad.AppRegistry;
import org.jurassicraft.common.plant.JCPlantRegistry;
import org.jurassicraft.common.proxy.CommonProxy;
import org.jurassicraft.common.recipe.JCRecipeRegistry;
import org.jurassicraft.common.storagedisc.StorageTypeRegistry;
import org.jurassicraft.common.world.islanublar.WorldTypeIslaNublar;

@Mod(modid="jurassicraft", name="JurassiCraft", version="2.0.0-pre", guiFactory="org.jurassicraft.client.gui.config.GUIFactory", dependencies="required-after:llibrary@[0.6.2,)", acceptedMinecraftVersions="[1.8.8]")
public class JurassiCraft {
    @SidedProxy(serverSide="org.jurassicraft.common.proxy.CommonProxy", clientSide="org.jurassicraft.client.proxy.ClientProxy")
    public static CommonProxy proxy;
    public static final String MODID = "jurassicraft";
    public static final String MODNAME = "JurassiCraft";
    public static final String MODVERSION = "2.0.0-pre";
    @Mod.Instance(value="jurassicraft")
    public static JurassiCraft instance;
    public static long timerTicks;
    public static long timerNanoseconds;
    private Logger logger;
    public static JCEntityRegistry entityRegistry;
    public static JCPlantRegistry plantRegistry;
    public static JCCreativeTabs creativeTabRegistry;
    public static JCItemRegistry itemRegistry;
    public static JCBlockRegistry blockRegistry;
    public static JCRecipeRegistry recipeRegistry;
    public static JCNetworkManager networkManager;
    public static AppRegistry appRegistry;
    public static JCAchievements achievements;
    public static StorageTypeRegistry storageTypeRegistry;
    public static JCConfigurations configurations;
    public static WorldTypeIslaNublar worldTypeIslaNublar;
    public static File configFile;
    public static Configuration config;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.logger = event.getModLog();
        this.logger.info("Loading JurassiCraft...");
        timerNanoseconds = System.nanoTime();
        proxy.preInit(event);
        this.logger.debug("Finished pre-init for JurassiCraft!");
        FoodHelper.init();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init(event);
        this.logger.debug("Finished init for JurassiCraft!");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
        this.logger.info("Finished loaded JurassiCraft!");
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartedEvent event) {
        GameRules gameRules = MinecraftServer.func_71276_C().func_71218_a(0).func_82736_K();
        if (!gameRules.func_82765_e("dinoMetabolism")) {
            gameRules.func_180262_a("dinoMetabolism", "true", GameRules.ValueType.BOOLEAN_VALUE);
        }
        if (!gameRules.func_82765_e("dinoGrowth")) {
            gameRules.func_180262_a("dinoGrowth", "true", GameRules.ValueType.BOOLEAN_VALUE);
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public boolean isDebugging() {
        return MODVERSION.equals("${version}");
    }

    public long getNanoTimeInterval() {
        long interval = System.nanoTime() - timerNanoseconds;
        timerNanoseconds = 0L;
        return interval;
    }

    static {
        entityRegistry = new JCEntityRegistry();
        plantRegistry = new JCPlantRegistry();
        creativeTabRegistry = new JCCreativeTabs();
        itemRegistry = new JCItemRegistry();
        blockRegistry = new JCBlockRegistry();
        recipeRegistry = new JCRecipeRegistry();
        networkManager = new JCNetworkManager();
        appRegistry = new AppRegistry();
        achievements = new JCAchievements();
        storageTypeRegistry = new StorageTypeRegistry();
        configurations = new JCConfigurations();
        worldTypeIslaNublar = new WorldTypeIslaNublar();
    }
}

