/*
 * Decompiled with CFR 0.152.
 */
package net.timeless.unilib.common;

import com.google.common.collect.Maps;
import java.util.HashMap;
import net.timeless.unilib.common.structure.StructureBuilder;
import net.timeless.unilib.common.structure.StructureGenerator;

public class StructureRegistry {
    private static final StructureRegistry instance = new StructureRegistry();
    private final HashMap<String, StructureGenerator> map = Maps.newHashMap();

    private StructureRegistry() {
    }

    public void registerStructure(String name, StructureGenerator generator) {
        this.map.put(name, generator);
    }

    public StructureBuilder createStructure(String name) {
        StructureBuilder builder = new StructureBuilder();
        this.registerStructure(name, builder);
        return builder;
    }

    public StructureGenerator getStructure(String name) {
        return this.map.get(name);
    }

    public static StructureRegistry getInstance() {
        return instance;
    }
}

