/*
 * Decompiled with CFR 0.152.
 */
package net.timeless.unilib.client.model.json;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.timeless.unilib.client.model.json.CubeGroup;
import net.timeless.unilib.client.model.json.CubeInfo;
import net.timeless.unilib.client.model.json.IModelAnimator;
import net.timeless.unilib.client.model.json.JsonTabulaModel;
import net.timeless.unilib.client.model.tools.MowzieModelBase;
import net.timeless.unilib.client.model.tools.MowzieModelRenderer;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ModelJson
extends MowzieModelBase {
    private final List<MowzieModelRenderer> parents = new ArrayList<MowzieModelRenderer>();
    private final Map<String, MowzieModelRenderer> nameMap = Maps.newHashMap();
    private IModelAnimator animator;
    private boolean resetsEachFrame;
    private double[] scale;

    public ModelJson(JsonTabulaModel model) {
        this.scale = model.getScale();
        this.field_78090_t = model.getTextureWidth();
        this.field_78089_u = model.getTextureHeight();
        for (CubeInfo c : model.getCubes()) {
            this.cube(c, null);
        }
        for (CubeGroup g : model.getCubeGroups()) {
            this.cubeGroup(g);
        }
        this.resetsEachFrame = true;
        this.setInitPose();
    }

    public ModelJson(JsonTabulaModel model, IModelAnimator animator) {
        this(model);
        this.animator = animator;
    }

    public void func_78088_a(Entity entity, float limbSwing, float limbSwingAmount, float rotation, float rotationYaw, float rotationPitch, float partialTicks) {
        this.func_78087_a(limbSwing, limbSwingAmount, rotation, rotationYaw, rotationPitch, partialTicks, entity);
        GL11.glScaled((double)this.scale[0], (double)this.scale[1], (double)this.scale[2]);
        for (MowzieModelRenderer parent : this.parents) {
            parent.func_78785_a(partialTicks);
        }
    }

    public void func_78087_a(float limbSwing, float limbSwingAmount, float rotation, float rotationYaw, float rotationPitch, float scale, Entity entity) {
        super.func_78087_a(limbSwing, limbSwingAmount, rotation, rotationYaw, rotationPitch, scale, entity);
        if (!Minecraft.func_71410_x().func_147113_T()) {
            if (this.resetsEachFrame) {
                this.setToInitPose();
            }
            if (this.animator != null) {
                this.animator.setRotationAngles(this, limbSwing, limbSwingAmount, rotation, rotationYaw, rotationPitch, entity);
            }
        }
    }

    private void cubeGroup(CubeGroup group) {
        for (CubeInfo cube : group.cubes) {
            this.cube(cube, null);
        }
        for (CubeGroup c : group.cubeGroups) {
            this.cubeGroup(c);
        }
    }

    private void cube(CubeInfo cube, MowzieModelRenderer parent) {
        MowzieModelRenderer modelRenderer = this.createModelRenderer(cube);
        if (parent == null && !this.parents.contains((Object)modelRenderer)) {
            this.parents.add(modelRenderer);
        }
        this.nameMap.put(cube.name, modelRenderer);
        if (parent != null) {
            parent.func_78792_a(modelRenderer);
        }
        for (CubeInfo c : cube.children) {
            this.cube(c, modelRenderer);
        }
    }

    private MowzieModelRenderer createModelRenderer(CubeInfo cubeInfo) {
        MowzieModelRenderer cube = new MowzieModelRenderer(this, cubeInfo.txOffset[0], cubeInfo.txOffset[1]);
        cube.func_78793_a((float)cubeInfo.position[0], (float)cubeInfo.position[1], (float)cubeInfo.position[2]);
        cube.func_78790_a((float)cubeInfo.offset[0], (float)cubeInfo.offset[1], (float)cubeInfo.offset[2], cubeInfo.dimensions[0], cubeInfo.dimensions[1], cubeInfo.dimensions[2], 0.0f);
        cube.field_78795_f = (float)Math.toRadians((float)cubeInfo.rotation[0]);
        cube.field_78796_g = (float)Math.toRadians((float)cubeInfo.rotation[1]);
        cube.field_78808_h = (float)Math.toRadians((float)cubeInfo.rotation[2]);
        return cube;
    }

    public MowzieModelRenderer getCube(String name) {
        return this.nameMap.get(name);
    }

    public String[] getCubeNamesArray() {
        String[] cubeNamesArray = new String[this.nameMap.size()];
        int index = 0;
        Set<String> keySet = this.nameMap.keySet();
        Iterator<String> iterator = keySet.iterator();
        while (iterator.hasNext()) {
            cubeNamesArray[index] = iterator.next();
            ++index;
        }
        return cubeNamesArray;
    }

    public boolean resetsEachFrame() {
        return this.resetsEachFrame;
    }

    public void setResetEachFrame(boolean resetsEachFrame) {
        this.resetsEachFrame = resetsEachFrame;
    }
}

