/*
 * Decompiled with CFR 0.152.
 */
package net.timeless.unilib;

import com.google.common.reflect.ClassPath;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.fml.common.DummyModContainer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.timeless.unilib.common.BaseMod;
import net.timeless.unilib.common.BlockProvider;
import net.timeless.unilib.common.ItemProvider;

@Mod(modid="net/timeless/unilib", name="Unilib", version="${unilib_version}", acceptedMinecraftVersions="[1.8.8]")
public class Unilib
extends BaseMod {
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        super.preInitMod(evt);
        this.logger.info("Loading Unilib " + Unilib.getVersion());
        this.logger.info("Loading content handlers...");
    }

    private void handleClass(ClassPath.ClassInfo info, LoadController controller, ModContainer container, List<String> forbiddenPackages) {
        try {
            Class<?>[] interfaces;
            Side side;
            boolean isAllowed = true;
            for (String s : forbiddenPackages) {
                if (!info.getName().startsWith(s)) continue;
                isAllowed = false;
                break;
            }
            if (!isAllowed) {
                return;
            }
            Side currentSide = FMLCommonHandler.instance().getEffectiveSide();
            if (info.getName().toLowerCase().contains("client") && currentSide != Side.CLIENT || info.getName().toLowerCase().contains("server") && currentSide != Side.SERVER) {
                System.out.println(">> " + info.getName().toLowerCase());
                return;
            }
            Class<?> clazz = Class.forName(info.getName(), false, this.getClass().getClassLoader());
            Object instance = null;
            if (clazz.isAnnotationPresent(Mod.class)) {
                Mod mod = clazz.getAnnotation(Mod.class);
                List list = Loader.instance().getModList();
                for (ModContainer c : list) {
                    Object modInstance = c.getMod();
                    if (modInstance == null || modInstance.getClass() != clazz) continue;
                    instance = modInstance;
                    break;
                }
            }
            if (clazz.isAnnotationPresent(SideOnly.class) && !(side = clazz.getAnnotation(SideOnly.class).value()).equals((Object)FMLCommonHandler.instance().getSide())) {
                return;
            }
            if (instance == null) {
                try {
                    instance = clazz.newInstance();
                }
                catch (Exception e) {
                    return;
                }
            }
            ModMetadata metadata = new ModMetadata();
            DummyModContainer modContainer = new DummyModContainer(metadata);
            for (Class<?> in : interfaces = clazz.getInterfaces()) {
                Object provider;
                this.setContainer((ModContainer)modContainer, controller);
                if (in == BlockProvider.class) {
                    provider = (BlockProvider)instance;
                    this.logger.info("Found block provider: " + clazz.getName());
                    Collection<Block> blocks = provider.createBlocks();
                    metadata.modId = provider.getModID();
                    for (Block b : blocks) {
                        GameRegistry.registerBlock((Block)b, (String)b.func_149739_a().replaceFirst("tile\\.", ""));
                    }
                } else if (in == ItemProvider.class) {
                    provider = (ItemProvider)instance;
                    this.logger.info("Found item provider: " + clazz.getName());
                    Collection<Item> items = provider.createItems();
                    metadata.modId = provider.getModID();
                    for (Item i : items) {
                        GameRegistry.registerItem((Item)i, (String)i.func_77658_a().replaceFirst("item\\.", ""));
                    }
                }
                this.setContainer(container, controller);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
    }

    private void setContainer(ModContainer container, LoadController controller) {
        ObfuscationReflectionHelper.setPrivateValue(LoadController.class, (Object)controller, (Object)container, (int)7);
    }

    public static String getVersion() {
        return "${unilib_version}";
    }
}

