/*
 * Decompiled with CFR 0.152.
 */
package net.timeless.animationapi.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.timeless.animationapi.client.AnimID;
import net.timeless.animationapi.client.JabelarAnimationHelper;
import net.timeless.animationapi.client.dto.AnimationsDTO;
import net.timeless.animationapi.client.dto.DinosaurRenderDefDTO;
import net.timeless.animationapi.client.dto.PoseDTO;
import net.timeless.unilib.Unilib;
import net.timeless.unilib.client.model.json.IModelAnimator;
import net.timeless.unilib.client.model.json.ModelJson;
import net.timeless.unilib.client.model.tools.MowzieModelRenderer;
import org.jurassicraft.JurassiCraft;
import org.jurassicraft.client.model.ModelDinosaur;
import org.jurassicraft.common.dinosaur.Dinosaur;
import org.jurassicraft.common.entity.base.EntityDinosaur;
import org.jurassicraft.common.entity.base.EnumGrowthStage;

@SideOnly(value=Side.CLIENT)
public abstract class DinosaurAnimator
implements IModelAnimator {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(DinosaurRenderDefDTO.class, (Object)new DinosaurRenderDefDTO.DinosaurDeserializer()).create();
    private Map<EnumGrowthStage, PreloadedModelData> modelData;
    protected Map<Integer, Map<EnumGrowthStage, JabelarAnimationHelper>> entityIDToAnimation = new HashMap<Integer, Map<EnumGrowthStage, JabelarAnimationHelper>>();
    private float partialTick;

    public static EnumMap<AnimID, int[][]> newEmptyMap() {
        return new EnumMap<AnimID, int[][]>(AnimID.class);
    }

    public DinosaurAnimator(Dinosaur dino) {
        URI dinoDirURI;
        String name = dino.getName().toLowerCase();
        this.modelData = new EnumMap<EnumGrowthStage, PreloadedModelData>(EnumGrowthStage.class);
        try {
            dinoDirURI = new URI("/assets/jurassicraft/models/entities/" + name + "/");
        }
        catch (URISyntaxException urise) {
            JurassiCraft.instance.getLogger().fatal("Illegal URI /assets/jurassicraft/models/entities/" + name + "/", (Throwable)urise);
            return;
        }
        for (EnumGrowthStage growth : EnumGrowthStage.values()) {
            try {
                EnumGrowthStage fileGrowthStage = growth;
                if (!dino.useAllGrowthStages()) {
                    if (growth == EnumGrowthStage.ADOLESCENT) {
                        fileGrowthStage = EnumGrowthStage.ADULT;
                    } else if (growth == EnumGrowthStage.JUVENILE) {
                        fileGrowthStage = EnumGrowthStage.INFANT;
                    }
                }
                this.modelData.put(growth, DinosaurAnimator.loadDinosaur(dinoDirURI, name, fileGrowthStage));
            }
            catch (Exception e) {
                JurassiCraft.instance.getLogger().fatal("Failed to parse growth state " + (Object)((Object)growth) + " for dinosaur " + name, (Throwable)e);
                this.modelData.put(growth, new PreloadedModelData());
            }
        }
    }

    private static PreloadedModelData loadDinosaur(URI dinoDir, String name, EnumGrowthStage growth) throws IOException {
        String growthName = growth.name().toLowerCase(Locale.ROOT);
        URI growthSensitiveDir = dinoDir.resolve(growthName + "/");
        URI definitionFile = growthSensitiveDir.resolve(name + "_" + growthName + ".json");
        InputStream dinoDef = Unilib.class.getResourceAsStream(definitionFile.toString());
        if (dinoDef == null) {
            throw new IllegalArgumentException("No model definition for the dino " + name + " with grow-state " + (Object)((Object)growth) + " exists. Expected at " + definitionFile);
        }
        try (InputStreamReader reader = new InputStreamReader(dinoDef);){
            AnimationsDTO rawAnimations = (AnimationsDTO)GSON.fromJson((Reader)reader, AnimationsDTO.class);
            PreloadedModelData data = DinosaurAnimator.getPosedModels(growthSensitiveDir, rawAnimations);
            JurassiCraft.instance.getLogger().debug("Successfully loaded " + name + "(" + (Object)((Object)growth) + ") from " + definitionFile);
            ((Reader)reader).close();
            PreloadedModelData preloadedModelData = data;
            return preloadedModelData;
        }
    }

    private static PreloadedModelData getPosedModels(URI dinoDirURI, AnimationsDTO anims) {
        if (anims == null || anims.poses == null || anims.poses.get(AnimID.IDLE.name()) == null || anims.poses.get(AnimID.IDLE.name()).length == 0) {
            throw new IllegalArgumentException("Animation files must define at least one pose for the IDLE animation");
        }
        ArrayList<String> posedModelResources = new ArrayList<String>();
        for (PoseDTO[] poses : anims.poses.values()) {
            if (poses == null) continue;
            for (PoseDTO pose : poses) {
                if (pose == null) continue;
                if (pose.pose == null) {
                    throw new IllegalArgumentException("Every pose must define a pose file");
                }
                String resolvedRes = DinosaurAnimator.resolve(dinoDirURI, pose.pose);
                int index = posedModelResources.indexOf(resolvedRes);
                if (index == -1) {
                    pose.index = posedModelResources.size();
                    posedModelResources.add(resolvedRes);
                    continue;
                }
                pose.index = index;
            }
        }
        assert (posedModelResources.size() > 0);
        MowzieModelRenderer[][] posedCubes = new MowzieModelRenderer[posedModelResources.size()][];
        EnumMap<AnimID, int[][]> animationSequences = DinosaurAnimator.newEmptyMap();
        ModelDinosaur mainModel = JabelarAnimationHelper.getTabulaModel((String)posedModelResources.get(0), 0);
        if (mainModel == null) {
            throw new IllegalArgumentException("Couldn't load the model from " + (String)posedModelResources.get(0));
        }
        String[] cubeNameArray = mainModel.getCubeNamesArray();
        int numParts = cubeNameArray.length;
        for (int i = 0; i < posedModelResources.size(); ++i) {
            String resource = (String)posedModelResources.get(i);
            ModelDinosaur theModel = JabelarAnimationHelper.getTabulaModel(resource, 0);
            if (theModel == null) {
                throw new IllegalArgumentException("Couldn't load the model from " + resource);
            }
            MowzieModelRenderer[] cubes = new MowzieModelRenderer[numParts];
            for (int partIndex = 0; partIndex < numParts; ++partIndex) {
                String cubeName = cubeNameArray[partIndex];
                MowzieModelRenderer cube = theModel.getCube(cubeName);
                if (cube == null) {
                    throw new IllegalArgumentException("Could not retrieve cube " + cubeName + " (" + partIndex + ") from the model " + resource);
                }
                cubes[partIndex] = cube;
            }
            posedCubes[i] = cubes;
        }
        for (Map.Entry<String, PoseDTO[]> entry : anims.poses.entrySet()) {
            AnimID animID = AnimID.valueOf(entry.getKey());
            PoseDTO[] poses = entry.getValue();
            int[][] poseSequence = new int[poses.length][2];
            for (int i = 0; i < poses.length; ++i) {
                poseSequence[i][0] = poses[i].index;
                poseSequence[i][1] = poses[i].time;
            }
            animationSequences.put(animID, poseSequence);
        }
        return new PreloadedModelData(posedCubes, animationSequences);
    }

    private static String resolve(URI dinoDirURI, String posePath) {
        URI uri = dinoDirURI.resolve(posePath);
        return uri.toString();
    }

    private JabelarAnimationHelper getAnimationHelper(EntityDinosaur entity, ModelDinosaur model) {
        JabelarAnimationHelper render;
        Integer id = entity.func_145782_y();
        EnumGrowthStage growth = entity.getGrowthStage();
        Map<EnumGrowthStage, JabelarAnimationHelper> growthToRender = this.entityIDToAnimation.get(id);
        if (growthToRender == null) {
            growthToRender = new EnumMap<EnumGrowthStage, JabelarAnimationHelper>(EnumGrowthStage.class);
            this.entityIDToAnimation.put(id, growthToRender);
        }
        if ((render = growthToRender.get((Object)growth)) == null) {
            PreloadedModelData growthModel = this.modelData.get((Object)growth);
            int cubes = growthModel.models.length > 0 ? growthModel.models[0].length : 0;
            render = new JabelarAnimationHelper(entity, model, cubes, growthModel.models, growthModel.animations, true);
            growthToRender.put(growth, render);
        }
        return render;
    }

    @Override
    public final void setRotationAngles(ModelJson model, float limbSwing, float limbSwingAmount, float rotation, float rotationYaw, float rotationPitch, Entity entity) {
        ModelDinosaur theModel = (ModelDinosaur)model;
        EntityDinosaur theEntity = (EntityDinosaur)entity;
        this.setRotationAngles(theModel, limbSwing, limbSwingAmount, rotation, rotationYaw, rotationPitch, this.partialTick, theEntity);
    }

    @Override
    public void preRenderCallback(EntityLivingBase entity, float partialTicks) {
        this.partialTick = partialTicks;
    }

    protected void setRotationAngles(ModelDinosaur model, float limbSwing, float limbSwingAmount, float rotation, float rotationYaw, float rotationPitch, float partialTick, EntityDinosaur entity) {
        this.getAnimationHelper(entity, model).performJabelarAnimations(partialTick);
        if (entity.getAnimID() != AnimID.DYING) {
            if (entity.isSwimming()) {
                this.performMowzieSwimmingAnimations(model, limbSwing, limbSwingAmount, rotation, rotationYaw, rotationPitch, partialTick, entity);
            } else {
                this.performMowzieLandAnimations(model, limbSwing, limbSwingAmount, rotation, rotationYaw, rotationPitch, partialTick, entity);
            }
        }
    }

    protected void performMowzieLandAnimations(ModelDinosaur parModel, float parLimbSwing, float parLimbSwingAmount, float parRotation, float parRotationYaw, float parRotationPitch, float parPartialTicks, EntityDinosaur parEntity) {
    }

    protected void performMowzieSwimmingAnimations(ModelDinosaur parModel, float parLimbSwing, float parLimbSwingAmount, float parRotation, float parRotationYaw, float parRotationPitch, float parPartialTicks, EntityDinosaur parEntity) {
        this.performMowzieLandAnimations(parModel, parLimbSwing, parLimbSwingAmount, parRotation, parRotationYaw, parRotationPitch, parPartialTicks, parEntity);
    }

    private static class PreloadedModelData {
        MowzieModelRenderer[][] models;
        Map<AnimID, int[][]> animations;

        public PreloadedModelData() {
            this(null, null);
        }

        public PreloadedModelData(MowzieModelRenderer[][] renderers, Map<AnimID, int[][]> animations) {
            if (renderers == null) {
                renderers = new MowzieModelRenderer[][]{};
            }
            if (animations == null) {
                animations = DinosaurAnimator.newEmptyMap();
            }
            this.models = renderers;
            this.animations = animations;
        }
    }
}

