/*
 * Decompiled with CFR 0.152.
 */
package net.timeless.animationapi.client;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.EntityNotFoundException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerSelector;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.timeless.animationapi.AnimationAPI;
import net.timeless.animationapi.client.AnimID;
import org.jurassicraft.JurassiCraft;
import org.jurassicraft.common.entity.base.EntityDinosaur;

public class CommandForceAnimation
implements ICommand {
    private final List<String> aliases = new ArrayList<String>();

    public CommandForceAnimation() {
        this.aliases.add("animate");
        this.aliases.add("anim");
    }

    public int compareTo(ICommand o) {
        return 0;
    }

    public String func_71517_b() {
        return "animate";
    }

    public String func_71518_a(ICommandSender parSender) {
        return "animate <AnimID> [<entitySelector>]";
    }

    public List<String> func_71514_a() {
        return this.aliases;
    }

    public void func_71515_b(ICommandSender parSender, String[] argString) throws CommandException {
        World theWorld = parSender.func_130014_f_();
        if (theWorld.field_72995_K) {
            JurassiCraft.instance.getLogger().debug("Not processing on Client side");
        } else {
            JurassiCraft.instance.getLogger().debug("Processing on Server side");
            if (argString.length < 1) {
                throw new WrongUsageException("Missing the animation to set", new Object[0]);
            }
            String entitySelector = argString.length < 2 ? "@e[c=1]" : argString[1];
            List dinos = PlayerSelector.func_179656_b((ICommandSender)new ProxySender(parSender), (String)entitySelector, EntityDinosaur.class);
            if (dinos == null || dinos.size() == 0) {
                throw new EntityNotFoundException("No IAnimatedEntity to animate", new Object[0]);
            }
            for (EntityDinosaur entity : dinos) {
                CommandForceAnimation.setDinoAnimation(parSender, entity, argString[0]);
                parSender.func_145747_a((IChatComponent)new ChatComponentText("Animating entity " + entity.func_145782_y() + " with animation type " + argString[0]));
            }
        }
    }

    public boolean func_71519_b(ICommandSender sender) {
        return true;
    }

    public boolean func_82358_a(String[] var1, int var2) {
        return false;
    }

    public List func_180525_a(ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            ArrayList animations = Lists.newArrayList();
            String current = args[0].toLowerCase();
            for (AnimID animation : AnimID.values()) {
                if (!animation.name().toLowerCase().startsWith(current)) continue;
                animations.add(animation.name());
            }
            return animations;
        }
        return null;
    }

    private static void setDinoAnimation(ICommandSender sender, EntityDinosaur entity, String parAnimType) throws CommandException {
        try {
            AnimID animation = AnimID.valueOf(parAnimType.toUpperCase());
            AnimationAPI.sendAnimPacket(entity, animation);
        }
        catch (IllegalArgumentException iae) {
            throw new CommandException(parAnimType + " is not a valid animation.", new Object[0]);
        }
    }

    private static class ProxySender
    implements ICommandSender {
        private final ICommandSender original;

        public ProxySender(ICommandSender proxy) {
            this.original = Objects.requireNonNull(proxy);
        }

        public void func_145747_a(IChatComponent component) {
            this.original.func_145747_a(component);
        }

        public boolean func_70003_b(int permLevel, String commandName) {
            if (commandName.equals("@")) {
                return true;
            }
            return this.original.func_70003_b(permLevel, commandName);
        }

        public Entity func_174793_f() {
            return this.original.func_174793_f();
        }

        public String func_70005_c_() {
            return this.original.func_70005_c_();
        }

        public IChatComponent func_145748_c_() {
            return this.original.func_145748_c_();
        }

        public World func_130014_f_() {
            return this.original.func_130014_f_();
        }

        public BlockPos func_180425_c() {
            return this.original.func_180425_c();
        }

        public Vec3 func_174791_d() {
            return this.original.func_174791_d();
        }

        public boolean func_174792_t_() {
            return this.original.func_174792_t_();
        }

        public void func_174794_a(CommandResultStats.Type type, int amount) {
            this.original.func_174794_a(type, amount);
        }
    }
}

