/*
 * Decompiled with CFR 0.152.
 */
package net.timeless.animationapi.client;

import java.util.HashMap;
import net.minecraft.util.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.timeless.animationapi.AnimationAPI;
import net.timeless.animationapi.IAnimatedEntity;
import net.timeless.animationapi.client.AnimID;
import net.timeless.animationapi.client.Transform;
import net.timeless.unilib.client.model.tools.MowzieModelBase;
import net.timeless.unilib.client.model.tools.MowzieModelRenderer;

@SideOnly(value=Side.CLIENT)
public class Animator {
    private MowzieModelBase modelBase;
    private int tempTick = 0;
    private int prevTempTick;
    private boolean correctAnim = false;
    private IAnimatedEntity animEntity;
    private HashMap<MowzieModelRenderer, Transform> transformMap = new HashMap();
    private HashMap<MowzieModelRenderer, Transform> prevTransformMap = new HashMap();
    public static final float PI = (float)Math.PI;

    public Animator(MowzieModelBase model) {
        this.modelBase = model;
    }

    public IAnimatedEntity getEntity() {
        return this.animEntity;
    }

    public void update(IAnimatedEntity entity) {
        this.prevTempTick = 0;
        this.tempTick = 0;
        this.correctAnim = false;
        this.animEntity = entity;
        this.transformMap.clear();
        this.prevTransformMap.clear();
    }

    public boolean setAnim(AnimID animID) {
        this.prevTempTick = 0;
        this.tempTick = 0;
        this.correctAnim = this.animEntity.getAnimID() == animID;
        return this.correctAnim;
    }

    public void startPhase(int duration) {
        if (!this.correctAnim) {
            return;
        }
        this.prevTempTick = this.tempTick;
        this.tempTick += duration;
    }

    public void setStationaryPhase(int duration) {
        this.startPhase(duration);
        this.endPhase(true);
    }

    public void resetPhase(int duration) {
        this.startPhase(duration);
        this.endPhase();
    }

    public void rotate(MowzieModelRenderer box, float x, float y, float z) {
        if (!this.correctAnim) {
            return;
        }
        if (!this.transformMap.containsKey((Object)box)) {
            this.transformMap.put(box, new Transform(x, y, z));
        } else {
            this.transformMap.get((Object)box).addRot(x, y, z);
        }
    }

    public void move(MowzieModelRenderer box, float x, float y, float z) {
        if (!this.correctAnim) {
            return;
        }
        if (!this.transformMap.containsKey((Object)box)) {
            this.transformMap.put(box, new Transform(x, y, z, 0.0f, 0.0f, 0.0f));
        } else {
            this.transformMap.get((Object)box).addOffset(x, y, z);
        }
    }

    public void endPhase() {
        this.endPhase(false);
    }

    private void endPhase(boolean stationary) {
        if (!this.correctAnim) {
            return;
        }
        int animTick = this.animEntity.getAnimTick();
        if (animTick >= this.prevTempTick && animTick < this.tempTick) {
            if (stationary) {
                for (MowzieModelRenderer box : this.prevTransformMap.keySet()) {
                    Transform transform = this.prevTransformMap.get((Object)box);
                    box.field_78795_f += transform.rotX;
                    box.field_78796_g += transform.rotY;
                    box.field_78808_h += transform.rotZ;
                    box.field_78800_c += transform.offsetX;
                    box.field_78797_d += transform.offsetY;
                    box.field_78798_e += transform.offsetZ;
                }
            } else {
                Transform transform;
                float tick = ((float)(animTick - this.prevTempTick) + AnimationAPI.getProxy().getPartialTick()) / (float)(this.tempTick - this.prevTempTick);
                float inc = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
                float dec = 1.0f - inc;
                for (MowzieModelRenderer box : this.prevTransformMap.keySet()) {
                    transform = this.prevTransformMap.get((Object)box);
                    box.field_78795_f += dec * transform.rotX;
                    box.field_78796_g += dec * transform.rotY;
                    box.field_78808_h += dec * transform.rotZ;
                    box.field_78800_c += dec * transform.offsetX;
                    box.field_78797_d += dec * transform.offsetY;
                    box.field_78798_e += dec * transform.offsetZ;
                }
                for (MowzieModelRenderer box : this.transformMap.keySet()) {
                    transform = this.transformMap.get((Object)box);
                    box.field_78795_f += inc * transform.rotX;
                    box.field_78796_g += inc * transform.rotY;
                    box.field_78808_h += inc * transform.rotZ;
                    box.field_78800_c += inc * transform.offsetX;
                    box.field_78797_d += inc * transform.offsetY;
                    box.field_78798_e += inc * transform.offsetZ;
                }
            }
        }
        if (!stationary) {
            this.prevTransformMap.clear();
            this.prevTransformMap.putAll(this.transformMap);
            this.transformMap.clear();
        }
    }
}

