/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.proxy;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.jurassicraft.JurassiCraft;
import org.jurassicraft.server.achievements.AchievementHandler;
import org.jurassicraft.server.block.BlockHandler;
import org.jurassicraft.server.block.entity.CleaningStationBlockEntity;
import org.jurassicraft.server.block.entity.CultivatorBlockEntity;
import org.jurassicraft.server.block.entity.DNACombinatorHybridizerBlockEntity;
import org.jurassicraft.server.block.entity.DNAExtractorBlockEntity;
import org.jurassicraft.server.block.entity.DNASequencerBlockEntity;
import org.jurassicraft.server.block.entity.DNASynthesizerBlockEntity;
import org.jurassicraft.server.block.entity.EmbryoCalcificationMachineBlockEntity;
import org.jurassicraft.server.block.entity.EmbryonicMachineBlockEntity;
import org.jurassicraft.server.block.entity.FeederBlockEntity;
import org.jurassicraft.server.block.entity.FossilGrinderBlockEntity;
import org.jurassicraft.server.block.entity.IncubatorBlockEntity;
import org.jurassicraft.server.container.CleaningStationContainer;
import org.jurassicraft.server.container.CultivateContainer;
import org.jurassicraft.server.container.DNACombinatorHybridizerContainer;
import org.jurassicraft.server.container.DNAExtractorContainer;
import org.jurassicraft.server.container.DNASequencerContainer;
import org.jurassicraft.server.container.DNASynthesizerContainer;
import org.jurassicraft.server.container.EmbryoCalcificationMachineContainer;
import org.jurassicraft.server.container.EmbryonicMachineContainer;
import org.jurassicraft.server.container.FeederContainer;
import org.jurassicraft.server.container.FossilGrinderContainer;
import org.jurassicraft.server.container.IncubatorContainer;
import org.jurassicraft.server.entity.DinosaurEntity;
import org.jurassicraft.server.entity.DinosaurSerializers;
import org.jurassicraft.server.entity.EntityHandler;
import org.jurassicraft.server.event.ServerEventHandler;
import org.jurassicraft.server.food.FoodHelper;
import org.jurassicraft.server.genetics.StorageTypeRegistry;
import org.jurassicraft.server.item.ItemHandler;
import org.jurassicraft.server.item.bones.FossilItem;
import org.jurassicraft.server.plant.PlantHandler;
import org.jurassicraft.server.recipe.RecipeHandler;
import org.jurassicraft.server.world.WorldGenerator;

public class ServerProxy
implements IGuiHandler {
    public static final int GUI_CLEANING_STATION_ID = 0;
    public static final int GUI_FOSSIL_GRINDER_ID = 1;
    public static final int GUI_DNA_SEQUENCER_ID = 2;
    public static final int GUI_EMBRYONIC_MACHINE_ID = 3;
    public static final int GUI_EMBRYO_CALCIFICATION_MACHINE_ID = 4;
    public static final int GUI_DNA_SYNTHESIZER_ID = 5;
    public static final int GUI_INCUBATOR_ID = 6;
    public static final int GUI_DNA_COMBINATOR_HYBRIDIZER_ID = 7;
    public static final int GUI_DNA_EXTRACTOR_ID = 8;
    public static final int GUI_CULTIVATOR_ID = 9;
    public static final int GUI_FEEDER_ID = 10;

    public void preInit(FMLPreInitializationEvent event) {
        EntityHandler.init();
        DinosaurSerializers.register();
        FossilItem.init();
        PlantHandler.init();
        BlockHandler.init();
        ItemHandler.init();
        RecipeHandler.init();
        AchievementHandler.init();
        StorageTypeRegistry.init();
        GameRegistry.registerWorldGenerator((IWorldGenerator)WorldGenerator.INSTANCE, (int)0);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)JurassiCraft.INSTANCE, (IGuiHandler)this);
        ServerEventHandler eventHandler = new ServerEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)eventHandler);
    }

    public void postInit(FMLPostInitializationEvent event) {
        FoodHelper.init();
    }

    public void init(FMLInitializationEvent event) {
    }

    public EntityPlayer getPlayer() {
        return null;
    }

    public EntityPlayer getPlayerEntityFromContext(MessageContext ctx) {
        return ctx.getServerHandler().field_147369_b;
    }

    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null) {
            if (tileEntity instanceof CleaningStationBlockEntity && id == 0) {
                return new CleaningStationContainer(player.field_71071_by, (IInventory)((CleaningStationBlockEntity)tileEntity));
            }
            if (tileEntity instanceof FossilGrinderBlockEntity && id == 1) {
                return new FossilGrinderContainer(player.field_71071_by, tileEntity);
            }
            if (tileEntity instanceof DNASequencerBlockEntity && id == 2) {
                return new DNASequencerContainer(player.field_71071_by, tileEntity);
            }
            if (tileEntity instanceof EmbryonicMachineBlockEntity && id == 3) {
                return new EmbryonicMachineContainer(player.field_71071_by, tileEntity);
            }
            if (tileEntity instanceof EmbryoCalcificationMachineBlockEntity && id == 4) {
                return new EmbryoCalcificationMachineContainer(player.field_71071_by, tileEntity);
            }
            if (tileEntity instanceof DNASynthesizerBlockEntity && id == 5) {
                return new DNASynthesizerContainer(player.field_71071_by, tileEntity);
            }
            if (tileEntity instanceof IncubatorBlockEntity && id == 6) {
                return new IncubatorContainer(player.field_71071_by, tileEntity);
            }
            if (tileEntity instanceof DNACombinatorHybridizerBlockEntity && id == 7) {
                return new DNACombinatorHybridizerContainer(player.field_71071_by, tileEntity);
            }
            if (tileEntity instanceof DNAExtractorBlockEntity && id == 8) {
                return new DNAExtractorContainer(player.field_71071_by, tileEntity);
            }
            if (tileEntity instanceof CultivatorBlockEntity && id == 9) {
                return new CultivateContainer(player.field_71071_by, tileEntity);
            }
            if (tileEntity instanceof FeederBlockEntity && id == 10) {
                return new FeederContainer(player.field_71071_by, (FeederBlockEntity)tileEntity);
            }
        }
        return null;
    }

    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    public void openSelectDino(BlockPos pos, EnumFacing facing, EnumHand hand) {
    }

    public void openOrderGui(DinosaurEntity entity) {
    }

    public void openFieldGuide(DinosaurEntity entity, DinosaurEntity.FieldGuideInfo fieldGuideInfo) {
    }
}

