/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.genetics;

import java.util.List;
import java.util.Locale;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import org.jurassicraft.server.dinosaur.Dinosaur;
import org.jurassicraft.server.entity.EntityHandler;
import org.jurassicraft.server.util.LangHelper;

public class DinoDNA {
    private int quality;
    private String genetics;
    private Dinosaur dinosaur;

    public DinoDNA(Dinosaur dinosaur, int quality, String genetics) {
        this.quality = quality;
        this.genetics = genetics;
        this.dinosaur = dinosaur;
    }

    public static DinoDNA fromStack(ItemStack stack) {
        return DinoDNA.readFromNBT(stack.func_77978_p());
    }

    public static DinoDNA readFromNBT(NBTTagCompound nbt) {
        return new DinoDNA(EntityHandler.getDinosaurById(nbt.func_74762_e("Dinosaur")), nbt.func_74762_e("DNAQuality"), nbt.func_74779_i("Genetics"));
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("DNAQuality", this.quality);
        nbt.func_74778_a("Genetics", this.genetics);
        nbt.func_74778_a("StorageId", "DinoDNA");
        nbt.func_74768_a("Dinosaur", EntityHandler.getDinosaurId(this.dinosaur));
    }

    public int getDNAQuality() {
        return this.quality;
    }

    public String getGenetics() {
        return this.genetics;
    }

    public void addInformation(ItemStack stack, List<String> tooltip) {
        tooltip.add(TextFormatting.DARK_AQUA + new LangHelper("lore.dinosaur.name").withProperty("dino", "entity.jurassicraft." + this.dinosaur.getName().toLowerCase(Locale.ENGLISH) + ".name").build());
        TextFormatting colour = this.quality > 75 ? TextFormatting.GREEN : (this.quality > 50 ? TextFormatting.YELLOW : (this.quality > 25 ? TextFormatting.GOLD : TextFormatting.RED));
        tooltip.add(colour + new LangHelper("lore.dna_quality.name").withProperty("quality", this.quality + "").build());
        tooltip.add(TextFormatting.BLUE + new LangHelper("lore.genetic_code.name").withProperty("code", this.genetics).build());
    }

    public Dinosaur getDinosaur() {
        return this.dinosaur;
    }
}

