/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.food;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import org.jurassicraft.server.block.BlockHandler;
import org.jurassicraft.server.block.tree.TreeType;
import org.jurassicraft.server.entity.Diet;
import org.jurassicraft.server.entity.DinosaurEntity;
import org.jurassicraft.server.food.FoodType;
import org.jurassicraft.server.item.ItemHandler;
import org.jurassicraft.server.plant.Plant;
import org.jurassicraft.server.plant.PlantHandler;

public class FoodHelper {
    private static final Map<FoodType, List<Item>> FOOD_TYPES = new HashMap<FoodType, List<Item>>();
    private static final List<Item> FOODS = new LinkedList<Item>();
    private static final Map<Item, Integer> HEAL_AMOUNTS = new HashMap<Item, Integer>();
    private static final Map<Item, FoodEffect[]> FOOD_EFFECTS = new HashMap<Item, FoodEffect[]>();

    public static void init() {
        FoodHelper.registerFood((Block)Blocks.field_150362_t, FoodType.PLANT, 2000, new FoodEffect[0]);
        FoodHelper.registerFood((Block)Blocks.field_150361_u, FoodType.PLANT, 2000, new FoodEffect[0]);
        FoodHelper.registerFood((Block)Blocks.field_150329_H, FoodType.PLANT, 1000, new FoodEffect[0]);
        FoodHelper.registerFood(Blocks.field_150464_aj, FoodType.PLANT, 2000, new FoodEffect[0]);
        FoodHelper.registerFood(Blocks.field_150440_ba, FoodType.PLANT, 3000, new FoodEffect[0]);
        FoodHelper.registerFood((Block)Blocks.field_150436_aH, FoodType.PLANT, 1000, new FoodEffect[0]);
        FoodHelper.registerFood(Blocks.field_150345_g, FoodType.PLANT, 1000, new FoodEffect[0]);
        FoodHelper.registerFood(Blocks.field_150423_aK, FoodType.PLANT, 3000, new FoodEffect[0]);
        FoodHelper.registerFood(Blocks.field_150459_bM, FoodType.PLANT, 2000, new FoodEffect[0]);
        FoodHelper.registerFood(Blocks.field_150469_bN, FoodType.PLANT, 2000, new FoodEffect[0]);
        FoodHelper.registerFood(Blocks.field_150407_cf, FoodType.PLANT, 5000, new FoodEffect[0]);
        FoodHelper.registerFood(Blocks.field_150392_bi, FoodType.PLANT, 500, new FoodEffect[0]);
        FoodHelper.registerFood((Block)Blocks.field_150327_N, FoodType.PLANT, 500, new FoodEffect[0]);
        FoodHelper.registerFood((Block)Blocks.field_150328_O, FoodType.PLANT, 500, new FoodEffect[0]);
        FoodHelper.registerFood((Block)Blocks.field_150398_cm, FoodType.PLANT, 2000, new FoodEffect[0]);
        FoodHelper.registerFood((Block)Blocks.field_150338_P, FoodType.PLANT, 250, new FoodEffect[0]);
        FoodHelper.registerFood((Block)Blocks.field_150337_Q, FoodType.PLANT, 250, new FoodEffect[0]);
        FoodHelper.registerFood((Block)BlockHandler.PALEO_BALE_CYCADEOIDEA, FoodType.PLANT, 5000, new FoodEffect[0]);
        FoodHelper.registerFood((Block)BlockHandler.PALEO_BALE_CYCAD, FoodType.PLANT, 5000, new FoodEffect[0]);
        FoodHelper.registerFood((Block)BlockHandler.PALEO_BALE_FERN, FoodType.PLANT, 5000, new FoodEffect[0]);
        FoodHelper.registerFood((Block)BlockHandler.PALEO_BALE_LEAVES, FoodType.PLANT, 5000, new FoodEffect[0]);
        FoodHelper.registerFood((Block)BlockHandler.PALEO_BALE_OTHER, FoodType.PLANT, 5000, new FoodEffect[0]);
        for (Plant plant : PlantHandler.getPlants()) {
            FoodHelper.registerFood(plant.getBlock(), FoodType.PLANT, plant.getHealAmount(), plant.getEffects());
        }
        for (TreeType type : TreeType.values()) {
            FoodHelper.registerFood((Block)BlockHandler.ANCIENT_LEAVES.get((Object)type), FoodType.PLANT, 2000, new FoodEffect[0]);
            FoodHelper.registerFood((Block)BlockHandler.ANCIENT_SAPLINGS.get((Object)type), FoodType.PLANT, 1000, new FoodEffect[0]);
        }
        FoodHelper.registerFood(Items.field_151015_O, FoodType.PLANT, 1000, new FoodEffect[0]);
        FoodHelper.registerFood(Items.field_151014_N, FoodType.PLANT, 100, new FoodEffect[0]);
        FoodHelper.registerFood(Items.field_151081_bc, FoodType.PLANT, 100, new FoodEffect[0]);
        FoodHelper.registerFood(Items.field_151080_bb, FoodType.PLANT, 100, new FoodEffect[0]);
        FoodHelper.registerFoodAuto((ItemFood)Items.field_151115_aP, FoodType.FISH, new FoodEffect[0]);
        FoodHelper.registerFoodAuto((ItemFood)Items.field_179566_aV, FoodType.FISH, new FoodEffect[0]);
        FoodHelper.registerFoodAuto(ItemHandler.DINOSAUR_MEAT, FoodType.MEAT, new FoodEffect[0]);
        FoodHelper.registerFoodAuto(ItemHandler.DINOSAUR_STEAK, FoodType.MEAT, new FoodEffect[0]);
        for (Item item : Item.field_150901_e) {
            ItemFood food;
            if (!(item instanceof ItemFood)) continue;
            FoodHelper.registerFoodAuto(food, (food = (ItemFood)item).func_77845_h() ? FoodType.MEAT : FoodType.PLANT, new FoodEffect[0]);
        }
    }

    public static void registerFoodAuto(ItemFood food, FoodType foodType, FoodEffect ... effects) {
        FoodHelper.registerFood((Item)food, foodType, food.func_150905_g(new ItemStack((Item)food)) * 650, effects);
    }

    public static void registerFood(Item food, FoodType foodType, int healAmount, FoodEffect ... effects) {
        if (!FOODS.contains(food)) {
            List<Item> foodsForType = FOOD_TYPES.get((Object)foodType);
            if (foodsForType == null) {
                foodsForType = new ArrayList<Item>();
            }
            foodsForType.add(food);
            FOODS.add(food);
            FOOD_TYPES.put(foodType, foodsForType);
            HEAL_AMOUNTS.put(food, healAmount);
            FOOD_EFFECTS.put(food, effects);
        }
    }

    public static void registerFood(Block food, FoodType foodType, int foodAmount, FoodEffect ... effects) {
        FoodHelper.registerFood(Item.func_150898_a((Block)food), foodType, foodAmount, effects);
    }

    public static List<Item> getFoodType(FoodType type) {
        return FOOD_TYPES.get((Object)type);
    }

    public static FoodType getFoodType(Item item) {
        for (FoodType foodType : FoodType.values()) {
            if (!FoodHelper.getFoodType(foodType).contains(item)) continue;
            return foodType;
        }
        return null;
    }

    public static FoodType getFoodType(Block block) {
        return FoodHelper.getFoodType(Item.func_150898_a((Block)block));
    }

    public static boolean isEdible(Diet diet, Item item) {
        return item != null && FoodHelper.getEdibleFoods(diet).contains(item);
    }

    public static boolean isEdible(Diet diet, Block block) {
        return FoodHelper.isEdible(diet, Item.func_150898_a((Block)block));
    }

    public static List<Item> getEdibleFoods(Diet diet) {
        ArrayList<Item> possibleItems = new ArrayList<Item>();
        if (diet.isHerbivorous()) {
            possibleItems.addAll(FoodHelper.getFoodType(FoodType.PLANT));
        }
        if (diet.isPiscivorous()) {
            possibleItems.addAll(FoodHelper.getFoodType(FoodType.FISH));
        }
        if (diet.isCarnivorous()) {
            possibleItems.addAll(FoodHelper.getFoodType(FoodType.MEAT));
        }
        return possibleItems;
    }

    public static int getHealAmount(Item item) {
        return HEAL_AMOUNTS.get(item);
    }

    public static void applyEatEffects(DinosaurEntity entity, Item item) {
        FoodEffect[] effects = FOOD_EFFECTS.get(item);
        if (effects != null) {
            for (FoodEffect effect : effects) {
                if (entity.func_70681_au().nextInt(100) > effect.chance) continue;
                entity.func_70690_d(effect.effect);
            }
        }
    }

    public static class FoodEffect {
        public PotionEffect effect;
        public int chance;

        public FoodEffect(PotionEffect effect, int chance) {
            this.effect = effect;
            this.chance = chance;
        }
    }
}

