/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.entity.ai.metabolism;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jurassicraft.client.model.animation.DinosaurAnimation;
import org.jurassicraft.server.entity.DinosaurEntity;
import org.jurassicraft.server.entity.MetabolismContainer;
import org.jurassicraft.server.util.GameRuleHandler;

public class DrinkEntityAI
extends EntityAIBase {
    protected DinosaurEntity dinosaur;
    protected Path path;
    protected BlockPos pos;
    protected int giveUpTime;

    public DrinkEntityAI(DinosaurEntity dinosaur) {
        this.dinosaur = dinosaur;
    }

    public boolean func_75250_a() {
        if (!this.dinosaur.field_70128_L && !this.dinosaur.isCarcass() && this.dinosaur.field_70173_aa % 4 == 0 && GameRuleHandler.DINO_METABOLISM.getBoolean(this.dinosaur.field_70170_p) && this.dinosaur.getMetabolism().isThirsty()) {
            int posX = (int)this.dinosaur.field_70165_t;
            int posY = (int)this.dinosaur.field_70163_u;
            int posZ = (int)this.dinosaur.field_70161_v;
            int closestDistance = Integer.MAX_VALUE;
            BlockPos closestPos = null;
            World world = this.dinosaur.field_70170_p;
            int range = 32;
            for (int x = posX - range; x < posX + range; ++x) {
                for (int y = posY - range; y < posY + range; ++y) {
                    for (int z = posZ - range; z < posZ + range; ++z) {
                        Block block = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
                        if (block != Blocks.field_150355_j && block != Blocks.field_150358_i) continue;
                        for (int landX = x - 1; landX < x + 1; ++landX) {
                            for (int landZ = z - 1; landZ < z + 1; ++landZ) {
                                int diffZ;
                                int diffY;
                                int diffX;
                                int distance;
                                IBlockState state = world.func_180495_p(new BlockPos(landX, y, landZ));
                                if (!state.func_185914_p() || (distance = (diffX = Math.abs(posX - landX)) * diffX + (diffY = Math.abs(posY - y)) * diffY + (diffZ = Math.abs(posZ - landZ)) * diffZ) >= closestDistance) continue;
                                closestDistance = distance;
                                closestPos = new BlockPos(landX, y, landZ);
                            }
                        }
                    }
                }
            }
            if (closestPos != null) {
                this.pos = closestPos;
                this.path = this.dinosaur.func_70661_as().func_75488_a((double)closestPos.func_177958_n(), (double)closestPos.func_177956_o(), (double)closestPos.func_177952_p());
                this.giveUpTime = 500;
                return this.dinosaur.func_70661_as().func_75484_a(this.path, 1.0);
            }
        }
        return false;
    }

    public void func_75246_d() {
        --this.giveUpTime;
        if (this.giveUpTime <= 0) {
            this.func_75251_c();
            return;
        }
        this.dinosaur.func_70661_as().func_75484_a(this.path, 1.0);
        if (this.path.func_75879_b()) {
            if (this.dinosaur.getAnimation() != DinosaurAnimation.DRINKING.get()) {
                this.dinosaur.setAnimation(DinosaurAnimation.DRINKING.get());
            }
            MetabolismContainer metabolism = this.dinosaur.getMetabolism();
            metabolism.setWater(metabolism.getMaxWater());
        }
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.path = null;
        this.dinosaur.func_70661_as().func_75499_g();
    }

    public boolean func_75253_b() {
        Block block = this.dinosaur.field_70170_p.func_180495_p(this.pos).func_177230_c();
        return this.dinosaur != null && this.path != null && !this.dinosaur.func_70661_as().func_75500_f() && (block == Blocks.field_150355_j || block == Blocks.field_150358_i);
    }
}

