/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.entity.ai;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import org.jurassicraft.server.dinosaur.Dinosaur;
import org.jurassicraft.server.entity.DinosaurEntity;
import org.jurassicraft.server.util.GameRuleHandler;

public class Herd
implements Iterable<DinosaurEntity> {
    public List<DinosaurEntity> members = new LinkedList<DinosaurEntity>();
    public DinosaurEntity leader;
    private Vec3d center;
    private float moveX;
    private float moveZ;
    public State state = State.STATIC;
    public int stateTicks;
    private Random random = new Random();
    public List<EntityLivingBase> enemies = new ArrayList<EntityLivingBase>();
    public boolean fleeing;
    private Dinosaur herdType;

    public Herd(DinosaurEntity leader) {
        this.herdType = leader.getDinosaur();
        this.members.add(leader);
        this.leader = leader;
        this.resetStateTicks();
    }

    public void onUpdate() {
        if (this.leader == null || this.leader.isCarcass() || this.leader.field_70128_L) {
            this.updateLeader();
        }
        if (this.stateTicks > 0) {
            --this.stateTicks;
        } else {
            this.state = this.state == State.MOVING ? State.STATIC : State.MOVING;
            this.resetStateTicks();
            this.enemies.clear();
            this.fleeing = false;
        }
        if (this.leader != null) {
            if (this.leader.shouldSleep()) {
                this.state = State.STATIC;
                this.resetStateTicks();
            }
            this.center = this.getCenterPosition();
            if (this.enemies.size() > 0) {
                if (this.fleeing) {
                    this.state = State.MOVING;
                    float angle = 0.0f;
                    for (EntityLivingBase attacker : this.enemies) {
                        angle = (float)((double)angle + Math.atan2(this.center.field_72449_c - attacker.field_70161_v, this.center.field_72450_a - attacker.field_70165_t));
                    }
                    this.moveX = (float)(-Math.cos(angle /= (float)this.enemies.size()));
                    this.moveZ = (float)Math.sin(angle);
                    this.normalizeMovement();
                } else {
                    this.state = State.STATIC;
                }
            } else {
                this.fleeing = false;
            }
            LinkedList<DinosaurEntity> remove = new LinkedList<DinosaurEntity>();
            for (DinosaurEntity entity : this) {
                double distance = entity.func_70092_e(this.center.field_72450_a, this.center.field_72448_b, this.center.field_72449_c);
                if (!(distance > 2048.0)) continue;
                remove.add(entity);
            }
            for (DinosaurEntity entity : remove) {
                this.members.remove((Object)entity);
                entity.herd = null;
                if (entity != this.leader) continue;
                this.updateLeader();
            }
            if (this.leader == null) {
                return;
            }
            for (DinosaurEntity entity : this) {
                if (this.enemies.size() == 0 || this.fleeing) {
                    double speed;
                    if (entity.getMetabolism().isHungry() || entity.getMetabolism().isThirsty() || entity.func_70610_aX() || entity.func_70090_H() || !this.fleeing && !entity.func_70661_as().func_75500_f() || this.state != State.MOVING && this.random.nextInt(50) != 0) continue;
                    float entityMoveX = this.moveX * 2.0f;
                    float entityMoveZ = this.moveZ * 2.0f;
                    float centerDistance = (float)Math.abs(entity.func_70011_f(this.center.field_72450_a, entity.field_70163_u, this.center.field_72449_c));
                    if (this.fleeing) {
                        centerDistance *= 4.0f;
                    }
                    if (centerDistance > 0.0f) {
                        entityMoveX = (float)((double)entityMoveX + (this.center.field_72450_a - entity.field_70165_t) / (double)centerDistance);
                        entityMoveZ = (float)((double)entityMoveZ + (this.center.field_72449_c - entity.field_70161_v) / (double)centerDistance);
                    }
                    for (DinosaurEntity other : this) {
                        float separation;
                        float distance;
                        if (other == entity || !((distance = Math.abs(entity.func_70032_d((Entity)other))) < (separation = entity.field_70130_N * 1.5f + 1.5f))) continue;
                        float scale = distance / separation;
                        entityMoveX = (float)((double)entityMoveX + (entity.field_70165_t - other.field_70165_t) / (double)scale);
                        entityMoveZ = (float)((double)entityMoveZ + (entity.field_70161_v - other.field_70161_v) / (double)scale);
                    }
                    double navigateX = entity.field_70165_t + (double)entityMoveX;
                    double navigateZ = entity.field_70161_v + (double)entityMoveZ;
                    double d = speed = this.state == State.STATIC ? 0.8 : entity.getDinosaur().getFlockSpeed();
                    if (this.fleeing && entity.getDinosaur().getAttackSpeed() > speed) {
                        speed = entity.getDinosaur().getAttackSpeed();
                    }
                    entity.func_70661_as().func_75492_a(navigateX, (double)(entity.field_70170_p.func_175645_m(new BlockPos(navigateX, 0.0, navigateZ)).func_177956_o() + 1), navigateZ, speed);
                    continue;
                }
                if (this.fleeing || entity.func_70638_az() != null && this.random.nextInt(20) != 0 || this.enemies.size() <= 0 || entity.getAgePercentage() <= 50) continue;
                entity.func_70624_b(this.enemies.get(this.random.nextInt(this.enemies.size())));
            }
            LinkedList<EntityLivingBase> invalidEnemies = new LinkedList<EntityLivingBase>();
            for (EntityLivingBase enemy : this.enemies) {
                if (!(enemy.field_70128_L || enemy instanceof DinosaurEntity && ((DinosaurEntity)enemy).isCarcass() || enemy instanceof EntityPlayer && ((EntityPlayer)enemy).field_71075_bZ.field_75098_d || enemy.func_70092_e(this.center.field_72450_a, this.center.field_72448_b, this.center.field_72449_c) > 1024.0) && !this.members.contains(enemy)) continue;
                invalidEnemies.add(enemy);
            }
            this.enemies.removeAll(invalidEnemies);
            if (this.enemies.size() == 0) {
                this.fleeing = false;
                this.state = State.STATIC;
            }
            if (this.state == State.STATIC) {
                this.moveX = 0.0f;
                this.moveZ = 0.0f;
            } else {
                this.moveX += (this.random.nextFloat() - 0.5f) * 0.1f;
                this.moveZ += (this.random.nextFloat() - 0.5f) * 0.1f;
                this.normalizeMovement();
            }
            this.refreshMembers();
        }
    }

    private void resetStateTicks() {
        this.stateTicks = this.random.nextInt(this.state == State.MOVING ? 2000 : 4000) + 1000;
    }

    public void refreshMembers() {
        LinkedList<DinosaurEntity> remove = new LinkedList<DinosaurEntity>();
        for (DinosaurEntity entity : this) {
            if (!entity.isCarcass() && !entity.field_70128_L && !entity.getMetabolism().isStarving() && !entity.getMetabolism().isDehydrated()) continue;
            remove.add(entity);
        }
        this.members.removeAll(remove);
        AxisAlignedBB searchBounds = new AxisAlignedBB(this.center.field_72450_a - 16.0, this.center.field_72448_b - 5.0, this.center.field_72449_c - 16.0, this.center.field_72450_a + 16.0, this.center.field_72448_b + 5.0, this.center.field_72449_c + 16.0);
        LinkedList<Herd> otherHerds = new LinkedList<Herd>();
        for (DinosaurEntity entity : this.leader.field_70170_p.func_72872_a(DinosaurEntity.class, searchBounds)) {
            if (!((Object)((Object)this.leader)).getClass().isAssignableFrom(((Object)((Object)entity)).getClass()) || entity.isCarcass() || entity.field_70128_L || entity.getMetabolism().isStarving() || entity.getMetabolism().isDehydrated()) continue;
            Herd otherHerd = entity.herd;
            if (otherHerd == null) {
                if (this.size() >= this.herdType.getMaxHerdSize()) {
                    if (GameRuleHandler.KILL_HERD_OUTCAST.getBoolean(this.leader.field_70170_p) && this.herdType.getDiet().isCarnivorous() && !this.enemies.contains((Object)entity)) {
                        this.enemies.add((EntityLivingBase)entity);
                    }
                    return;
                }
                this.addMember(entity);
                continue;
            }
            if (otherHerd == this || otherHerds.contains(otherHerd)) continue;
            otherHerds.add(otherHerd);
        }
        for (Herd otherHerd : otherHerds) {
            int originalSize = this.size();
            if (otherHerd.size() <= originalSize && otherHerd.size() + originalSize < this.herdType.getMaxHerdSize()) {
                for (DinosaurEntity member : otherHerd) {
                    this.members.add(member);
                    member.herd = this;
                }
                otherHerd.disband();
                continue;
            }
            if (originalSize + 1 < this.herdType.getMaxHerdSize() || !GameRuleHandler.KILL_HERD_OUTCAST.getBoolean(this.leader.field_70170_p) || !this.herdType.getDiet().isCarnivorous()) continue;
            for (DinosaurEntity entity : otherHerd) {
                if (this.enemies.contains((Object)entity)) continue;
                this.enemies.add((EntityLivingBase)entity);
            }
        }
    }

    public void updateLeader() {
        this.leader = this.members.size() > 0 ? this.members.get(new Random().nextInt(this.members.size())) : null;
    }

    public Vec3d getCenterPosition() {
        double x = 0.0;
        double z = 0.0;
        int count = 0;
        for (DinosaurEntity member : this.members) {
            if (member.isCarcass() || member.func_70090_H()) continue;
            x += member.field_70165_t;
            z += member.field_70161_v;
            ++count;
        }
        return new Vec3d(x /= (double)count, (double)this.leader.field_70170_p.func_175645_m(new BlockPos(x, 0.0, z /= (double)count)).func_177956_o(), z);
    }

    public void addMember(DinosaurEntity entity) {
        if (entity.herd != null) {
            entity.herd.members.remove((Object)entity);
            if (entity.herd.leader == entity) {
                entity.herd.updateLeader();
            }
        }
        entity.herd = this;
        this.members.add(entity);
    }

    public void disband() {
        this.leader = null;
        this.members.clear();
    }

    public int size() {
        return this.members.size();
    }

    @Override
    public Iterator<DinosaurEntity> iterator() {
        return this.members.iterator();
    }

    public void normalizeMovement() {
        float length = (float)Math.sqrt(Math.pow(this.moveX, 2.0) + Math.pow(this.moveZ, 2.0));
        this.moveX /= length;
        this.moveZ /= length;
    }

    public boolean shouldDefend(List<EntityLivingBase> entities) {
        return this.getScore(this) + this.herdType.getAttackBias() * (double)this.members.size() > this.getScore(entities);
    }

    public double getScore(Iterable<? extends EntityLivingBase> entities) {
        double score = 0.0;
        for (EntityLivingBase entityLivingBase : entities) {
            if (entityLivingBase == null || entityLivingBase.func_110148_a(SharedMonsterAttributes.field_111264_e) == null) continue;
            score += (double)entityLivingBase.func_110143_aJ() * entityLivingBase.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b();
        }
        return score;
    }

    public static enum State {
        MOVING,
        STATIC;

    }
}

