/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.entity.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityLookHelper;
import net.minecraft.util.math.MathHelper;
import org.jurassicraft.server.entity.DinosaurEntity;

public class DinosaurLookHelper
extends EntityLookHelper {
    private DinosaurEntity dinosaur;
    private float deltaLookYaw;
    private float deltaLookPitch;
    private boolean isLooking;
    private double posX;
    private double posY;
    private double posZ;

    public DinosaurLookHelper(DinosaurEntity dinosaur) {
        super((EntityLiving)dinosaur);
        this.dinosaur = dinosaur;
    }

    public void func_75651_a(Entity entity, float deltaYaw, float deltaPitch) {
        this.posX = entity.field_70165_t;
        this.posY = entity instanceof EntityLivingBase ? entity.field_70163_u + (double)entity.func_70047_e() : (entity.func_174813_aQ().field_72338_b + entity.func_174813_aQ().field_72337_e) / 2.0;
        this.posZ = entity.field_70161_v;
        this.deltaLookYaw = deltaYaw;
        this.deltaLookPitch = deltaPitch;
        this.isLooking = true;
    }

    public void func_75650_a(double x, double y, double z, float deltaYaw, float deltaPitch) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.deltaLookYaw = deltaYaw;
        this.deltaLookPitch = deltaPitch;
        this.isLooking = true;
    }

    public void func_75649_a() {
        this.dinosaur.field_70125_A = 0.0f;
        if (this.isLooking) {
            this.isLooking = false;
            double deltaX = this.posX - this.dinosaur.field_70165_t;
            double deltaY = this.posY - (this.dinosaur.field_70163_u + (double)this.dinosaur.func_70047_e());
            double deltaZ = this.posZ - this.dinosaur.field_70161_v;
            double delta = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaZ * deltaZ));
            float desiredYaw = (float)(MathHelper.func_181159_b((double)deltaZ, (double)deltaX) * 57.29577951308232) - 90.0f;
            float desiredPitch = (float)(-(MathHelper.func_181159_b((double)deltaY, (double)delta) * 57.29577951308232));
            this.dinosaur.field_70125_A = this.updateRotation(this.dinosaur.field_70125_A, desiredPitch, this.deltaLookPitch);
            this.dinosaur.field_70759_as = this.updateRotation(this.dinosaur.field_70759_as, desiredYaw, this.deltaLookYaw);
        } else {
            this.dinosaur.field_70759_as = this.updateRotation(this.dinosaur.field_70759_as, this.dinosaur.field_70761_aq, 10.0f);
        }
    }

    private float updateRotation(float current, float desired, float range) {
        float offset = MathHelper.func_76142_g((float)(desired - current));
        if (offset > range) {
            offset = range;
        }
        if (offset < -range) {
            offset = -range;
        }
        return current + offset;
    }

    public boolean func_180424_b() {
        return this.isLooking;
    }

    public double func_180423_e() {
        return this.posX;
    }

    public double func_180422_f() {
        return this.posY;
    }

    public double func_180421_g() {
        return this.posZ;
    }
}

