/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import org.jurassicraft.JurassiCraft;
import org.jurassicraft.server.api.Hybrid;
import org.jurassicraft.server.dinosaur.BrachiosaurusDinosaur;
import org.jurassicraft.server.dinosaur.DilophosaurusDinosaur;
import org.jurassicraft.server.dinosaur.Dinosaur;
import org.jurassicraft.server.dinosaur.GallimimusDinosaur;
import org.jurassicraft.server.dinosaur.ParasaurolophusDinosaur;
import org.jurassicraft.server.dinosaur.TriceratopsDinosaur;
import org.jurassicraft.server.dinosaur.TyrannosaurusDinosaur;
import org.jurassicraft.server.dinosaur.VelociraptorDinosaur;
import org.jurassicraft.server.entity.DinosaurEntity;
import org.jurassicraft.server.entity.VenomEntity;
import org.jurassicraft.server.entity.item.AttractionSignEntity;
import org.jurassicraft.server.entity.item.MuralEntity;
import org.jurassicraft.server.entity.item.PaddockSignEntity;
import org.jurassicraft.server.entity.vehicle.JeepWranglerEntity;
import org.jurassicraft.server.entity.vehicle.modules.SeatEntity;
import org.jurassicraft.server.period.TimePeriod;

public class EntityHandler {
    public static final Dinosaur BRACHIOSAURUS = new BrachiosaurusDinosaur();
    public static final Dinosaur DILOPHOSAURUS = new DilophosaurusDinosaur();
    public static final Dinosaur GALLIMIMUS = new GallimimusDinosaur();
    public static final Dinosaur PARASAUROLOPHUS = new ParasaurolophusDinosaur();
    public static final Dinosaur TRICERATOPS = new TriceratopsDinosaur();
    public static final Dinosaur TYRANNOSAURUS = new TyrannosaurusDinosaur();
    public static final Dinosaur VELOCIRAPTOR = new VelociraptorDinosaur();
    private static final Map<Integer, Dinosaur> DINOSAURS = new HashMap<Integer, Dinosaur>();
    private static final Map<Dinosaur, Integer> DINOSAUR_IDS = new HashMap<Dinosaur, Integer>();
    private static final HashMap<TimePeriod, List<Dinosaur>> DINOSAUR_PERIODS = new HashMap();
    private static int entityId;
    private static ProgressManager.ProgressBar dinosaurProgress;
    private static int highestID;

    public static List<Dinosaur> getDinosaursFromSeaLampreys() {
        ArrayList<Dinosaur> marineDinos = new ArrayList<Dinosaur>();
        for (Dinosaur dino : EntityHandler.getRegisteredDinosaurs()) {
            if (!dino.isMarineAnimal() || dino instanceof Hybrid) continue;
            marineDinos.add(dino);
        }
        return marineDinos;
    }

    public static void init() {
        EntityHandler.registerDinosaur(0, VELOCIRAPTOR);
        EntityHandler.registerDinosaur(3, BRACHIOSAURUS);
        EntityHandler.registerDinosaur(7, DILOPHOSAURUS);
        EntityHandler.registerDinosaur(9, GALLIMIMUS);
        EntityHandler.registerDinosaur(13, PARASAUROLOPHUS);
        EntityHandler.registerDinosaur(19, TRICERATOPS);
        EntityHandler.registerDinosaur(20, TYRANNOSAURUS);
        dinosaurProgress = ProgressManager.push((String)"Loading dinosaurs", (int)DINOSAURS.size());
        EntityHandler.initDinosaurs();
        ProgressManager.pop((ProgressManager.ProgressBar)dinosaurProgress);
        EntityHandler.registerEntity(AttractionSignEntity.class, "Attraction Sign");
        EntityHandler.registerEntity(PaddockSignEntity.class, "Paddock Sign");
        EntityHandler.registerEntity(MuralEntity.class, "Mural");
        EntityHandler.registerEntity(VenomEntity.class, "Venom");
        EntityHandler.registerEntity(JeepWranglerEntity.class, "Jeep Wrangler");
        EntityHandler.registerEntity(SeatEntity.class, "Vehicle Seat");
    }

    private static void initDinosaurs() {
        for (Map.Entry<Integer, Dinosaur> entry : DINOSAURS.entrySet()) {
            boolean canSpawn;
            Dinosaur dinosaur = entry.getValue();
            dinosaurProgress.step(dinosaur.getName());
            dinosaur.init();
            boolean bl = canSpawn = !(dinosaur instanceof Hybrid) && dinosaur.shouldRegister();
            if (canSpawn) {
                TimePeriod period = dinosaur.getPeriod();
                List<Dinosaur> periods = DINOSAUR_PERIODS.get((Object)period);
                if (periods == null) {
                    periods = new LinkedList<Dinosaur>();
                    DINOSAUR_PERIODS.put(period, periods);
                }
                periods.add(dinosaur);
            }
            Class<? extends DinosaurEntity> clazz = dinosaur.getDinosaurClass();
            EntityHandler.registerEntity(clazz, dinosaur.getName());
            if (!canSpawn || !JurassiCraft.CONFIG.naturalSpawning) continue;
            EntityRegistry.addSpawn(clazz, (int)dinosaur.getSpawnChance(), (int)1, (int)Math.min(6, dinosaur.getMaxHerdSize() / 2), (EnumCreatureType)(dinosaur.isMarineAnimal() ? EnumCreatureType.WATER_CREATURE : EnumCreatureType.CREATURE), (Biome[])dinosaur.getSpawnBiomes());
        }
    }

    private static void registerEntity(Class<? extends Entity> entity, String name) {
        String formattedName = name.toLowerCase(Locale.ENGLISH).replaceAll(" ", "_");
        EntityRegistry.registerModEntity(entity, (String)formattedName, (int)entityId++, (Object)JurassiCraft.INSTANCE, (int)1024, (int)1, (boolean)true);
    }

    public static void registerDinosaur(int id, Dinosaur dinosaur) {
        if (id > highestID) {
            highestID = id;
        }
        DINOSAURS.put(id, dinosaur);
        DINOSAUR_IDS.put(dinosaur, id);
    }

    public static Dinosaur getDinosaurById(int id) {
        Dinosaur dinosaur = DINOSAURS.get(id);
        return dinosaur != null ? dinosaur : EntityHandler.getDinosaurById(0);
    }

    public static int getDinosaurId(Dinosaur dinosaur) {
        return DINOSAUR_IDS.get(dinosaur);
    }

    public static List<Dinosaur> getDinosaursFromAmber() {
        LinkedList<Dinosaur> amberDinos = new LinkedList<Dinosaur>();
        for (Dinosaur dino : EntityHandler.getRegisteredDinosaurs()) {
            if (dino.isMarineAnimal() || dino instanceof Hybrid) continue;
            amberDinos.add(dino);
        }
        return amberDinos;
    }

    public static Map<Integer, Dinosaur> getDinosaurs() {
        return DINOSAURS;
    }

    public static List<Dinosaur> getRegisteredDinosaurs() {
        LinkedList<Dinosaur> dinosaurs = new LinkedList<Dinosaur>();
        for (Map.Entry<Integer, Dinosaur> entry : DINOSAURS.entrySet()) {
            Dinosaur dinosaur = entry.getValue();
            if (!dinosaur.shouldRegister()) continue;
            dinosaurs.add(dinosaur);
        }
        return dinosaurs;
    }

    public static List<Dinosaur> getPrehistoricDinosaurs() {
        LinkedList<Dinosaur> dinosaurs = new LinkedList<Dinosaur>();
        for (Map.Entry<Integer, Dinosaur> entry : DINOSAURS.entrySet()) {
            Dinosaur dinosaur = entry.getValue();
            if (!dinosaur.shouldRegister() || dinosaur instanceof Hybrid) continue;
            dinosaurs.add(dinosaur);
        }
        return dinosaurs;
    }

    public static List<Dinosaur> getDinosaursFromPeriod(TimePeriod period) {
        return DINOSAUR_PERIODS.get((Object)period);
    }

    public static Dinosaur getDinosaurByClass(Class<? extends DinosaurEntity> clazz) {
        for (Map.Entry<Integer, Dinosaur> entry : DINOSAURS.entrySet()) {
            Dinosaur dinosaur = entry.getValue();
            if (!dinosaur.getDinosaurClass().equals(clazz)) continue;
            return dinosaur;
        }
        return null;
    }

    public static int getHighestID() {
        return highestID;
    }
}

