/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.block.plant;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.server.tab.TabHandler;
import org.jurassicraft.server.util.GameRuleHandler;

public class AncientPlantBlock
extends BlockBush {
    private static final int DENSITY_PER_AREA = 4;
    private static final int SPREAD_RADIUS = 6;

    public AncientPlantBlock(Material material) {
        super(material);
        this.func_149647_a(TabHandler.PLANTS);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149675_a(true);
    }

    public AncientPlantBlock() {
        this(Material.field_151585_k);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        int light;
        if (GameRuleHandler.PLANT_SPREADING.getBoolean(world) && (light = world.func_175699_k(pos)) >= 5 && rand.nextInt((15 - light) / 2 + 10) == 0) {
            int allowedInArea = 4;
            BlockPos nextPos = null;
            for (int placementAttempts = 3; nextPos == null && placementAttempts > 0; --placementAttempts) {
                int doubleRadius = 12;
                BlockPos tmp = pos.func_177982_a(rand.nextInt(doubleRadius) - 6, -6, rand.nextInt(doubleRadius) - 6);
                nextPos = this.findGround(world, tmp);
            }
            if (nextPos != null) {
                for (BlockPos neighbourPos : BlockPos.func_177975_b((BlockPos)nextPos.func_177982_a(-2, -3, -2), (BlockPos)nextPos.func_177982_a(2, 3, 2))) {
                    if (!(world.func_180495_p(neighbourPos).func_177230_c() instanceof BlockBush) || --allowedInArea > 0) continue;
                    return;
                }
                if (this.isNearWater(world, pos)) {
                    this.spread(world, nextPos);
                }
            }
        }
    }

    private boolean isNearWater(World world, BlockPos nextPos) {
        for (BlockPos neighbourPos : BlockPos.func_177975_b((BlockPos)nextPos.func_177982_a(-8, -3, -8), (BlockPos)nextPos.func_177982_a(8, 3, 8))) {
            Block neighbourState = world.func_180495_p(neighbourPos).func_177230_c();
            if (neighbourState != Blocks.field_150355_j && neighbourState != Blocks.field_150358_i || !(neighbourPos.func_185332_f(nextPos.func_177958_n(), nextPos.func_177956_o(), nextPos.func_177952_p()) < 9.0)) continue;
            return true;
        }
        return false;
    }

    protected void spread(World world, BlockPos position) {
        world.func_175656_a(position, this.func_176223_P());
    }

    private BlockPos findGround(World world, BlockPos start) {
        BlockPos pos = start;
        IBlockState down = world.func_180495_p(pos.func_177977_b());
        IBlockState here = world.func_180495_p(pos);
        IBlockState up = world.func_180495_p(pos.func_177984_a());
        for (int i = 0; i < 8; ++i) {
            if (this.canPlace(down, here, up)) {
                return pos;
            }
            down = here;
            here = up;
            pos = pos.func_177984_a();
            up = world.func_180495_p(pos.func_177984_a());
        }
        return null;
    }

    protected boolean canPlace(IBlockState down, IBlockState here, IBlockState up) {
        return this.func_185514_i(down) && here.func_177230_c() == Blocks.field_150350_a;
    }

    @SideOnly(value=Side.CLIENT)
    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.XZ;
    }
}

