/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.client.proxy;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.ilexiconn.llibrary.client.lang.LanguageHandler;
import net.ilexiconn.llibrary.server.util.WebUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.client.event.ClientEventHandler;
import org.jurassicraft.client.gui.CleaningStationGui;
import org.jurassicraft.client.gui.CultivateGui;
import org.jurassicraft.client.gui.CultivateProcessGui;
import org.jurassicraft.client.gui.DNACombinatorHybridizerGui;
import org.jurassicraft.client.gui.DNAExtractorGui;
import org.jurassicraft.client.gui.DNASequencerGui;
import org.jurassicraft.client.gui.DNASynthesizerGui;
import org.jurassicraft.client.gui.EmbryoCalcificationMachineGui;
import org.jurassicraft.client.gui.EmbryonicMachineGui;
import org.jurassicraft.client.gui.FeederGui;
import org.jurassicraft.client.gui.FieldGuideGui;
import org.jurassicraft.client.gui.FossilGrinderGui;
import org.jurassicraft.client.gui.IncubatorGui;
import org.jurassicraft.client.gui.OrderDinosaurGui;
import org.jurassicraft.client.gui.SelectDinoGui;
import org.jurassicraft.client.render.RenderingHandler;
import org.jurassicraft.server.block.entity.CleaningStationBlockEntity;
import org.jurassicraft.server.block.entity.CultivatorBlockEntity;
import org.jurassicraft.server.block.entity.DNACombinatorHybridizerBlockEntity;
import org.jurassicraft.server.block.entity.DNAExtractorBlockEntity;
import org.jurassicraft.server.block.entity.DNASequencerBlockEntity;
import org.jurassicraft.server.block.entity.DNASynthesizerBlockEntity;
import org.jurassicraft.server.block.entity.EmbryoCalcificationMachineBlockEntity;
import org.jurassicraft.server.block.entity.EmbryonicMachineBlockEntity;
import org.jurassicraft.server.block.entity.FeederBlockEntity;
import org.jurassicraft.server.block.entity.FossilGrinderBlockEntity;
import org.jurassicraft.server.block.entity.IncubatorBlockEntity;
import org.jurassicraft.server.entity.DinosaurEntity;
import org.jurassicraft.server.entity.VenomEntity;
import org.jurassicraft.server.entity.particle.VenomParticle;
import org.jurassicraft.server.entity.vehicle.CarEntity;
import org.jurassicraft.server.proxy.ServerProxy;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends ServerProxy {
    private static final Minecraft MC = Minecraft.func_71410_x();
    public static final List<UUID> PATRONS = new ArrayList<UUID>();

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        try {
            LanguageHandler.INSTANCE.loadRemoteLocalization("jurassicraft");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ClientEventHandler eventHandler = new ClientEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)eventHandler);
        RenderingHandler.INSTANCE.preInit();
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        RenderingHandler.INSTANCE.init();
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
        RenderingHandler.INSTANCE.postInit();
        new Thread(() -> {
            List patrons = WebUtils.readPastebinAsList((String)"fgJQkCMa");
            if (patrons != null) {
                for (String patron : patrons) {
                    PATRONS.add(UUID.fromString(patron));
                }
            }
        }).start();
    }

    @Override
    public EntityPlayer getPlayer() {
        return ClientProxy.MC.field_71439_g;
    }

    @Override
    public EntityPlayer getPlayerEntityFromContext(MessageContext ctx) {
        return ctx.side.isClient() ? this.getPlayer() : super.getPlayerEntityFromContext(ctx);
    }

    @Override
    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null) {
            if (tileEntity instanceof CleaningStationBlockEntity && id == 0) {
                return new CleaningStationGui(player.field_71071_by, (IInventory)((CleaningStationBlockEntity)tileEntity));
            }
            if (tileEntity instanceof FossilGrinderBlockEntity && id == 1) {
                return new FossilGrinderGui(player.field_71071_by, (IInventory)((FossilGrinderBlockEntity)tileEntity));
            }
            if (tileEntity instanceof DNASequencerBlockEntity && id == 2) {
                return new DNASequencerGui(player.field_71071_by, (IInventory)((DNASequencerBlockEntity)tileEntity));
            }
            if (tileEntity instanceof EmbryonicMachineBlockEntity && id == 3) {
                return new EmbryonicMachineGui(player.field_71071_by, (IInventory)((EmbryonicMachineBlockEntity)tileEntity));
            }
            if (tileEntity instanceof EmbryoCalcificationMachineBlockEntity && id == 4) {
                return new EmbryoCalcificationMachineGui(player.field_71071_by, (IInventory)((EmbryoCalcificationMachineBlockEntity)tileEntity));
            }
            if (tileEntity instanceof DNASynthesizerBlockEntity && id == 5) {
                return new DNASynthesizerGui(player.field_71071_by, (IInventory)((DNASynthesizerBlockEntity)tileEntity));
            }
            if (tileEntity instanceof IncubatorBlockEntity && id == 6) {
                return new IncubatorGui(player.field_71071_by, (IInventory)((IncubatorBlockEntity)tileEntity));
            }
            if (tileEntity instanceof DNACombinatorHybridizerBlockEntity && id == 7) {
                return new DNACombinatorHybridizerGui(player.field_71071_by, (DNACombinatorHybridizerBlockEntity)tileEntity);
            }
            if (tileEntity instanceof DNAExtractorBlockEntity && id == 8) {
                return new DNAExtractorGui(player.field_71071_by, (IInventory)((DNAExtractorBlockEntity)tileEntity));
            }
            if (tileEntity instanceof CultivatorBlockEntity && id == 9) {
                CultivatorBlockEntity cultivator = (CultivatorBlockEntity)tileEntity;
                if (cultivator.isProcessing(0)) {
                    return new CultivateProcessGui(cultivator);
                }
                return new CultivateGui(player.field_71071_by, cultivator);
            }
            if (tileEntity instanceof FeederBlockEntity && id == 10) {
                return new FeederGui(player.field_71071_by, (IInventory)((FeederBlockEntity)tileEntity));
            }
        }
        return null;
    }

    @Override
    public void openSelectDino(BlockPos pos, EnumFacing facing, EnumHand hand) {
        MC.func_147108_a((GuiScreen)new SelectDinoGui(pos, facing, hand));
    }

    @Override
    public void openOrderGui(DinosaurEntity entity) {
        MC.func_147108_a((GuiScreen)new OrderDinosaurGui(entity));
    }

    @Override
    public void openFieldGuide(DinosaurEntity entity, DinosaurEntity.FieldGuideInfo fieldGuideInfo) {
        MC.func_147108_a((GuiScreen)new FieldGuideGui(entity, fieldGuideInfo));
    }

    public static void playSound(ISound sound) {
        MC.func_147118_V().func_147682_a(sound);
    }

    public static void stopSound(ISound sound) {
        MC.func_147118_V().func_147683_b(sound);
    }

    public static void playSound(CarEntity entity) {
        ClientProxy.playSound((ISound)entity.sound);
    }

    public static void stopSound(CarEntity entity) {
        ClientProxy.stopSound((ISound)entity.sound);
    }

    public static void spawnVenomParticles(VenomEntity entity) {
        ParticleManager particleManager = Minecraft.func_71410_x().field_71452_i;
        float size = 0.35f;
        for (int i = 0; i < 16; ++i) {
            particleManager.func_78873_a((Particle)new VenomParticle(entity.field_70170_p, (double)size * Math.random() - (double)(size / 2.0f), (double)size * Math.random() - (double)(size / 2.0f), (double)size * Math.random() - (double)(size / 2.0f), 0.0, 0.0, 0.0, 1.0f, entity));
        }
    }
}

