/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.client.model.animation.dto;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import org.jurassicraft.client.model.animation.dto.GrowthRenderDef;
import org.jurassicraft.server.entity.GrowthStage;

public class DinosaurRenderDefDTO {
    public int version;
    public Map<GrowthStage, GrowthRenderDef> perStage;

    public static class DinosaurDeserializer
    implements JsonDeserializer<DinosaurRenderDefDTO> {
        public DinosaurRenderDefDTO deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject def = json.getAsJsonObject();
            DinosaurRenderDefDTO built = new DinosaurRenderDefDTO();
            built.version = def.get("version") == null ? 0 : def.get("version").getAsInt();
            built.perStage = new EnumMap<GrowthStage, GrowthRenderDef>(GrowthStage.class);
            for (GrowthStage g : GrowthStage.values) {
                GrowthRenderDef renderDef;
                JsonElement perhaps = def.get(g.name());
                GrowthRenderDef growthRenderDef = renderDef = perhaps == null ? new GrowthRenderDef() : (GrowthRenderDef)context.deserialize(perhaps, GrowthRenderDef.class);
                if (renderDef.directory == null || renderDef.directory.isEmpty()) {
                    renderDef.directory = g.name().toLowerCase(Locale.ROOT);
                }
                built.perStage.put(g, renderDef);
            }
            return built;
        }
    }
}

