/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.client.model.animation;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import net.ilexiconn.llibrary.client.model.tools.AdvancedModelRenderer;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.JurassiCraft;
import org.jurassicraft.client.model.DinosaurModel;
import org.jurassicraft.client.model.animation.DinosaurAnimation;
import org.jurassicraft.client.model.animation.JabelarAnimationHandler;
import org.jurassicraft.client.model.animation.PosedCuboid;
import org.jurassicraft.client.model.animation.dto.AnimationsDTO;
import org.jurassicraft.client.model.animation.dto.DinosaurRenderDefDTO;
import org.jurassicraft.client.model.animation.dto.PoseDTO;
import org.jurassicraft.server.dinosaur.Dinosaur;
import org.jurassicraft.server.entity.DinosaurEntity;
import org.jurassicraft.server.entity.GrowthStage;
import org.jurassicraft.server.tabula.TabulaModelHelper;

public class PoseHandler {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(DinosaurRenderDefDTO.class, (Object)new DinosaurRenderDefDTO.DinosaurDeserializer()).create();
    private Map<GrowthStage, ModelData> modelData;

    public PoseHandler(Dinosaur dinosaur) {
        URI dinosaurResourceURI;
        String name = dinosaur.getName().toLowerCase(Locale.ENGLISH).replaceAll(" ", "_");
        this.modelData = new EnumMap<GrowthStage, ModelData>(GrowthStage.class);
        try {
            dinosaurResourceURI = new URI("/assets/jurassicraft/models/entities/" + name + "/");
        }
        catch (URISyntaxException e) {
            JurassiCraft.INSTANCE.getLogger().fatal("Illegal URI /assets/jurassicraft/models/entities/" + name + "/", (Throwable)e);
            return;
        }
        for (GrowthStage growth : GrowthStage.values()) {
            try {
                GrowthStage actualGrowth = growth;
                if (!dinosaur.doesSupportGrowthStage(actualGrowth)) {
                    actualGrowth = GrowthStage.ADULT;
                }
                if (this.modelData.containsKey((Object)actualGrowth)) {
                    this.modelData.put(growth, this.modelData.get((Object)actualGrowth));
                    continue;
                }
                ModelData loaded = this.loadModelData(dinosaurResourceURI, name, actualGrowth);
                this.modelData.put(growth, loaded);
                if (actualGrowth == growth) continue;
                this.modelData.put(actualGrowth, loaded);
            }
            catch (Exception e) {
                JurassiCraft.INSTANCE.getLogger().fatal("Failed to parse growth stage " + (Object)((Object)growth) + " for dinosaur " + name, (Throwable)e);
                this.modelData.put(growth, new ModelData());
            }
        }
    }

    private ModelData loadModelData(URI resourceURI, String name, GrowthStage growth) {
        String growthName = growth.name().toLowerCase(Locale.ROOT);
        URI growthSensitiveDir = resourceURI.resolve(growthName + "/");
        URI definitionFile = growthSensitiveDir.resolve(name + "_" + growthName + ".json");
        InputStream modelIn = TabulaModelHelper.class.getResourceAsStream(definitionFile.toString());
        if (modelIn == null) {
            throw new IllegalArgumentException("No model definition for the dino " + name + " with grow-state " + (Object)((Object)growth) + " exists. Expected at " + definitionFile);
        }
        try {
            InputStreamReader reader = new InputStreamReader(modelIn);
            AnimationsDTO rawAnimations = (AnimationsDTO)GSON.fromJson((Reader)reader, AnimationsDTO.class);
            ModelData data = this.loadModelData(growthSensitiveDir, rawAnimations);
            JurassiCraft.INSTANCE.getLogger().debug("Successfully loaded " + name + "(" + (Object)((Object)growth) + ") from " + definitionFile);
            ((Reader)reader).close();
            return data;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private ModelData loadModelData(URI resourceURI, AnimationsDTO animationsDefinition) {
        if (animationsDefinition == null || animationsDefinition.poses == null || animationsDefinition.poses.get(DinosaurAnimation.IDLE.name()) == null || animationsDefinition.poses.get(DinosaurAnimation.IDLE.name()).length == 0) {
            throw new IllegalArgumentException("Animation files must define at least one pose for the IDLE animation");
        }
        ArrayList<String> posedModelResources = new ArrayList<String>();
        for (PoseDTO[] poseDTOArray : animationsDefinition.poses.values()) {
            if (poseDTOArray == null) continue;
            for (PoseDTO pose : poseDTOArray) {
                if (pose == null) continue;
                if (pose.pose == null) {
                    throw new IllegalArgumentException("Every pose must define a pose file");
                }
                String resolvedRes = this.resolve(resourceURI, pose.pose);
                int index = posedModelResources.indexOf(resolvedRes);
                if (index == -1) {
                    pose.index = posedModelResources.size();
                    posedModelResources.add(resolvedRes);
                    continue;
                }
                pose.index = index;
            }
        }
        HashMap<Animation, float[][]> animations = new HashMap<Animation, float[][]>();
        for (Map.Entry<String, PoseDTO[]> entry : animationsDefinition.poses.entrySet()) {
            Animation animation = DinosaurAnimation.valueOf(entry.getKey()).get();
            PoseDTO[] poses = entry.getValue();
            float[][] poseSequence = new float[poses.length][2];
            for (int i = 0; i < poses.length; ++i) {
                poseSequence[i][0] = poses[i].index;
                poseSequence[i][1] = poses[i].time;
            }
            animations.put(animation, poseSequence);
        }
        if (FMLCommonHandler.instance().getSide().isClient()) {
            PosedCuboid[][] posedCuboidArray = new PosedCuboid[posedModelResources.size()][];
            DinosaurModel dinosaurModel = JabelarAnimationHandler.loadModel((String)posedModelResources.get(0));
            if (dinosaurModel == null) {
                throw new IllegalArgumentException("Couldn't load the model from " + (String)posedModelResources.get(0));
            }
            String[] cubeIdentifierArray = dinosaurModel.getCubeIdentifierArray();
            int partCount = cubeIdentifierArray.length;
            for (int i = 0; i < posedModelResources.size(); ++i) {
                String resource = (String)posedModelResources.get(i);
                DinosaurModel model = JabelarAnimationHandler.loadModel(resource);
                if (model == null) {
                    throw new IllegalArgumentException("Couldn't load the model from " + resource);
                }
                PosedCuboid[] pose = new PosedCuboid[partCount];
                for (int partIndex = 0; partIndex < partCount; ++partIndex) {
                    String identifier = cubeIdentifierArray[partIndex];
                    AdvancedModelRenderer cube = model.getCubeByIdentifier(identifier);
                    if (cube == null) {
                        JurassiCraft.INSTANCE.getLogger().error("Could not retrieve cube " + identifier + " (" + partIndex + ") from the model " + resource);
                    }
                    pose[partIndex] = new PosedCuboid(cube);
                }
                posedCuboidArray[i] = pose;
            }
            return new ModelData(posedCuboidArray, animations);
        }
        return new ModelData(animations);
    }

    private String resolve(URI dinoDirURI, String posePath) {
        URI uri = dinoDirURI.resolve(posePath);
        return uri.toString();
    }

    public JabelarAnimationHandler createAnimationHandler(DinosaurEntity entity, DinosaurModel model, GrowthStage growthStage, boolean useInertialTweens) {
        ModelData growthModel = this.modelData.get((Object)growthStage);
        if (!entity.getDinosaur().doesSupportGrowthStage(growthStage)) {
            growthModel = this.modelData.get((Object)growthStage);
        }
        return new JabelarAnimationHandler(entity, model, growthModel.poses, growthModel.animations, useInertialTweens);
    }

    public Map<Animation, float[][]> getAnimations(GrowthStage growthStage) {
        return this.modelData.get((Object)((Object)growthStage)).animations;
    }

    public float getAnimationLength(Animation animation, GrowthStage growthStage) {
        float[][] poses;
        Map<Animation, float[][]> animations = this.getAnimations(growthStage);
        float duration = 0.0f;
        if (animation != null && (poses = animations.get(animation)) != null) {
            for (float[] pose : poses) {
                duration += pose[1];
            }
        }
        return duration;
    }

    public boolean hasAnimation(Animation animation, GrowthStage growthStage) {
        return this.modelData.get((Object)((Object)growthStage)).animations.get(animation) != null;
    }

    private class ModelData {
        @SideOnly(value=Side.CLIENT)
        PosedCuboid[][] poses;
        Map<Animation, float[][]> animations;

        public ModelData() {
            this(null);
        }

        public ModelData(PosedCuboid[][] cuboids, Map<Animation, float[][]> animations) {
            this(animations);
            if (cuboids == null) {
                cuboids = new PosedCuboid[][]{};
            }
            this.poses = cuboids;
        }

        public ModelData(Map<Animation, float[][]> animations) {
            if (animations == null) {
                animations = new LinkedHashMap<Animation, float[][]>();
            }
            this.animations = animations;
        }
    }
}

